/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth.oauth2.protocol;

import com.fasterxml.jackson.databind.ObjectReader;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import org.apache.pulsar.client.impl.auth.oauth2.protocol.Metadata;
import org.apache.pulsar.client.impl.auth.oauth2.protocol.MetadataResolver;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Response;

public class DefaultMetadataResolver
implements MetadataResolver {
    private static final String WELL_KNOWN_PREFIX = "/.well-known/";
    private static final String DEFAULT_WELL_KNOWN_METADATA_PATH = "/.well-known/openid-configuration";
    public static final String OAUTH_WELL_KNOWN_METADATA_PATH = "/.well-known/oauth-authorization-server";
    private final URL metadataUrl;
    private final ObjectReader objectReader;
    private final AsyncHttpClient httpClient;

    public DefaultMetadataResolver(URL metadataUrl, AsyncHttpClient httpClient) {
        this.metadataUrl = metadataUrl;
        this.objectReader = ObjectMapperFactory.getMapper().reader().forType(Metadata.class);
        this.httpClient = httpClient;
    }

    public static DefaultMetadataResolver fromIssuerUrl(URL issuerUrl, AsyncHttpClient httpClient, String wellKnownMetadataPath) {
        return new DefaultMetadataResolver(DefaultMetadataResolver.getWellKnownMetadataUrl(issuerUrl, wellKnownMetadataPath), httpClient);
    }

    public static URL getWellKnownMetadataUrl(URL issuerUrl, String wellKnownMetadataPath) {
        try {
            if (wellKnownMetadataPath == null || wellKnownMetadataPath.isEmpty()) {
                return URI.create(issuerUrl.toExternalForm() + DEFAULT_WELL_KNOWN_METADATA_PATH).normalize().toURL();
            }
            if (wellKnownMetadataPath.startsWith(WELL_KNOWN_PREFIX)) {
                String issuerUrlString = issuerUrl.toExternalForm();
                URL url = new URL(issuerUrlString);
                String path = url.getPath();
                String basePath = issuerUrlString.substring(0, issuerUrlString.length() - (path.isEmpty() ? 0 : path.length()));
                return URI.create(basePath + wellKnownMetadataPath + path).normalize().toURL();
            }
            throw new IllegalArgumentException("Metadata path must start with '/.well-known/', but was: " + wellKnownMetadataPath);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Metadata resolve() throws IOException {
        try {
            Metadata metadata;
            Response response = (Response)((BoundRequestBuilder)this.httpClient.prepareGet(this.metadataUrl.toString()).addHeader((CharSequence)HttpHeaderNames.ACCEPT, (Object)HttpHeaderValues.APPLICATION_JSON)).execute().toCompletableFuture().get();
            try (InputStream inputStream = response.getResponseBodyAsStream();){
                metadata = (Metadata)this.objectReader.readValue(inputStream);
            }
            return metadata;
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new IOException("Cannot obtain authorization metadata from " + String.valueOf(this.metadataUrl), e);
        }
    }
}

