/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.enablement;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Interceptor;

public class ModuleEnablement {
    public static final ModuleEnablement EMPTY_ENABLEMENT = new ModuleEnablement(Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), Collections.emptySet(), Collections.emptySet());
    private final List<Class<?>> interceptors;
    private final List<Class<?>> decorators;
    private final Map<Class<?>, Integer> interceptorMap;
    private final Map<Class<?>, Integer> decoratorMap;
    private final Map<Class<?>, Integer> globalAlternatives;
    private final Set<Class<?>> localAlternativeClasses;
    private final Set<Class<? extends Annotation>> localAlternativeStereotypes;
    private final Comparator<Decorator<?>> decoratorComparator;
    private final Comparator<Interceptor<?>> interceptorComparator;

    public ModuleEnablement(List<Class<?>> interceptors, List<Class<?>> decorators, Map<Class<?>, Integer> globalAlternatives, Set<Class<?>> localAlternativeClasses, Set<Class<? extends Annotation>> localAlternativeStereotypes) {
        this.interceptors = interceptors;
        this.decorators = decorators;
        this.interceptorMap = ModuleEnablement.createLookupMap(interceptors);
        this.decoratorMap = ModuleEnablement.createLookupMap(decorators);
        this.decoratorComparator = new EnablementComparator(this.decoratorMap);
        this.interceptorComparator = new EnablementComparator(this.interceptorMap);
        this.globalAlternatives = globalAlternatives;
        this.localAlternativeClasses = localAlternativeClasses;
        this.localAlternativeStereotypes = localAlternativeStereotypes;
    }

    private static Map<Class<?>, Integer> createLookupMap(List<Class<?>> list) {
        if (list.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap result = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            result.put(list.get(i), i);
        }
        return ImmutableMap.copyOf(result);
    }

    public boolean isInterceptorEnabled(Class<?> javaClass) {
        return this.interceptorMap.containsKey(javaClass);
    }

    public boolean isDecoratorEnabled(Class<?> javaClass) {
        return this.decoratorMap.containsKey(javaClass);
    }

    public List<Class<?>> getInterceptors() {
        return this.interceptors;
    }

    public List<Class<?>> getDecorators() {
        return this.decorators;
    }

    public Comparator<Decorator<?>> getDecoratorComparator() {
        return this.decoratorComparator;
    }

    public Comparator<Interceptor<?>> getInterceptorComparator() {
        return this.interceptorComparator;
    }

    public Integer getAlternativePriority(Class<?> javaClass) {
        return this.globalAlternatives.get(javaClass);
    }

    public boolean isEnabledAlternativeClass(Class<?> alternativeClass) {
        return this.globalAlternatives.containsKey(alternativeClass) || this.localAlternativeClasses.contains(alternativeClass);
    }

    public boolean isEnabledAlternativeStereotype(Class<?> alternativeClass) {
        return this.globalAlternatives.containsKey(alternativeClass) || this.localAlternativeStereotypes.contains(alternativeClass);
    }

    public Set<Class<?>> getAlternativeClasses() {
        return this.localAlternativeClasses;
    }

    public Set<Class<? extends Annotation>> getAlternativeStereotypes() {
        return this.localAlternativeStereotypes;
    }

    public Set<Class<?>> getGlobalAlternatives() {
        return this.globalAlternatives.keySet();
    }

    public Set<Class<?>> getAllAlternatives() {
        return Sets.union(Sets.union(this.localAlternativeClasses, this.localAlternativeStereotypes), this.getGlobalAlternatives());
    }

    public String toString() {
        return "ModuleEnablement [interceptors=" + this.interceptors + ", decorators=" + this.decorators + ", alternatives=" + this.getAllAlternatives() + "]";
    }

    private static class EnablementComparator<T extends Bean<?>>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = -4757462262711016985L;
        private final Map<Class<?>, Integer> enabledClasses;

        public EnablementComparator(Map<Class<?>, Integer> enabledClasses) {
            this.enabledClasses = enabledClasses;
        }

        @Override
        public int compare(T o1, T o2) {
            int p1 = this.enabledClasses.get(o1.getBeanClass());
            int p2 = this.enabledClasses.get(o2.getBeanClass());
            return p1 - p2;
        }
    }
}

