/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.portlet.rewriter.rules.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.portals.applications.webcontent2.portlet.rewriter.rules.Attribute;
import org.apache.portals.applications.webcontent2.portlet.rewriter.rules.Rule;
import org.apache.portals.applications.webcontent2.portlet.rewriter.rules.Ruleset;
import org.apache.portals.applications.webcontent2.portlet.rewriter.rules.Tag;
import org.apache.portals.applications.webcontent2.portlet.rewriter.rules.impl.AttributeImpl;
import org.apache.portals.applications.webcontent2.portlet.rewriter.rules.impl.IdentifiedImpl;
import org.apache.portals.applications.webcontent2.portlet.rewriter.rules.impl.RuleImpl;
import org.apache.portals.applications.webcontent2.portlet.rewriter.rules.impl.TagImpl;

public class RulesetImpl
extends IdentifiedImpl
implements Ruleset {
    private Collection rules = new ArrayList();
    private Collection tags = new ArrayList();
    private Map ruleMap = new HashMap();
    private Map tagMap = new HashMap();
    private boolean removeComments = false;

    @Override
    public Tag getTag(String tagId) {
        return (Tag)this.tagMap.get(tagId);
    }

    @Override
    public Rule getRule(String ruleId) {
        return (Rule)this.ruleMap.get(ruleId);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Ruleset:" + this.id);
        if (this.rules.size() == 0) {
            buffer.append(", no rules defined, ");
        } else {
            buffer.append(", rules: ");
            for (RuleImpl rule : this.rules) {
                buffer.append(rule.toString());
                buffer.append(", ");
            }
        }
        if (this.tags.size() == 0) {
            buffer.append(" no tags defined.");
        } else {
            buffer.append("tags: ");
            for (TagImpl tag : this.tags) {
                buffer.append(tag.toString());
                buffer.append(", ");
            }
        }
        return buffer.toString();
    }

    @Override
    public void sync() {
        this.ruleMap.clear();
        for (Rule rule : this.rules) {
            this.ruleMap.put(rule.getId(), rule);
        }
        this.tagMap.clear();
        for (Tag tag : this.tags) {
            this.tagMap.put(tag.getId(), tag);
            for (Attribute attribute : tag.getAttributes()) {
                String ruleId;
                Rule rule;
                if (!(attribute instanceof AttributeImpl) || (rule = (Rule)this.ruleMap.get(ruleId = ((AttributeImpl)attribute).getRuleId())) == null) continue;
                attribute.setRule(rule);
            }
        }
    }

    public void setRules(Collection rules) {
        this.rules = rules;
    }

    @Override
    public Collection getRules() {
        return this.rules;
    }

    public void setTags(Collection tags) {
        this.tags = tags;
    }

    @Override
    public Collection getTags() {
        return this.tags;
    }

    @Override
    public boolean getRemoveComments() {
        return this.removeComments;
    }

    @Override
    public void setRemoveComments(boolean b) {
        this.removeComments = b;
    }
}

