/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.util;

import org.apache.openmeetings.core.mail.MailHandler;
import org.apache.openmeetings.db.dao.user.PrivateMessageDao;
import org.apache.openmeetings.db.dao.user.UserContactDao;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.entity.user.UserContact;
import org.apache.openmeetings.service.mail.template.RequestContactConfirmTemplate;
import org.apache.openmeetings.service.mail.template.RequestContactTemplate;
import org.apache.openmeetings.web.app.Application;
import org.apache.openmeetings.web.app.WebSession;

public class ContactsHelper {
    private ContactsHelper() {
    }

    public static Object addUserToContactList(long userIdToAdd) {
        boolean isContact = Application.get().getBean(UserContactDao.class).isContact(Long.valueOf(userIdToAdd), WebSession.getUserId());
        if (isContact) {
            return "error.contact.added";
        }
        UserContact contact = Application.get().getBean(UserContactDao.class).add(Long.valueOf(userIdToAdd), WebSession.getUserId(), true);
        User user = contact.getOwner();
        User userToAdd = contact.getContact();
        String subj = user.getDisplayName() + " " + Application.getString("1193");
        String message = RequestContactTemplate.getEmail((User)userToAdd, (User)user);
        Application.get().getBean(PrivateMessageDao.class).addPrivateMessage(subj, message, user, userToAdd, userToAdd, true, contact.getId());
        if (userToAdd.getAddress() != null) {
            Application.get().getBean(MailHandler.class).send(userToAdd.getAddress().getEmail(), subj, message);
        }
        return contact;
    }

    public static Object acceptUserContact(long userContactId) {
        UserContactDao dao = Application.get().getBean(UserContactDao.class);
        UserContact contact = dao.get(Long.valueOf(userContactId));
        if (contact == null) {
            return "error.contact.denied";
        }
        if (!contact.isPending()) {
            return "error.contact.approved";
        }
        dao.updateContactStatus(Long.valueOf(userContactId), false);
        contact = dao.get(Long.valueOf(userContactId));
        User user = contact.getOwner();
        dao.add(user.getId(), WebSession.getUserId(), false);
        if (user.getAddress() != null) {
            String message = RequestContactConfirmTemplate.getEmail((UserContact)contact);
            String subj = contact.getContact().getDisplayName() + " " + Application.getString("1198");
            Application.get().getBean(PrivateMessageDao.class).addPrivateMessage(subj, message, contact.getContact(), user, user, false, Long.valueOf(0L));
            Application.get().getBean(MailHandler.class).send(user.getAddress().getEmail(), subj, message);
        }
        return userContactId;
    }
}

