/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.room.poll;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.BootstrapAjaxButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.List;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.dao.room.PollDao;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.room.RoomPoll;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.ws.RoomMessage;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.MainPanel;
import org.apache.openmeetings.web.common.OmModalCloseButton;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.LambdaChoiceRenderer;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.danekja.java.util.function.serializable.SerializableFunction;

public class CreatePollDialog
extends Modal<RoomPoll> {
    private static final long serialVersionUID = 1L;
    private final Long roomId;
    private PollForm form;
    private final NotificationPanel feedback = new NotificationPanel("feedback");
    @Inject
    private RoomDao roomDao;
    @Inject
    private UserDao userDao;
    @Inject
    private PollDao pollDao;

    public CreatePollDialog(String id, Long roomId) {
        super(id, (IModel)new CompoundPropertyModel((Object)new RoomPoll()));
        this.roomId = roomId;
    }

    protected void onInitialize() {
        this.header((IModel)new ResourceModel("18"));
        this.setCloseOnEscapeKey(false);
        this.setBackdrop(Modal.Backdrop.STATIC);
        Component[] componentArray = new Component[1];
        this.form = new PollForm("form", (IModel<RoomPoll>)this.getModel());
        componentArray[0] = this.form;
        this.add(componentArray);
        this.addButton((Component)new BootstrapAjaxButton("button", (IModel)new ResourceModel("22"), this.form, Buttons.Type.Outline_Primary){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target) {
                CreatePollDialog.this.pollDao.close(CreatePollDialog.this.roomId);
                CreatePollDialog.this.pollDao.update((RoomPoll)CreatePollDialog.this.form.getModelObject());
                WebSocketHelper.sendRoom((RoomMessage)new RoomMessage(CreatePollDialog.this.roomId, ((MainPanel)((Object)this.findParent(MainPanel.class))).getClient(), RoomMessage.Type.POLL_CREATED));
                CreatePollDialog.this.close((IPartialPageRequestHandler)target);
            }

            protected void onError(AjaxRequestTarget target) {
                target.add(new Component[]{CreatePollDialog.this.feedback});
            }
        });
        this.addButton((Component)OmModalCloseButton.of());
        super.onInitialize();
    }

    public void updateModel(AjaxRequestTarget target) {
        RoomPoll p = new RoomPoll();
        User u = this.userDao.get(WebSession.getUserId());
        p.setCreator(u);
        p.setRoom(this.roomDao.get(this.roomId));
        p.setType(RoomPoll.Type.YES_NO);
        this.setModelObject(p);
        this.form.setModelObject((RoomPoll)this.getModelObject());
        target.add(new Component[]{this.form});
    }

    PollForm getForm() {
        return this.form;
    }

    class PollForm
    extends Form<RoomPoll> {
        private static final long serialVersionUID = 1L;

        public PollForm(String id, IModel<RoomPoll> model) {
            super(id, model);
        }

        protected void onInitialize() {
            this.add(new Component[]{new RequiredTextField("name").setLabel((IModel)new ResourceModel("1410"))});
            this.add(new Component[]{new TextArea("question")});
            this.add(new Component[]{new DropDownChoice("type", List.of(RoomPoll.Type.values()), (IChoiceRenderer)new LambdaChoiceRenderer((SerializableFunction & Serializable)pt -> this.getString("poll.type." + pt.name()), Enum::name)).setRequired(true).setLabel((IModel)new ResourceModel("21"))});
            this.add(new Component[]{CreatePollDialog.this.feedback.setOutputMarkupId(true)});
            super.onInitialize();
        }
    }
}

