/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.util;

import com.hazelcast.internal.tpcengine.util.NanoClock;
import com.hazelcast.internal.tpcengine.util.Preconditions;

public class CachedNanoClock
implements NanoClock {
    private static final long START_TIME = System.nanoTime();
    private final int refreshPeriod;
    private int iteration;
    private long value;

    public CachedNanoClock(int refreshPeriod) {
        this.refreshPeriod = Preconditions.checkNotNegative(refreshPeriod, "refreshPeriod");
    }

    @Override
    public void update() {
        this.value = System.nanoTime() - START_TIME;
        this.iteration = 0;
    }

    @Override
    public long nanoTime() {
        if (this.iteration == this.refreshPeriod) {
            this.value = System.nanoTime() - START_TIME;
            this.iteration = 0;
        } else {
            ++this.iteration;
        }
        return this.value;
    }
}

