/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.eviction.impl.evaluator;

import com.hazelcast.internal.eviction.Evictable;
import com.hazelcast.internal.eviction.EvictionCandidate;
import com.hazelcast.internal.eviction.Expirable;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.spi.eviction.EvictionPolicyComparator;

public class EvictionPolicyEvaluator<A, E extends Evictable> {
    private final EvictionPolicyComparator comparator;

    public EvictionPolicyEvaluator(EvictionPolicyComparator comparator) {
        this.comparator = comparator;
    }

    public EvictionPolicyComparator getEvictionPolicyComparator() {
        return this.comparator;
    }

    public <C extends EvictionCandidate<A, E>> C evaluate(Iterable<C> candidates) {
        long now = Clock.currentTimeMillis();
        EvictionCandidate selected = null;
        for (EvictionCandidate current : candidates) {
            if (selected == null) {
                selected = current;
                continue;
            }
            if (EvictionPolicyEvaluator.isExpired(current.getEvictable(), now)) {
                return (C)current;
            }
            if (this.comparator.compare(current, selected) >= 0) continue;
            selected = current;
        }
        return (C)selected;
    }

    private static boolean isExpired(Evictable evictable, long now) {
        if (!(evictable instanceof Expirable)) {
            return false;
        }
        return ((Expirable)((Object)evictable)).isExpiredAt(now);
    }
}

