/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.tempusdominus;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapJavascriptBehavior;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.tempusdominus.TempusDominusConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.tempusdominus.TempusDominusLocalizationConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.references.TempusDominusCssReference;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.references.TempusDominusJsReference;
import de.agilecoders.wicket.jquery.function.Function;
import de.agilecoders.wicket.webjars.request.resource.WebjarsJavaScriptResourceReference;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class TempusDominusBehavior
extends BootstrapJavascriptBehavior {
    private static final long serialVersionUID = 1L;
    private final TempusDominusConfig config;

    public TempusDominusBehavior(TempusDominusConfig config) {
        this.config = config;
        Args.notNull((Object)((String)config.localization.get(TempusDominusLocalizationConfig.Locale)), (String)"locale");
    }

    private void addResourceIfExists(IHeaderResponse response, String path) {
        WebjarsJavaScriptResourceReference ref = new WebjarsJavaScriptResourceReference(path);
        if (ref.getResource().getResourceStream() != null) {
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)ref));
        }
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render(TempusDominusCssReference.asHeaderItem());
        response.render(TempusDominusJsReference.asHeaderItem());
        Locale locale = this.config.getLocale();
        if (!Locale.ENGLISH.equals(locale)) {
            if (!Strings.isEmpty((String)locale.getCountry())) {
                this.addResourceIfExists(response, "eonasdan__tempus-dominus/current/dist/locales/" + locale.toLanguageTag() + ".js");
            }
            if (!Locale.ENGLISH.getLanguage().equals(locale.getLanguage())) {
                this.addResourceIfExists(response, "eonasdan__tempus-dominus/current/dist/locales/" + locale.getLanguage() + ".js");
            }
        }
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)new Function("Wicket.Bootstrap.createTempusDominus", new Object[]{component.getMarkupId(), this.config, this.config.getLocalization(), locale.getLanguage()}).build()));
    }

    public void onEvent(Component component, IEvent<?> event) {
        IPartialPageRequestHandler target;
        super.onEvent(component, event);
        if (event.getPayload() instanceof IPartialPageRequestHandler && (target = (IPartialPageRequestHandler)event.getPayload()).getComponents().contains(component)) {
            target.prependJavaScript((CharSequence)new Function("Wicket.Bootstrap.destroyTempusDominus", new Object[]{component.getMarkupId()}).build());
        }
    }
}

