/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateUtil {
    private static final String DATE_TIME_PATTERN = "yy-MM-dd HH:mm:ss";
    private static Date currentDate;

    private DateUtil() {
    }

    public static void overrideCurrentDate(Date currentDate) {
        DateUtil.currentDate = currentDate;
    }

    public static Date getDate() {
        if (currentDate == null) {
            return new Date();
        }
        return currentDate;
    }

    public static Date parseDateTime(String s) {
        return DateUtil.parseDateTime(s, null);
    }

    public static Date parseDateTime(String s, TimeZone tz) {
        if (s == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(DATE_TIME_PATTERN);
        if (tz != null) {
            df.setTimeZone(tz);
        }
        try {
            return df.parse(s);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

