/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;

class NIOControlPacket
extends NIOPacket {
    short nsControlCommand;
    static final short NSPCTL_SERR = 8;
    static final short NSPCTL_CLRATTN = 9;
    static final int ORA_ERROR_EMFI_NUMBER = 22;
    static final int NSECMANSHUT = 12572;
    static final int NSESENDMESG = 12573;

    NIOControlPacket(SessionAtts sessionAtts) {
        super(sessionAtts);
        this.header.type = 10;
    }

    @Override
    void readPayloadBuffer() throws IOException {
        this.nsControlCommand = this.session.payloadBufferForRead.getShort();
        if (this.nsControlCommand == 8) {
            this.processNSError();
        } else if (this.nsControlCommand == 9) {
            this.disableAttentionProcessing();
        }
    }

    private void processNSError() throws IOException {
        int n2 = this.session.payloadBufferForRead.getInt();
        int n3 = this.session.payloadBufferForRead.getInt();
        int n4 = this.session.payloadBufferForRead.getInt();
        if (n3 == 12572 || n3 == 12573) {
            this.session.needsToBeClosed = true;
            return;
        }
        if (n2 == 22) {
            throw new NetException(n3, "ORA-" + n3, true);
        }
        throw new NetException(n3, "TNS-" + n3, true);
    }

    private void disableAttentionProcessing() {
        this.session.negotiatedOptions &= 0xFFFFFDFF;
        this.session.negotiatedOptions &= 0xFFFFFBFF;
    }
}

