/*
 * Decompiled with CFR 0.152.
 */
package org.archive.hadoop;

import java.io.IOException;
import java.util.Locale;
import java.util.logging.Logger;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.archive.extract.ExtractingResourceFactoryMapper;
import org.archive.extract.ExtractingResourceProducer;
import org.archive.format.gzip.GZIPMemberSeries;
import org.archive.hadoop.ResourceContext;
import org.archive.resource.MetaData;
import org.archive.resource.Resource;
import org.archive.resource.ResourceParseException;
import org.archive.resource.ResourceProducer;
import org.archive.resource.TransformingResourceProducer;
import org.archive.resource.arc.ARCResourceFactory;
import org.archive.resource.gzip.GZIPResourceContainer;
import org.archive.resource.warc.WARCResourceFactory;
import org.archive.streamcontext.HDFSStream;
import org.archive.streamcontext.Stream;
import org.archive.util.StreamCopy;

public class ResourceRecordReader
extends RecordReader<ResourceContext, MetaData> {
    private static final Logger LOG = Logger.getLogger(ResourceRecordReader.class.getName());
    WARCResourceFactory wf = new WARCResourceFactory();
    ARCResourceFactory af = new ARCResourceFactory();
    Stream stream;
    GZIPMemberSeries series;
    private ResourceProducer producer;
    private String name;
    private long startOffset;
    private long length;
    private ResourceContext cachedK;
    private MetaData cachedV;

    public void close() throws IOException {
        this.producer.close();
    }

    public ResourceContext getCurrentKey() throws IOException, InterruptedException {
        return this.cachedK;
    }

    public MetaData getCurrentValue() throws IOException, InterruptedException {
        return this.cachedV;
    }

    public float getProgress() throws IOException, InterruptedException {
        if (this.length == 0L) {
            return 0.0f;
        }
        long curOffset = this.stream.getOffset();
        float amtDone = curOffset - this.startOffset;
        float flen = this.length;
        return amtDone / flen;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        TransformingResourceProducer envelope;
        if (!(inputSplit instanceof FileSplit)) throw new IOException("Need FileSplit input...");
        FileSplit fs = (FileSplit)inputSplit;
        Path fsPath = fs.getPath();
        FileSystem fSys = fsPath.getFileSystem(context.getConfiguration());
        FSDataInputStream fsdis = fSys.open(fsPath);
        String path = fsPath.getName();
        this.name = fsPath.getName();
        this.stream = new HDFSStream(fsdis);
        this.startOffset = fs.getStart();
        this.length = fs.getLength();
        long endOffset = this.startOffset + this.length;
        this.stream.setOffset(this.startOffset);
        this.series = new GZIPMemberSeries(this.stream, this.name, this.startOffset);
        GZIPResourceContainer prod = new GZIPResourceContainer(this.series, endOffset);
        if (path.endsWith(".warc.gz") || path.endsWith(".wat.gz")) {
            envelope = new TransformingResourceProducer(prod, this.wf);
        } else {
            if (!path.endsWith(".arc.gz")) throw new IOException("arguments must be arc.gz or warc.gz");
            envelope = new TransformingResourceProducer(prod, this.af);
        }
        ExtractingResourceFactoryMapper mapper = new ExtractingResourceFactoryMapper();
        this.producer = new ExtractingResourceProducer(envelope, mapper);
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        try {
            Resource r = this.producer.getNext();
            if (r != null) {
                StreamCopy.readToEOF(r.getInputStream());
                LOG.info(String.format(Locale.ROOT, "Extracted offset %d\n", this.series.getCurrentMemberStartOffset()));
                this.cachedK = new ResourceContext(this.name, this.series.getCurrentMemberStartOffset());
                this.cachedV = r.getMetaData().getTopMetaData();
                return true;
            }
        }
        catch (ResourceParseException e) {
            e.printStackTrace();
            throw new IOException(String.format(Locale.ROOT, "ResourceParseException at(%s)(%d)", this.name, this.series.getCurrentMemberStartOffset()), e);
        }
        return false;
    }
}

