/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.RackAwareMode$Safe$;
import kafka.cluster.Broker;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$Ip$;
import kafka.server.DynamicConfig$User$;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.zk.AdminZkClient$;
import kafka.zk.ConfigEntityZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicZNode$;
import org.apache.kafka.admin.AdminUtils;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.server.common.AdminOperationException;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.zookeeper.KeeperException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t=g\u0001B\u001a5\u0001eB\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\")Q\u000b\u0001C\u0001-\")!\f\u0001C\u00017\"I\u0011Q\u0003\u0001\u0012\u0002\u0013\u0005\u0011q\u0003\u0005\n\u0003[\u0001\u0011\u0013!C\u0001\u0003_A\u0011\"a\r\u0001#\u0003%\t!!\u000e\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<!I\u0011q\r\u0001\u0012\u0002\u0013\u0005\u0011q\u0006\u0005\n\u0003S\u0002\u0011\u0013!C\u0001\u0003WBq!a\u001c\u0001\t\u0003\t\t\bC\u0005\u0002\n\u0002\t\n\u0011\"\u0001\u00026!I\u00111\u0012\u0001\u0012\u0002\u0013\u0005\u0011Q\u0007\u0005\b\u0003\u001b\u0003A\u0011AAH\u0011\u001d\t9\n\u0001C\u0005\u00033C\u0011\"!.\u0001#\u0003%I!!\u000e\t\u000f\u0005]\u0006\u0001\"\u0001\u0002:\"9\u0011Q\u0018\u0001\u0005\u0002\u0005}\u0006\"CAl\u0001E\u0005I\u0011AAm\u0011%\ti\u000eAI\u0001\n\u0003\ty\u000eC\u0005\u0002d\u0002\t\n\u0011\"\u0001\u00026!9\u0011Q\u001d\u0001\u0005\u0002\u0005\u001d\b\"CAz\u0001E\u0005I\u0011AAm\u0011%\t)\u0010AI\u0001\n\u0003\ty\u000eC\u0004\u0002x\u0002!\t!!?\t\u000f\t\r\u0001\u0001\"\u0003\u0003\u0006!9!q\u0003\u0001\u0005\u0002\te\u0001b\u0002B\u0011\u0001\u0011\u0005!1\u0005\u0005\n\u0005k\u0001\u0011\u0013!C\u0001\u0003kAqAa\u000e\u0001\t\u0013\u0011I\u0004C\u0004\u0003B\u0001!\tAa\u0011\t\u000f\t-\u0003\u0001\"\u0001\u0003N!I!q\u000b\u0001\u0012\u0002\u0013\u0005\u0011Q\u0007\u0005\b\u00053\u0002A\u0011\u0001B.\u0011\u001d\u0011\u0019\u0007\u0001C\u0001\u0005KBqAa\u001b\u0001\t\u0003\u0011i\u0007C\u0004\u0003t\u0001!\tA!\u001e\t\u000f\tm\u0004\u0001\"\u0001\u0003~!9!1\u0010\u0001\u0005\u0002\t\u0015\u0005b\u0002BF\u0001\u0011\u0005!Q\u0012\u0005\b\u0005#\u0003A\u0011\u0002BJ\u0011%\u0011\t\u000bAI\u0001\n\u0013\t)\u0004C\u0004\u0003$\u0002!\tA!*\t\u000f\t-\u0006\u0001\"\u0001\u0003.\"9!\u0011\u0017\u0001\u0005\u0002\tM\u0006b\u0002B\\\u0001\u0011\u0005!\u0011X\u0004\n\u0005\u0003$\u0014\u0011!E\u0001\u0005\u00074\u0001b\r\u001b\u0002\u0002#\u0005!Q\u0019\u0005\u0007+B\"\tAa2\t\u0013\t%\u0007'%A\u0005\u0002\t-'!D!e[&t'l[\"mS\u0016tGO\u0003\u00026m\u0005\u0011!p\u001b\u0006\u0002o\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001;\u0001B\u00111HP\u0007\u0002y)\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\t1\u0011I\\=SK\u001a\u0004\"!\u0011#\u000e\u0003\tS!a\u0011\u001c\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0015\u0013%a\u0002'pO\u001eLgnZ\u0001\tu.\u001cE.[3oiB\u0011\u0001*S\u0007\u0002i%\u0011!\n\u000e\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0002\u0017-\fgm[1D_:4\u0017n\u001a\t\u0004w5{\u0015B\u0001(=\u0005\u0019y\u0005\u000f^5p]B\u0011\u0001kU\u0007\u0002#*\u0011!KN\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005Q\u000b&aC&bM.\f7i\u001c8gS\u001e\fa\u0001P5oSRtDcA,Y3B\u0011\u0001\n\u0001\u0005\u0006\r\u000e\u0001\ra\u0012\u0005\b\u0017\u000e\u0001\n\u00111\u0001M\u0003-\u0019'/Z1uKR{\u0007/[2\u0015\u0011q{F.]:~\u0003\u0017\u0001\"aO/\n\u0005yc$\u0001B+oSRDQ\u0001\u0019\u0003A\u0002\u0005\fQ\u0001^8qS\u000e\u0004\"AY5\u000f\u0005\r<\u0007C\u00013=\u001b\u0005)'B\u000149\u0003\u0019a$o\\8u}%\u0011\u0001\u000eP\u0001\u0007!J,G-\u001a4\n\u0005)\\'AB*ue&twM\u0003\u0002iy!)Q\u000e\u0002a\u0001]\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\u0005mz\u0017B\u00019=\u0005\rIe\u000e\u001e\u0005\u0006e\u0012\u0001\rA\\\u0001\u0012e\u0016\u0004H.[2bi&|gNR1di>\u0014\bb\u0002;\u0005!\u0003\u0005\r!^\u0001\fi>\u0004\u0018nY\"p]\u001aLw\r\u0005\u0002ww6\tqO\u0003\u0002ys\u0006!Q\u000f^5m\u0015\u0005Q\u0018\u0001\u00026bm\u0006L!\u0001`<\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0004\u007f\tA\u0005\t\u0019A@\u0002\u001bI\f7m[!xCJ,Wj\u001c3f!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003m\u0005)\u0011\rZ7j]&!\u0011\u0011BA\u0002\u00055\u0011\u0016mY6Bo\u0006\u0014X-T8eK\"I\u0011Q\u0002\u0003\u0011\u0002\u0003\u0007\u0011qB\u0001\fkN,7\u000fV8qS\u000eLE\rE\u0002<\u0003#I1!a\u0005=\u0005\u001d\u0011un\u001c7fC:\fQc\u0019:fCR,Gk\u001c9jG\u0012\"WMZ1vYR$C'\u0006\u0002\u0002\u001a)\u001aQ/a\u0007,\u0005\u0005u\u0001\u0003BA\u0010\u0003Si!!!\t\u000b\t\u0005\r\u0012QE\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\n=\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003W\t\tCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQc\u0019:fCR,Gk\u001c9jG\u0012\"WMZ1vYR$S'\u0006\u0002\u00022)\u001aq0a\u0007\u0002+\r\u0014X-\u0019;f)>\u0004\u0018n\u0019\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u0011q\u0007\u0016\u0005\u0003\u001f\tY\"\u0001\nhKR\u0014%o\\6fe6+G/\u00193bi\u0006\u001cHCBA\u001f\u0003;\ny\u0006\u0005\u0004\u0002@\u0005\u0015\u0013\u0011J\u0007\u0003\u0003\u0003R1!a\u0011=\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u000f\n\tEA\u0002TKF\u0004B!a\u0013\u0002Z5\u0011\u0011Q\n\u0006\u0005\u0003\u000b\tyEC\u00028\u0003#RA!a\u0015\u0002V\u00051\u0011\r]1dQ\u0016T!!a\u0016\u0002\u0007=\u0014x-\u0003\u0003\u0002\\\u00055#A\u0004\"s_.,'/T3uC\u0012\fG/\u0019\u0005\b}\"\u0001\n\u00111\u0001\u0000\u0011%\t\t\u0007\u0003I\u0001\u0002\u0004\t\u0019'\u0001\u0006ce>\\WM\u001d'jgR\u0004BaO'\u0002fA)\u0011qHA#]\u0006ar-\u001a;Ce>\\WM]'fi\u0006$\u0017\r^1tI\u0011,g-Y;mi\u0012\n\u0014\u0001H4fi\n\u0013xn[3s\u001b\u0016$\u0018\rZ1uCN$C-\u001a4bk2$HEM\u000b\u0003\u0003[RC!a\u0019\u0002\u001c\u0005I2M]3bi\u0016$v\u000e]5d/&$\b.Q:tS\u001etW.\u001a8u)-a\u00161OA;\u0003s\n\u0019)a\"\t\u000b\u0001\\\u0001\u0019A1\t\r\u0005]4\u00021\u0001v\u0003\u0019\u0019wN\u001c4jO\"9\u00111P\u0006A\u0002\u0005u\u0014A\u00079beRLG/[8o%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\bcBA \u0003\u007fr\u0017QM\u0005\u0005\u0003\u0003\u000b\tEA\u0002NCBD\u0011\"!\"\f!\u0003\u0005\r!a\u0004\u0002\u0011Y\fG.\u001b3bi\u0016D\u0011\"!\u0004\f!\u0003\u0005\r!a\u0004\u0002G\r\u0014X-\u0019;f)>\u0004\u0018nY,ji\"\f5o]5h]6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%i\u0005\u00193M]3bi\u0016$v\u000e]5d/&$\b.Q:tS\u001etW.\u001a8uI\u0011,g-Y;mi\u0012*\u0014a\u0005<bY&$\u0017\r^3U_BL7m\u0011:fCR,Gc\u0002/\u0002\u0012\u0006M\u0015Q\u0013\u0005\u0006A:\u0001\r!\u0019\u0005\b\u0003wr\u0001\u0019AA?\u0011\u0019\t9H\u0004a\u0001k\u0006irO]5uKR{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u001b8/[4o[\u0016tG\u000fF\u0005]\u00037\u000bi*a,\u00024\")\u0001m\u0004a\u0001C\"9\u0011qT\bA\u0002\u0005\u0005\u0016!\u0005:fa2L7-Y!tg&<g.\\3oiB9\u0011qHA@]\u0006\r\u0006\u0003BAS\u0003Wk!!a*\u000b\u0007\u0005%f'\u0001\u0006d_:$(o\u001c7mKJLA!!,\u0002(\n\t\"+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;\t\u000f\u0005Ev\u00021\u0001\u0002\u0010\u0005A\u0011n]+qI\u0006$X\rC\u0005\u0002\u000e=\u0001\n\u00111\u0001\u0002\u0010\u00059sO]5uKR{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u001b8/[4o[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003-!W\r\\3uKR{\u0007/[2\u0015\u0007q\u000bY\fC\u0003a#\u0001\u0007\u0011-A\u0007bI\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u000f\u0003{\n\t-a1\u0002H\u0006-\u0017qZAj\u0011\u0015\u0001'\u00031\u0001b\u0011\u001d\t)M\u0005a\u0001\u0003C\u000b!#\u001a=jgRLgnZ!tg&<g.\\3oi\"9\u0011\u0011\u001a\nA\u0002\u0005u\u0012AC1mY\n\u0013xn[3sg\"A\u0011Q\u001a\n\u0011\u0002\u0003\u0007a.A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\u0005\n\u0003?\u0013\u0002\u0013!a\u0001\u0003#\u0004BaO'\u0002~!I\u0011Q\u001b\n\u0011\u0002\u0003\u0007\u0011qB\u0001\rm\u0006d\u0017\u000eZ1uK>sG._\u0001\u0018C\u0012$\u0007+\u0019:uSRLwN\\:%I\u00164\u0017-\u001e7uIQ*\"!a7+\u00079\fY\"A\fbI\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011\u0011\u001d\u0016\u0005\u0003#\fY\"A\fbI\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0013eK\u001a\fW\u000f\u001c;%m\u0005i2M]3bi\u0016tUm\u001e)beRLG/[8og\u0006\u001b8/[4o[\u0016tG\u000f\u0006\u0007\u0002\"\u0006%\u00181^Aw\u0003_\f\t\u0010C\u0003a-\u0001\u0007\u0011\rC\u0004\u0002FZ\u0001\r!!)\t\u000f\u0005%g\u00031\u0001\u0002>!A\u0011Q\u001a\f\u0011\u0002\u0003\u0007a\u000eC\u0005\u0002 Z\u0001\n\u00111\u0001\u0002R\u000693M]3bi\u0016tUm\u001e)beRLG/[8og\u0006\u001b8/[4o[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003\u001d\u001a'/Z1uK:+w\u000fU1si&$\u0018n\u001c8t\u0003N\u001c\u0018n\u001a8nK:$H\u0005Z3gCVdG\u000fJ\u001b\u0002=\r\u0014X-\u0019;f!\u0006\u0014H/\u001b;j_:\u001cx+\u001b;i\u0003N\u001c\u0018n\u001a8nK:$H\u0003CAQ\u0003w\fi0a@\t\u000b\u0001L\u0002\u0019A1\t\u000f\u0005\u0015\u0017\u00041\u0001\u0002\"\"9!\u0011A\rA\u0002\u0005\u0005\u0016A\u00068foB\u000b'\u000f^5uS>t\u0017i]:jO:lWM\u001c;\u00023Y\fG.\u001b3bi\u0016\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\u000b\b9\n\u001d!\u0011\u0002B\u0007\u0011\u001d\tyJ\u0007a\u0001\u0003{BaAa\u0003\u001b\u0001\u0004q\u0017!G3ya\u0016\u001cG/\u001a3SKBd\u0017nY1uS>tg)Y2u_JDqAa\u0004\u001b\u0001\u0004\u0011\t\"\u0001\nbm\u0006LG.\u00192mK\n\u0013xn[3s\u0013\u0012\u001c\b\u0003\u00022\u0003\u00149L1A!\u0006l\u0005\r\u0019V\r^\u0001\fa\u0006\u00148/\u001a\"s_.,'\u000f\u0006\u0003\u0003\u001c\tu\u0001cA\u001eN]\"1!qD\u000eA\u0002\u0005\faA\u0019:pW\u0016\u0014\u0018!D2iC:<WmQ8oM&<7\u000fF\u0005]\u0005K\u0011IC!\f\u00032!1!q\u0005\u000fA\u0002\u0005\f!\"\u001a8uSRLH+\u001f9f\u0011\u0019\u0011Y\u0003\ba\u0001C\u0006QQM\u001c;jift\u0015-\\3\t\r\t=B\u00041\u0001v\u0003\u001d\u0019wN\u001c4jOND\u0011Ba\r\u001d!\u0003\u0005\r!a\u0004\u0002\u001d%\u001cXk]3s\u00072LWM\u001c;JI\u000692\r[1oO\u0016\u001cuN\u001c4jON$C-\u001a4bk2$H\u0005N\u0001\u0013iJL8\t\\3b]F+x\u000e^1O_\u0012,7\u000f\u0006\u0005\u0002\u0010\tm\"Q\bB \u0011\u0019\u00119C\ba\u0001C\"1!1\u0006\u0010A\u0002\u0005DqAa\r\u001f\u0001\u0004\ty!\u0001\u000bdQ\u0006tw-Z\"mS\u0016tG/\u00133D_:4\u0017n\u001a\u000b\u00069\n\u0015#\u0011\n\u0005\u0007\u0005\u000fz\u0002\u0019A1\u0002#M\fg.\u001b;ju\u0016$7\t\\5f]RLE\r\u0003\u0004\u00030}\u0001\r!^\u0001\u001fG\"\fgnZ3Vg\u0016\u0014xJ]+tKJ\u001cE.[3oi&#7i\u001c8gS\u001e$r\u0001\u0018B(\u0005'\u0012)\u0006\u0003\u0004\u0003R\u0001\u0002\r!Y\u0001\u0014g\u0006t\u0017\u000e^5{K\u0012,e\u000e^5us:\u000bW.\u001a\u0005\u0007\u0005_\u0001\u0003\u0019A;\t\u0013\tM\u0002\u0005%AA\u0002\u0005=\u0011\u0001K2iC:<W-V:fe>\u0013Xk]3s\u00072LWM\u001c;JI\u000e{gNZ5hI\u0011,g-Y;mi\u0012\u001a\u0014\u0001\u0005<bY&$\u0017\r^3Ja\u000e{gNZ5h)\u0015a&Q\fB1\u0011\u0019\u0011yF\ta\u0001C\u0006\u0011\u0011\u000e\u001d\u0005\u0007\u0005_\u0011\u0003\u0019A;\u0002\u001d\rD\u0017M\\4f\u0013B\u001cuN\u001c4jOR)ALa\u001a\u0003j!1!qL\u0012A\u0002\u0005DaAa\f$\u0001\u0004)\u0018a\u0005<bY&$\u0017\r^3U_BL7mQ8oM&<G#\u0002/\u0003p\tE\u0004\"\u00021%\u0001\u0004\t\u0007B\u0002B\u0018I\u0001\u0007Q/A\tdQ\u0006tw-\u001a+pa&\u001c7i\u001c8gS\u001e$R\u0001\u0018B<\u0005sBQ\u0001Y\u0013A\u0002\u0005DaAa\f&\u0001\u0004)\u0018AE2iC:<WM\u0011:pW\u0016\u00148i\u001c8gS\u001e$R\u0001\u0018B@\u0005\u0007CqA!!'\u0001\u0004\t)'A\u0004ce>\\WM]:\t\r\t=b\u00051\u0001v)\u0015a&q\u0011BE\u0011\u001d\u0011yb\na\u0001\u00057AaAa\f(\u0001\u0004)\u0018\u0001\u0006<bY&$\u0017\r^3Ce>\\WM]\"p]\u001aLw\rF\u0002]\u0005\u001fCaAa\f)\u0001\u0004)\u0018AE2iC:<W-\u00128uSRL8i\u001c8gS\u001e$\u0012\u0002\u0018BK\u00053\u0013iJa(\t\r\t]\u0015\u00061\u0001b\u00039\u0011xn\u001c;F]RLG/\u001f+za\u0016DaAa'*\u0001\u0004\t\u0017a\u00064vY2\u001c\u0016M\\5uSj,G-\u00128uSRLh*Y7f\u0011\u0019\u0011y#\u000ba\u0001k\"I!1G\u0015\u0011\u0002\u0003\u0007\u0011qB\u0001\u001dG\"\fgnZ3F]RLG/_\"p]\u001aLw\r\n3fM\u0006,H\u000e\u001e\u00135\u0003E1W\r^2i\u000b:$\u0018\u000e^=D_:4\u0017n\u001a\u000b\u0006k\n\u001d&\u0011\u0016\u0005\u0007\u0005/[\u0003\u0019A1\t\r\tE3\u00061\u0001b\u0003I9W\r^!mYR{\u0007/[2D_:4\u0017nZ:\u0015\u0005\t=\u0006CBA \u0003\u007f\nW/A\u000bgKR\u001c\u0007.\u00117m\u000b:$\u0018\u000e^=D_:4\u0017nZ:\u0015\t\t=&Q\u0017\u0005\u0007\u0005Oi\u0003\u0019A1\u00025\u0019,Go\u00195BY2\u001c\u0005.\u001b7e\u000b:$\u0018\u000e^=D_:4\u0017nZ:\u0015\r\t=&1\u0018B_\u0011\u0019\u00119J\fa\u0001C\"1!q\u0018\u0018A\u0002\u0005\fqb\u00195jY\u0012,e\u000e^5usRK\b/Z\u0001\u000e\u0003\u0012l\u0017N\u001c.l\u00072LWM\u001c;\u0011\u0005!\u00034C\u0001\u0019;)\t\u0011\u0019-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0003\u0005\u001bT3\u0001TA\u000e\u0001")
public class AdminZkClient
implements Logging {
    private final KafkaZkClient zkClient;
    private final Option<KafkaConfig> kafkaConfig;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<KafkaConfig> $lessinit$greater$default$2() {
        return AdminZkClient$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void createTopic(String topic, int partitions, int replicationFactor, Properties topicConfig, RackAwareMode rackAwareMode, boolean usesTopicId) {
        java.util.List brokerMetadatas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.getBrokerMetadatas(rackAwareMode, this.getBrokerMetadatas$default$2())).asJava();
        Map<Object, Seq<Object>> replicaAssignment = CoreUtils$.MODULE$.replicaToBrokerAssignmentAsScala(AdminUtils.assignReplicasToBrokers((Collection)brokerMetadatas, (int)partitions, (int)replicationFactor));
        boolean x$5 = this.createTopicWithAssignment$default$4();
        this.createTopicWithAssignment(topic, topicConfig, replicaAssignment, x$5, usesTopicId);
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public RackAwareMode createTopic$default$5() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public boolean createTopic$default$6() {
        return false;
    }

    public Seq<BrokerMetadata> getBrokerMetadatas(RackAwareMode rackAwareMode, Option<Seq<Object>> brokerList) {
        Seq<Broker> allBrokers = this.zkClient.getAllBrokersInCluster();
        Seq brokers = (Seq)brokerList.map((Function1 & Serializable & scala.Serializable)brokerIds -> (Seq)allBrokers.filter((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)brokerIds.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))))).getOrElse((Function0 & Serializable & scala.Serializable)() -> allBrokers);
        Seq brokersWithRack = (Seq)brokers.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$getBrokerMetadatas$4(x$1)));
        RackAwareMode rackAwareMode2 = rackAwareMode;
        RackAwareMode$Enforced$ rackAwareMode$Enforced$ = RackAwareMode$Enforced$.MODULE$;
        if (!(rackAwareMode2 != null ? !rackAwareMode2.equals(rackAwareMode$Enforced$) : rackAwareMode$Enforced$ != null)) {
            if (brokersWithRack.nonEmpty() && brokersWithRack.size() < brokers.size()) {
                throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
            }
        }
        return (Seq)(RackAwareMode$Disabled$.MODULE$.equals(rackAwareMode) ? (Seq)brokers.map((Function1 & Serializable & scala.Serializable)broker -> new BrokerMetadata(broker.id(), Optional.empty()), Seq$.MODULE$.canBuildFrom()) : (RackAwareMode$Safe$.MODULE$.equals(rackAwareMode) && brokersWithRack.size() < brokers.size() ? (Seq)brokers.map((Function1 & Serializable & scala.Serializable)broker -> new BrokerMetadata(broker.id(), Optional.empty()), Seq$.MODULE$.canBuildFrom()) : (Seq)brokers.map((Function1 & Serializable & scala.Serializable)broker -> new BrokerMetadata(broker.id(), Optional.ofNullable(broker.rack().orNull(Predef$.MODULE$.$conforms()))), Seq$.MODULE$.canBuildFrom()))).sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id), (Ordering)Ordering.Int$.MODULE$);
    }

    public RackAwareMode getBrokerMetadatas$default$1() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Option<Seq<Object>> getBrokerMetadatas$default$2() {
        return None$.MODULE$;
    }

    public void createTopicWithAssignment(String topic, Properties config, Map<Object, Seq<Object>> partitionReplicaAssignment, boolean validate, boolean usesTopicId) {
        if (validate) {
            this.validateTopicCreate(topic, partitionReplicaAssignment, config);
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Creating topic ").append(topic).append(" with configuration ").append(config).append(" and initial partition ").append("assignment ").append(partitionReplicaAssignment).toString());
        this.zkClient.setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), topic, config);
        this.writeTopicPartitionAssignment(topic, (Map<Object, ReplicaAssignment>)((Map)partitionReplicaAssignment.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                int k = x0$1._1$mcI$sp();
                Seq v = (Seq)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)ReplicaAssignment$.MODULE$.apply((Seq<Object>)v));
            }
            throw new MatchError(null);
        }, Map$.MODULE$.canBuildFrom())), false, usesTopicId);
    }

    public boolean createTopicWithAssignment$default$4() {
        return true;
    }

    public boolean createTopicWithAssignment$default$5() {
        return false;
    }

    public void validateTopicCreate(String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Properties config) {
        Topic.validate((String)topic);
        if (this.zkClient.isTopicMarkedForDeletion(topic)) {
            throw new TopicExistsException(new StringBuilder(32).append("Topic '").append(topic).append("' is marked for deletion.").toString());
        }
        if (this.zkClient.topicExists(topic)) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        if (Topic.hasCollisionChars((String)topic)) {
            Set<String> allTopics = this.zkClient.getAllTopicsInCluster(this.zkClient.getAllTopicsInCluster$default$1());
            if (allTopics.contains((Object)topic)) {
                throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
            }
            Set collidingTopics = (Set)allTopics.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$validateTopicCreate$1(topic, x$3)));
            if (collidingTopics.nonEmpty()) {
                throw new InvalidTopicException(new StringBuilder(40).append("Topic '").append(topic).append("' collides with existing topics: ").append(collidingTopics.mkString(", ")).toString());
            }
        }
        if (((TraversableOnce)partitionReplicaAssignment.values().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size()), Iterable$.MODULE$.canBuildFrom())).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of replicas");
        }
        partitionReplicaAssignment.values().foreach((Function1 & Serializable & scala.Serializable)reps -> {
            AdminZkClient.$anonfun$validateTopicCreate$3(partitionReplicaAssignment, reps);
            return BoxedUnit.UNIT;
        });
        int partitionSize = partitionReplicaAssignment.size();
        int sequenceSum = partitionSize * (partitionSize - 1) / 2;
        if (partitionReplicaAssignment.size() != partitionReplicaAssignment.toSet().size() || BoxesRunTime.unboxToInt((Object)((TraversableOnce)partitionReplicaAssignment.keys().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$5 -> x$5 >= 0)).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) != sequenceSum) {
            throw new InvalidReplicaAssignmentException("partitions should be a consecutive 0-based integer sequence");
        }
        LogConfig.validate((Properties)config, (java.util.Map)((java.util.Map)this.kafkaConfig.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.extractLogConfigMap()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Collections.emptyMap())), (boolean)this.kafkaConfig.exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x$7.isRemoteLogStorageSystemEnabled()))));
    }

    private void writeTopicPartitionAssignment(String topic, Map<Object, ReplicaAssignment> replicaAssignment, boolean isUpdate, boolean usesTopicId) {
        try {
            scala.collection.immutable.Map assignment = ((TraversableOnce)replicaAssignment.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    int partitionId = x0$1._1$mcI$sp();
                    ReplicaAssignment replicas = (ReplicaAssignment)x0$1._2();
                    return new Tuple2((Object)new TopicPartition(topic, partitionId), (Object)replicas);
                }
                throw new MatchError(null);
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            if (!isUpdate) {
                None$ topicIdOpt = usesTopicId ? new Some((Object)Uuid.randomUuid()) : None$.MODULE$;
                this.zkClient.createTopicAssignment(topic, (Option<Uuid>)topicIdOpt, (Map<TopicPartition, Seq<Object>>)((Map)assignment.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        TopicPartition k = (TopicPartition)x0$2._1();
                        ReplicaAssignment v = (ReplicaAssignment)x0$2._2();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), v.replicas());
                    }
                    throw new MatchError(null);
                }, scala.collection.immutable.Map$.MODULE$.canBuildFrom())));
            } else {
                Map<String, Uuid> topicIds = this.zkClient.getTopicIdsForTopics((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                this.zkClient.setTopicAssignment(topic, (Option<Uuid>)topicIds.get((Object)topic), (Map<TopicPartition, ReplicaAssignment>)assignment, this.zkClient.setTopicAssignment$default$4());
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Updated path %s with %s for replica assignment")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TopicZNode$.MODULE$.path(topic), assignment})));
            return;
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        catch (Throwable e2) {
            throw new AdminOperationException(e2.toString());
        }
    }

    private boolean writeTopicPartitionAssignment$default$4() {
        return false;
    }

    public void deleteTopic(String topic) {
        if (this.zkClient.topicExists(topic)) {
            try {
                this.zkClient.createDeleteTopicPath(topic);
                return;
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                throw new TopicAlreadyMarkedForDeletionException(new StringOps(Predef$.MODULE$.augmentString("topic %s is already marked for deletion")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            catch (Throwable e) {
                throw new AdminOperationException(e.getMessage());
            }
        }
        throw new UnknownTopicOrPartitionException(new StringBuilder(33).append("Topic `").append(topic).append("` to delete does not exist").toString());
    }

    public Map<Object, Seq<Object>> addPartitions(String topic, Map<Object, ReplicaAssignment> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, Seq<Object>>> replicaAssignment, boolean validateOnly) {
        Map<Object, ReplicaAssignment> proposedAssignmentForNewPartitions = this.createNewPartitionsAssignment(topic, existingAssignment, allBrokers, numPartitions, replicaAssignment);
        if (validateOnly) {
            return (Map)existingAssignment.$plus$plus(proposedAssignmentForNewPartitions).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    int k = x0$1._1$mcI$sp();
                    ReplicaAssignment v = (ReplicaAssignment)x0$1._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), v.replicas());
                }
                throw new MatchError(null);
            }, Map$.MODULE$.canBuildFrom());
        }
        return (Map)this.createPartitionsWithAssignment(topic, existingAssignment, proposedAssignmentForNewPartitions).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                int k = x0$2._1$mcI$sp();
                ReplicaAssignment v = (ReplicaAssignment)x0$2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), v.replicas());
            }
            throw new MatchError(null);
        }, Map$.MODULE$.canBuildFrom());
    }

    public int addPartitions$default$4() {
        return 1;
    }

    public Option<Map<Object, Seq<Object>>> addPartitions$default$5() {
        return None$.MODULE$;
    }

    public boolean addPartitions$default$6() {
        return false;
    }

    public Map<Object, ReplicaAssignment> createNewPartitionsAssignment(String topic, Map<Object, ReplicaAssignment> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, Seq<Object>>> replicaAssignment) {
        Seq<Object> existingAssignmentPartition0 = ((ReplicaAssignment)existingAssignment.getOrElse((Object)BoxesRunTime.boxToInteger((int)0), (Function0 & Serializable & scala.Serializable)() -> {
            throw new AdminOperationException(new StringBuilder(92).append("Unexpected existing replica assignment for topic '").append(topic).append("', partition id 0 is missing. ").append("Assignment: ").append(existingAssignment).toString());
        })).replicas();
        int partitionsToAdd = numPartitions - existingAssignment.size();
        if (partitionsToAdd <= 0) {
            throw new InvalidPartitionsException(new StringBuilder(120).append("The number of partitions for a topic can only be increased. ").append("Topic ").append(topic).append(" currently has ").append(existingAssignment.size()).append(" partitions, ").append(numPartitions).append(" would not be an increase.").toString());
        }
        replicaAssignment.foreach((Function1 & Serializable & scala.Serializable)proposedReplicaAssignment -> {
            this.validateReplicaAssignment((Map<Object, Seq<Object>>)proposedReplicaAssignment, existingAssignmentPartition0.size(), (Set<Object>)((TraversableOnce)allBrokers.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.id), Seq$.MODULE$.canBuildFrom())).toSet());
            return BoxedUnit.UNIT;
        });
        return (Map)((Map)replicaAssignment.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            int startIndex = scala.math.package$.MODULE$.max(0, allBrokers.indexWhere((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$createNewPartitionsAssignment$5(existingAssignmentPartition0, x$9))));
            return CoreUtils$.MODULE$.replicaToBrokerAssignmentAsScala(AdminUtils.assignReplicasToBrokers((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(allBrokers).asJava()), (int)partitionsToAdd, (int)existingAssignmentPartition0.size(), (int)startIndex, (int)existingAssignment.size()));
        })).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                int tp = x0$1._1$mcI$sp();
                Seq replicas = (Seq)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp)), (Object)ReplicaAssignment$.MODULE$.apply((Seq<Object>)replicas, (Seq<Object>)Nil$.MODULE$, (Seq<Object>)Nil$.MODULE$));
            }
            throw new MatchError(null);
        }, Map$.MODULE$.canBuildFrom());
    }

    public int createNewPartitionsAssignment$default$4() {
        return 1;
    }

    public Option<Map<Object, Seq<Object>>> createNewPartitionsAssignment$default$5() {
        return None$.MODULE$;
    }

    public Map<Object, ReplicaAssignment> createPartitionsWithAssignment(String topic, Map<Object, ReplicaAssignment> existingAssignment, Map<Object, ReplicaAssignment> newPartitionAssignment) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Creating ").append(newPartitionAssignment.size()).append(" partitions for '").append(topic).append("' with the following replica assignment: ").append(newPartitionAssignment).append(".").toString());
        Map combinedAssignment = existingAssignment.$plus$plus(newPartitionAssignment);
        this.writeTopicPartitionAssignment(topic, (Map<Object, ReplicaAssignment>)combinedAssignment, true, this.writeTopicPartitionAssignment$default$4());
        return combinedAssignment;
    }

    /*
     * WARNING - void declaration
     */
    private void validateReplicaAssignment(Map<Object, Seq<Object>> replicaAssignment, int expectedReplicationFactor, Set<Object> availableBrokerIds) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(partitionId, replicas) -> AdminZkClient.$anonfun$validateReplicaAssignment$1(availableBrokerIds, BoxesRunTime.unboxToInt((Object)partitionId), replicas);
        Map<Object, Seq<Object>> map = Implicits$.MODULE$.MapExtensionMethods(replicaAssignment);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        Map badRepFactors = (Map)replicaAssignment.collect((PartialFunction)new scala.Serializable(null, expectedReplicationFactor){
            public static final long serialVersionUID = 0L;
            private final int expectedReplicationFactor$1;

            public final <A1 extends Tuple2<Object, Seq<Object>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null) {
                    int partition = x1._1$mcI$sp();
                    Seq replicas = (Seq)x1._2();
                    if (replicas.size() != this.expectedReplicationFactor$1) {
                        return (B1)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)BoxesRunTime.boxToInteger((int)replicas.size()));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Object, Seq<Object>> x1) {
                return x1 != null && ((Seq)x1._2()).size() != this.expectedReplicationFactor$1;
            }
            {
                this.expectedReplicationFactor$1 = expectedReplicationFactor$1;
            }
        }, Map$.MODULE$.canBuildFrom());
        if (badRepFactors.nonEmpty()) {
            Seq sortedBadRepFactors = (Seq)badRepFactors.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$2(x0$1)), (Ordering)Ordering.Int$.MODULE$);
            Seq partitions = (Seq)sortedBadRepFactors.map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$3(x0$2)), Seq$.MODULE$.canBuildFrom());
            Seq repFactors = (Seq)sortedBadRepFactors.map((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$4(x0$3)), Seq$.MODULE$.canBuildFrom());
            throw new InvalidReplicaAssignmentException(new StringBuilder(131).append("Inconsistent replication factor between partitions, ").append("partition 0 has ").append(expectedReplicationFactor).append(" while partitions [").append(partitions.mkString(", ")).append("] have ").append("replication factors [").append(repFactors.mkString(", ")).append("], respectively.").toString());
        }
    }

    public Option<Object> parseBroker(String broker) {
        String string = ConfigEntityName$.MODULE$.Default();
        if (!(string != null ? !string.equals(broker) : broker != null)) {
            return None$.MODULE$;
        }
        try {
            return new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(broker)).toInt()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(new StringBuilder(78).append("Error parsing broker ").append(broker).append(". The broker's Entity Name must be a single integer value").toString());
        }
    }

    public void changeConfigs(String entityType, String entityName, Properties configs, boolean isUserClientId) {
        String string = ConfigType$.MODULE$.Topic();
        if (!(string != null ? !string.equals(entityType) : entityType != null)) {
            this.changeTopicConfig(entityName, configs);
            return;
        }
        String string2 = ConfigType$.MODULE$.Client();
        if (!(string2 != null ? !string2.equals(entityType) : entityType != null)) {
            this.changeClientIdConfig(entityName, configs);
            return;
        }
        String string3 = ConfigType$.MODULE$.User();
        if (!(string3 != null ? !string3.equals(entityType) : entityType != null)) {
            this.changeUserOrUserClientIdConfig(entityName, configs, isUserClientId);
            return;
        }
        String string4 = ConfigType$.MODULE$.Broker();
        if (!(string4 != null ? !string4.equals(entityType) : entityType != null)) {
            this.changeBrokerConfig(this.parseBroker(entityName), configs);
            return;
        }
        String string5 = ConfigType$.MODULE$.Ip();
        if (!(string5 != null ? !string5.equals(entityType) : entityType != null)) {
            this.changeIpConfig(entityName, configs);
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(45).append(entityType).append(" is not a known entityType. Should be one of ").append(ConfigType$.MODULE$.all()).toString());
    }

    public boolean changeConfigs$default$4() {
        return false;
    }

    private boolean tryCleanQuotaNodes(String entityType, String entityName, boolean isUserClientId) {
        String currPath = ConfigEntityZNode$.MODULE$.path(entityType, entityName);
        if (this.zkClient.getChildren(currPath).isEmpty()) {
            ObjectRef pathToDelete = ObjectRef.create((Object)currPath);
            if (isUserClientId) {
                String user = entityName.substring(0, entityName.indexOf("/"));
                String clientId = entityName.substring(entityName.lastIndexOf("/") + 1);
                String clientsPath = ConfigEntityZNode$.MODULE$.path(ConfigType$.MODULE$.User(), new StringBuilder(1).append(user).append("/").append(ConfigType$.MODULE$.Client()).toString());
                Seq<String> seq = this.zkClient.getChildren(clientsPath);
                .colon.colon colon2 = new .colon.colon((Object)clientId, (List)Nil$.MODULE$);
                if (seq != null && seq.equals((Object)colon2)) {
                    pathToDelete.elem = clientsPath;
                    Properties userData = this.fetchEntityConfig(ConfigType$.MODULE$.User(), user);
                    String userPath = ConfigEntityZNode$.MODULE$.path(ConfigType$.MODULE$.User(), user);
                    Seq<String> userChildren = this.zkClient.getChildren(userPath);
                    if (userData.isEmpty()) {
                        Seq<String> seq2 = userChildren;
                        .colon.colon colon3 = new .colon.colon((Object)ConfigType$.MODULE$.Client(), (List)Nil$.MODULE$);
                        if (seq2 != null && seq2.equals((Object)colon3)) {
                            pathToDelete.elem = userPath;
                        }
                    }
                }
            }
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Deleting zk node ").append((String)pathToDelete$1.elem).append(" since node of entityType ").append(entityType).append(" and entityName ").append(entityName).append(" is empty.").toString());
            this.zkClient.deletePath((String)pathToDelete.elem, this.zkClient.deletePath$default$2(), this.zkClient.deletePath$default$3());
            return true;
        }
        return false;
    }

    public void changeClientIdConfig(String sanitizedClientId, Properties configs) {
        DynamicConfig$Client$.MODULE$.validate(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Client(), sanitizedClientId, configs, this.changeEntityConfig$default$4());
    }

    public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs, boolean isUserClientId) {
        String string = sanitizedEntityName;
        String string2 = ConfigEntityName$.MODULE$.Default();
        if (!(string == null ? string2 != null : !string.equals(string2)) || sanitizedEntityName.contains("/clients")) {
            DynamicConfig$Client$.MODULE$.validate(configs);
        } else {
            DynamicConfig$User$.MODULE$.validate(configs);
        }
        this.changeEntityConfig(ConfigType$.MODULE$.User(), sanitizedEntityName, configs, isUserClientId);
    }

    public boolean changeUserOrUserClientIdConfig$default$3() {
        return false;
    }

    public void validateIpConfig(String ip, Properties configs) {
        if (!DynamicConfig$Ip$.MODULE$.isValidIpEntity(ip)) {
            throw new AdminOperationException(new StringBuilder(38).append(ip).append(" is not a valid IP or resolvable host.").toString());
        }
        DynamicConfig$Ip$.MODULE$.validate(configs);
    }

    public void changeIpConfig(String ip, Properties configs) {
        this.validateIpConfig(ip, configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Ip(), ip, configs, this.changeEntityConfig$default$4());
    }

    public void validateTopicConfig(String topic, Properties configs) {
        Topic.validate((String)topic);
        if (!this.zkClient.topicExists(topic)) {
            throw new UnknownTopicOrPartitionException(new StringBuilder(24).append("Topic '").append(topic).append("' does not exist.").toString());
        }
        LogConfig.validate((Properties)configs, (java.util.Map)((java.util.Map)this.kafkaConfig.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.extractLogConfigMap()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Collections.emptyMap())), (boolean)this.kafkaConfig.exists((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(x$11.isRemoteLogStorageSystemEnabled()))));
    }

    public void changeTopicConfig(String topic, Properties configs) {
        this.validateTopicConfig(topic, configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Topic(), topic, configs, this.changeEntityConfig$default$4());
    }

    public void changeBrokerConfig(Seq<Object> brokers, Properties configs) {
        this.validateBrokerConfig(configs);
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)broker -> this.changeEntityConfig(ConfigType$.MODULE$.Broker(), Integer.toString(broker), configs, this.changeEntityConfig$default$4()));
    }

    public void changeBrokerConfig(Option<Object> broker, Properties configs) {
        this.validateBrokerConfig(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Broker(), (String)broker.map((Function1 & Serializable & scala.Serializable)x$12 -> AdminZkClient.$anonfun$changeBrokerConfig$2(BoxesRunTime.unboxToInt((Object)x$12))).getOrElse((Function0 & Serializable & scala.Serializable)() -> ConfigEntityName$.MODULE$.Default()), configs, this.changeEntityConfig$default$4());
    }

    public void validateBrokerConfig(Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
    }

    private void changeEntityConfig(String rootEntityType, String fullSanitizedEntityName, Properties configs, boolean isUserClientId) {
        String sanitizedEntityPath = new StringBuilder(0).append(rootEntityType).append('/').append(fullSanitizedEntityName).toString();
        boolean needUpdateConfigs = true;
        if ((ConfigType$.MODULE$.Client().equals(rootEntityType) || ConfigType$.MODULE$.User().equals(rootEntityType) || ConfigType$.MODULE$.Ip().equals(rootEntityType)) && configs.isEmpty() && this.tryCleanQuotaNodes(rootEntityType, fullSanitizedEntityName, isUserClientId)) {
            needUpdateConfigs = false;
        }
        if (needUpdateConfigs) {
            this.zkClient.setOrCreateEntityConfigs(rootEntityType, fullSanitizedEntityName, configs);
        }
        this.zkClient.createConfigChangeNotification(sanitizedEntityPath);
    }

    private boolean changeEntityConfig$default$4() {
        return false;
    }

    public Properties fetchEntityConfig(String rootEntityType, String sanitizedEntityName) {
        return this.zkClient.getEntityConfigs(rootEntityType, sanitizedEntityName);
    }

    public Map<String, Properties> getAllTopicConfigs() {
        return ((TraversableOnce)this.zkClient.getAllTopicsInCluster(this.zkClient.getAllTopicsInCluster$default$1()).map((Function1 & Serializable & scala.Serializable)topic -> new Tuple2(topic, (Object)this.fetchEntityConfig(ConfigType$.MODULE$.Topic(), (String)topic)), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllEntityConfigs(String entityType) {
        return ((TraversableOnce)this.zkClient.getAllEntitiesWithConfig(entityType).map((Function1 & Serializable & scala.Serializable)entity -> new Tuple2(entity, (Object)this.fetchEntityConfig(entityType, (String)entity)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllChildEntityConfigs(String rootEntityType, String childEntityType) {
        return ((TraversableOnce)((TraversableLike)this.entityPaths$1((Option)None$.MODULE$, rootEntityType).flatMap((Function1 & Serializable & scala.Serializable)entity -> this.entityPaths$1((Option)new Some((Object)new StringBuilder(0).append((String)entity).append('/').append(childEntityType).toString()), rootEntityType), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)entityPath -> new Tuple2(entityPath, (Object)this.fetchEntityConfig(rootEntityType, (String)entityPath)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerMetadatas$4(Broker x$1) {
        return x$1.rack().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicCreate$1(String topic$2, String x$3) {
        return Topic.hasCollision((String)topic$2, (String)x$3);
    }

    public static final /* synthetic */ void $anonfun$validateTopicCreate$3(Map partitionReplicaAssignment$2, Seq reps) {
        if (reps.size() != reps.toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(36).append("Duplicate replica assignment found: ").append(partitionReplicaAssignment$2).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$createNewPartitionsAssignment$5(Seq existingAssignmentPartition0$1, BrokerMetadata x$9) {
        return x$9.id >= BoxesRunTime.unboxToInt((Object)existingAssignmentPartition0$1.head());
    }

    public static final /* synthetic */ Tuple2 $anonfun$validateReplicaAssignment$1(Set availableBrokerIds$1, int partitionId, Seq replicas) {
        if (replicas.isEmpty()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(54).append("Cannot have replication factor of 0 for partition id ").append(partitionId).append(".").toString());
        }
        if (replicas.size() != replicas.toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(72).append("Duplicate brokers not allowed in replica assignment: ").append(replicas.mkString(", ")).append(" for partition id ").append(partitionId).append(".").toString());
        }
        if (!replicas.toSet().subsetOf((GenSet)availableBrokerIds$1)) {
            throw new BrokerNotAvailableException(new StringBuilder(101).append("Some brokers specified for partition id ").append(partitionId).append(" are not available. ").append("Specified brokers: ").append(replicas.mkString(", ")).append(", ").append("available brokers: ").append(availableBrokerIds$1.mkString(", ")).append(".").toString());
        }
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partitionId)), (Object)BoxesRunTime.boxToInteger((int)replicas.size()));
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$2(Tuple2 x0$1) {
        if (x0$1 != null) {
            return x0$1._1$mcI$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$3(Tuple2 x0$2) {
        if (x0$2 != null) {
            return x0$2._1$mcI$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$4(Tuple2 x0$3) {
        if (x0$3 != null) {
            return x0$3._2$mcI$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ String $anonfun$changeBrokerConfig$2(int x$12) {
        return Integer.toString(x$12);
    }

    private final Seq entityPaths$1(Option rootPath, String rootEntityType$1) {
        String string;
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            string = new StringBuilder(0).append(rootEntityType$1).append('/').append(path).toString();
        } else if (None$.MODULE$.equals(rootPath)) {
            string = rootEntityType$1;
        } else {
            throw new MatchError((Object)rootPath);
        }
        String root = string;
        Seq<String> entityNames = this.zkClient.getAllEntitiesWithConfig(root);
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            return (Seq)entityNames.map((Function1 & Serializable & scala.Serializable)entityName -> new StringBuilder(0).append(path).append('/').append((String)entityName).toString(), Seq$.MODULE$.canBuildFrom());
        }
        if (None$.MODULE$.equals(rootPath)) {
            return entityNames;
        }
        throw new MatchError((Object)rootPath);
    }

    public AdminZkClient(KafkaZkClient zkClient, Option<KafkaConfig> kafkaConfig) {
        this.zkClient = zkClient;
        this.kafkaConfig = kafkaConfig;
        Logging.$init$(this);
    }
}

