/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexwriter.cloudsearch;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;

public class CloudSearchUtils {
    private static MessageDigest digester;

    public static String getID(String url) {
        byte[] dig = digester.digest(url.getBytes(StandardCharsets.UTF_8));
        String ID = Hex.encodeHexString((byte[])dig);
        if (ID.length() > 128) {
            throw new RuntimeException("ID larger than max 128 chars");
        }
        return ID;
    }

    public static String stripNonCharCodepoints(String input) {
        StringBuilder retval = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (ch != '\t' && ch != '\n' && ch != '\r' && (ch < ' ' || ch > '\ufffd')) continue;
            retval.append(ch);
        }
        return retval.toString();
    }

    static {
        try {
            digester = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

