/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.binsearch.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.archive.util.binsearch.SeekableLineReader;
import org.archive.util.binsearch.SeekableLineReaderFactory;
import org.archive.util.binsearch.impl.NIOSeekableLineReader;

public class NIOSeekableLineReaderFactory
implements SeekableLineReaderFactory {
    private File file;
    private FileChannel fc;
    private RandomAccessFile raf;
    private int blockSize;
    private NIOType type = NIOType.PLAIN;

    public NIOSeekableLineReaderFactory(File file, int blockSize, NIOType type) throws IOException {
        this.file = file;
        this.type = type;
        this.blockSize = blockSize;
        this.raf = new RandomAccessFile(file, "r");
        this.fc = this.raf.getChannel();
    }

    public NIOSeekableLineReaderFactory(File file, int blockSize) throws IOException {
        this(file, blockSize, NIOType.PLAIN);
    }

    public NIOSeekableLineReaderFactory(File file) throws IOException {
        this(file, 8192);
    }

    @Override
    public SeekableLineReader get() throws IOException {
        return new NIOSeekableLineReader(this.fc, this.blockSize, this.type);
    }

    @Override
    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
    }

    @Override
    public long getModTime() {
        return this.file.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() throws IOException {
        RandomAccessFile newRAF = new RandomAccessFile(this.file, "r");
        FileChannel newFc = this.raf.getChannel();
        RandomAccessFile oldRaf = this.raf;
        NIOSeekableLineReaderFactory nIOSeekableLineReaderFactory = this;
        synchronized (nIOSeekableLineReaderFactory) {
            this.raf = newRAF;
            this.fc = newFc;
        }
        if (oldRaf != null) {
            oldRaf.close();
        }
    }

    public static enum NIOType {
        PLAIN,
        MMAP;

    }
}

