/*
 * Decompiled with CFR 0.152.
 */
package org.archive.resource.gzip;

import java.io.IOException;
import java.io.InputStream;
import org.archive.format.gzip.GZIPConstants;
import org.archive.format.gzip.GZIPSeriesMember;
import org.archive.resource.AbstractResource;
import org.archive.resource.MetaData;
import org.archive.resource.ResourceConstants;
import org.archive.resource.ResourceContainer;
import org.archive.resource.gzip.GZIPMetaData;
import org.archive.util.io.EOFNotifyingInputStream;
import org.archive.util.io.EOFObserver;

public class GZIPResource
extends AbstractResource
implements GZIPConstants,
EOFObserver,
ResourceConstants {
    private GZIPSeriesMember member;
    private EOFNotifyingInputStream eofStream;
    private GZIPMetaData gzMetaData;

    public GZIPResource(MetaData metaData, ResourceContainer container, GZIPSeriesMember member) {
        super(metaData, container);
        this.member = member;
        this.eofStream = new EOFNotifyingInputStream(member, this);
        MetaData containerMD = new MetaData(metaData, "Container");
        containerMD.putString("Filename", member.getRecordFileContext());
        containerMD.putBoolean("Compressed", true);
        containerMD.putLong("Offset", member.getRecordStartOffset());
        this.gzMetaData = new GZIPMetaData(containerMD);
    }

    public void close() throws IOException {
        this.member.close();
    }

    @Override
    public InputStream getInputStream() {
        return this.eofStream;
    }

    @Override
    public void notifyEOF() throws IOException {
        this.gzMetaData.setData(this.member);
    }
}

