/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.http;

import java.io.IOException;
import java.io.InputStream;
import org.archive.format.http.HttpConstants;
import org.archive.format.http.HttpHeaderObserver;
import org.archive.format.http.HttpHeaders;
import org.archive.format.http.HttpParseException;

public class HttpHeaderParser
implements HttpConstants {
    private static final int DEFAULT_MAX_NAME_LENGTH = 102400;
    private static final int DEFAULT_MAX_VALUE_LENGTH = 0xA00000;
    private HttpHeaderObserver obs = null;
    private ParseState state = null;
    public boolean isStrict = false;
    private int nameStartIdx = 0;
    private int nameLength = 0;
    private byte[] name = null;
    private int valueStartIdx = 0;
    private int valueLength = 0;
    private byte[] value = null;
    private int bufferIdx = 0;
    private ParseState startState = new StartParseState();
    private ParseState endState = new EndParseState();
    private ParseState lineStartState = new LineStartParseState();
    private ParseState nameState = new NameParseState();
    private ParseState postNameState = new PostNameParseState();
    private ParseState postColonState = new PostColonParseState();
    private ParseState valueState = new ValueParseState();
    private ParseState valuePostLWSPState = new ValuePostLWSPParseState();
    private ParseState valuePostCRState = new ValuePostCRParseState();
    private ParseState postBlankCRState = new PostBlankCRParseState();
    private ParseState laxLineEatParseState = new LAXLineEatParseState();
    private ParseState valuePreCRState = null;

    public HttpHeaderParser() {
        this(null, 102400, 0xA00000);
    }

    public HttpHeaderParser(HttpHeaderObserver obs) {
        this(obs, 102400, 0xA00000);
    }

    public HttpHeaderParser(HttpHeaderObserver obs, int maxName, int maxValue) {
        this.name = new byte[maxName];
        this.value = new byte[maxValue];
        this.obs = obs;
        this.reset();
    }

    public void setObserver(HttpHeaderObserver obs) {
        this.obs = obs;
    }

    private void reset() {
        this.state = this.startState;
        this.bufferIdx = 0;
        this.nameStartIdx = 0;
        this.nameLength = 0;
        this.valueStartIdx = 0;
        this.valueLength = 0;
    }

    public int doParse(InputStream is, HttpHeaderObserver obs) throws HttpParseException, IOException {
        this.obs = obs;
        return this.doParse(is);
    }

    public HttpHeaders parseHeaders(InputStream is) throws HttpParseException, IOException {
        HttpHeaders headers = new HttpHeaders();
        this.obs = headers;
        this.doParse(is);
        return headers;
    }

    public int doParse(InputStream is) throws HttpParseException, IOException {
        int bytesRead = 0;
        this.reset();
        while (!this.isDone()) {
            int i = is.read();
            if (i == -1) {
                if (this.isStrict) {
                    throw new HttpParseException("EOF before CRLFCRLF");
                }
                this.headersCorrupted();
                return bytesRead;
            }
            ++bytesRead;
            if (i > 127) {
                if (this.isStrict) {
                    throw new HttpParseException("Non ASCII byte in headers");
                }
                this.headersCorrupted();
                continue;
            }
            byte b = (byte)(i & 0xFF);
            this.parseByte(b);
        }
        return bytesRead;
    }

    public boolean isDone() {
        return this.state instanceof EndParseState;
    }

    public void parseByte(byte b) throws HttpParseException {
        this.state = this.state.handleByte(b, this);
        ++this.bufferIdx;
    }

    private void headerFinished() {
        if (this.nameLength == 0) {
            return;
        }
        if (this.valueLength > 0 && this.value[this.valueLength - 1] == 32) {
            --this.valueLength;
        }
        if (this.obs != null) {
            this.obs.headerParsed(this.name, this.nameStartIdx, this.nameLength, this.value, this.valueStartIdx, this.valueLength);
        }
    }

    private void parseFinished() {
        if (this.obs != null) {
            this.obs.headersComplete(this.bufferIdx + 1);
        }
    }

    private void headersCorrupted() {
        if (this.obs != null) {
            this.obs.headersCorrupt();
        }
    }

    private void setNameStartPos() {
        this.nameStartIdx = this.bufferIdx;
        this.nameLength = 0;
    }

    private void addNameByte(byte b) throws HttpParseException {
        if (this.nameLength >= this.name.length) {
            throw new HttpParseException("Name too long");
        }
        this.name[this.nameLength] = b;
        ++this.nameLength;
    }

    private void setValueStartIdx() {
        this.valueStartIdx = this.bufferIdx;
        this.valueLength = 0;
    }

    private void addValueByte(byte b) throws HttpParseException {
        if (b == 32) {
            if (this.valueLength == 0) {
                return;
            }
            if (this.value[this.valueLength - 1] == 32) {
                return;
            }
        }
        if (this.valueLength >= this.value.length) {
            throw new HttpParseException("Value too long");
        }
        this.value[this.valueLength] = b;
        ++this.valueLength;
    }

    private static boolean isLWSP(byte b) {
        return b == 32 || b == 9;
    }

    private static boolean isLegalNameByte(byte b) {
        if (b > 31 && b < 128) {
            return b == 32 ? false : b != 58;
        }
        return false;
    }

    private static interface ParseState {
        public ParseState handleByte(byte var1, HttpHeaderParser var2) throws HttpParseException;
    }

    private class StartParseState
    implements ParseState {
        private StartParseState() {
        }

        @Override
        public ParseState handleByte(byte b, HttpHeaderParser parser) throws HttpParseException {
            if (HttpHeaderParser.isLWSP(b)) {
                if (parser.isStrict) {
                    throw new HttpParseException("Space at start of headers");
                }
                parser.headersCorrupted();
                return parser.startState;
            }
            if (HttpHeaderParser.isLegalNameByte(b)) {
                parser.setNameStartPos();
                parser.addNameByte(b);
                return parser.nameState;
            }
            if (parser.isStrict) {
                throw new HttpParseException("Bad character at start of headers");
            }
            parser.headersCorrupted();
            return parser.laxLineEatParseState;
        }
    }

    private class EndParseState
    implements ParseState {
        private EndParseState() {
        }

        @Override
        public ParseState handleByte(byte b, HttpHeaderParser parser) throws HttpParseException {
            throw new HttpParseException("Parse already completed");
        }
    }

    private class LineStartParseState
    implements ParseState {
        private LineStartParseState() {
        }

        @Override
        public ParseState handleByte(byte b, HttpHeaderParser parser) throws HttpParseException {
            if (HttpHeaderParser.isLWSP(b)) {
                parser.addValueByte((byte)32);
                return parser.valuePostLWSPState;
            }
            if (HttpHeaderParser.isLegalNameByte(b)) {
                parser.headerFinished();
                parser.setNameStartPos();
                parser.addNameByte(b);
                return parser.nameState;
            }
            if (b == 13) {
                return parser.postBlankCRState;
            }
            if (b == 10) {
                parser.headerFinished();
                parser.parseFinished();
                return parser.endState;
            }
            if (parser.isStrict) {
                throw new HttpParseException("Bad character at start of line");
            }
            parser.headersCorrupted();
            return parser.laxLineEatParseState;
        }
    }

    private class NameParseState
    implements ParseState {
        private NameParseState() {
        }

        @Override
        public ParseState handleByte(byte b, HttpHeaderParser parser) throws HttpParseException {
            if (HttpHeaderParser.isLegalNameByte(b)) {
                parser.addNameByte(b);
                return this;
            }
            if (HttpHeaderParser.isLWSP(b)) {
                return parser.postNameState;
            }
            if (b == 58) {
                return parser.postColonState;
            }
            if (parser.isStrict) {
                throw new HttpParseException("Illegal name char");
            }
            parser.headersCorrupted();
            return parser.laxLineEatParseState;
        }
    }

    private class PostNameParseState
    implements ParseState {
        private PostNameParseState() {
        }

        @Override
        public ParseState handleByte(byte b, HttpHeaderParser parser) throws HttpParseException {
            if (HttpHeaderParser.isLWSP(b)) {
                return parser.postNameState;
            }
            if (b == 58) {
                return parser.postColonState;
            }
            if (parser.isStrict) {
                throw new HttpParseException("Illegal char after name(" + new String(HttpHeaderParser.this.name, 0, HttpHeaderParser.this.nameLength) + ")");
            }
            parser.headersCorrupted();
            return parser.laxLineEatParseState;
        }
    }

    private class PostColonParseState
    implements ParseState {
        private PostColonParseState() {
        }

        @Override
        public ParseState handleByte(byte b, HttpHeaderParser parser) throws HttpParseException {
            if (HttpHeaderParser.isLWSP(b)) {
                return parser.postColonState;
            }
            parser.setValueStartIdx();
            if (b == 13) {
                parser.valuePreCRState = parser.postColonState;
                return parser.valuePostCRState;
            }
            if (b == 10) {
                return parser.lineStartState;
            }
            parser.addValueByte(b);
            return parser.valueState;
        }
    }

    private class ValueParseState
    implements ParseState {
        private ValueParseState() {
        }

        @Override
        public ParseState handleByte(byte b, HttpHeaderParser parser) throws HttpParseException {
            if (HttpHeaderParser.isLWSP(b)) {
                parser.addValueByte((byte)32);
                return parser.valuePostLWSPState;
            }
            if (b == 13) {
                parser.valuePreCRState = this;
                return parser.valuePostCRState;
            }
            if (b == 10) {
                return parser.lineStartState;
            }
            parser.addValueByte(b);
            return this;
        }
    }

    private class ValuePostLWSPParseState
    implements ParseState {
        private ValuePostLWSPParseState() {
        }

        @Override
        public ParseState handleByte(byte b, HttpHeaderParser parser) throws HttpParseException {
            if (HttpHeaderParser.isLWSP(b)) {
                return parser.valuePostLWSPState;
            }
            if (b == 13) {
                parser.valuePreCRState = this;
                return parser.valuePostCRState;
            }
            if (b == 10) {
                return parser.lineStartState;
            }
            parser.addValueByte(b);
            return parser.valueState;
        }
    }

    private class ValuePostCRParseState
    implements ParseState {
        private ValuePostCRParseState() {
        }

        @Override
        public ParseState handleByte(byte b, HttpHeaderParser parser) throws HttpParseException {
            if (HttpHeaderParser.isLWSP(b)) {
                return parser.valuePreCRState;
            }
            if (b == 13) {
                return parser.valuePostCRState;
            }
            if (b == 10) {
                return parser.lineStartState;
            }
            parser.addValueByte(b);
            return parser.valueState;
        }
    }

    private class PostBlankCRParseState
    implements ParseState {
        private PostBlankCRParseState() {
        }

        @Override
        public ParseState handleByte(byte b, HttpHeaderParser parser) throws HttpParseException {
            if (b == 10) {
                parser.headerFinished();
                parser.parseFinished();
                return parser.endState;
            }
            if (parser.isStrict) {
                throw new HttpParseException("NON LF after blank CR");
            }
            parser.headersCorrupted();
            return parser.laxLineEatParseState;
        }
    }

    private class LAXLineEatParseState
    implements ParseState {
        private LAXLineEatParseState() {
        }

        @Override
        public ParseState handleByte(byte b, HttpHeaderParser parser) throws HttpParseException {
            if (b == 13) {
                return parser.valuePostCRState;
            }
            if (b == 10) {
                return parser.lineStartState;
            }
            return parser.laxLineEatParseState;
        }
    }
}

