/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.indices;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.indices.DetailAnalyzeResponse;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class AnalyzeResponse {
    private static final String TOKENS = "tokens";
    private static final String DETAIL = "detail";
    private final DetailAnalyzeResponse detail;
    private final List<AnalyzeToken> tokens;
    private static final ConstructingObjectParser<AnalyzeResponse, Void> PARSER = new ConstructingObjectParser("analyze_response", true, args -> new AnalyzeResponse((List)args[0], (DetailAnalyzeResponse)args[1]));

    private AnalyzeResponse(List<AnalyzeToken> tokens, DetailAnalyzeResponse detail) {
        this.tokens = tokens;
        this.detail = detail;
    }

    public List<AnalyzeToken> getTokens() {
        return this.tokens;
    }

    public DetailAnalyzeResponse detail() {
        return this.detail;
    }

    public static AnalyzeResponse fromXContent(XContentParser parser) throws IOException {
        return (AnalyzeResponse)PARSER.parse(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyzeResponse that = (AnalyzeResponse)o;
        return Objects.equals(this.detail, that.detail) && Objects.equals(this.tokens, that.tokens);
    }

    public int hashCode() {
        return Objects.hash(this.detail, this.tokens);
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (ContextParser)AnalyzeToken.PARSER, new ParseField(TOKENS, new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), DetailAnalyzeResponse.PARSER, new ParseField(DETAIL, new String[0]));
    }

    public static class AnalyzeToken {
        private String term;
        private int startOffset;
        private int endOffset;
        private int position;
        private int positionLength = 1;
        private String type;
        private final Map<String, Object> attributes = new HashMap<String, Object>();
        private static final ObjectParser<AnalyzeToken, Void> PARSER = new ObjectParser("analyze_token", AnalyzeToken::setAttribute, AnalyzeToken::new);

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnalyzeToken that = (AnalyzeToken)o;
            return this.startOffset == that.startOffset && this.endOffset == that.endOffset && this.position == that.position && this.positionLength == that.positionLength && Objects.equals(this.term, that.term) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(this.term, this.startOffset, this.endOffset, this.position, this.positionLength, this.attributes, this.type);
        }

        public String getTerm() {
            return this.term;
        }

        private void setTerm(String term) {
            this.term = term;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        private void setStartOffset(int startOffset) {
            this.startOffset = startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        private void setEndOffset(int endOffset) {
            this.endOffset = endOffset;
        }

        public int getPosition() {
            return this.position;
        }

        private void setPosition(int position) {
            this.position = position;
        }

        public int getPositionLength() {
            return this.positionLength;
        }

        private void setPositionLength(int positionLength) {
            this.positionLength = positionLength;
        }

        public String getType() {
            return this.type;
        }

        private void setType(String type) {
            this.type = type;
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        private void setAttribute(String key, Object value) {
            this.attributes.put(key, value);
        }

        public static AnalyzeToken fromXContent(XContentParser parser) throws IOException {
            return (AnalyzeToken)PARSER.parse(parser, null);
        }

        static {
            PARSER.declareString(AnalyzeToken::setTerm, new ParseField("token", new String[0]));
            PARSER.declareString(AnalyzeToken::setType, new ParseField("type", new String[0]));
            PARSER.declareInt(AnalyzeToken::setPosition, new ParseField("position", new String[0]));
            PARSER.declareInt(AnalyzeToken::setStartOffset, new ParseField("start_offset", new String[0]));
            PARSER.declareInt(AnalyzeToken::setEndOffset, new ParseField("end_offset", new String[0]));
            PARSER.declareInt(AnalyzeToken::setPositionLength, new ParseField("positionLength", new String[0]));
        }
    }
}

