/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.salvation2.Values;

import com.shapesecurity.salvation2.Constants;
import com.shapesecurity.salvation2.URLs.URI;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Host {
    @Nullable
    public final String scheme;
    @Nonnull
    public final String host;
    public final int port;
    @Nullable
    public final String path;
    public static final Host STAR = new Host(null, "*", -1, null);

    private Host(String scheme, String host, int port, String path) {
        this.scheme = scheme;
        this.host = host;
        this.port = port;
        this.path = path;
    }

    public static Optional<Host> parseHost(String value) {
        Matcher matcher = Constants.hostSourcePattern.matcher(value);
        if (matcher.find()) {
            String portString;
            String scheme = matcher.group("scheme");
            if (scheme != null) {
                scheme = scheme.substring(0, scheme.length() - 3).toLowerCase(Locale.ENGLISH);
            }
            int port = (portString = matcher.group("port")) == null ? -1 : (portString.equals(":*") ? -200 : Integer.parseInt(portString.substring(1)));
            String host = matcher.group("host").toLowerCase(Locale.ENGLISH);
            String path = matcher.group("path");
            return Optional.of(new Host(scheme, host, port, path));
        }
        return Optional.empty();
    }

    public String toString() {
        boolean isDefaultPort = this.port == -1 || this.scheme != null && this.port == URI.defaultPortForProtocol(this.scheme);
        return (this.scheme == null ? "" : this.scheme + "://") + this.host + (isDefaultPort ? "" : ":" + (this.port == -200 ? "*" : Integer.valueOf(this.port))) + (this.path == null ? "" : this.path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Host that = (Host)o;
        return this.port == that.port && Objects.equals(this.scheme, that.scheme) && Objects.equals(this.host, that.host) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.scheme, this.host, this.port, this.path);
    }
}

