/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.StringTokenizer;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPListParseEngine;
import org.apache.commons.net.ftp.parser.RegexFTPFileEntryParserImpl;

public class VMSFTPEntryParser
extends RegexFTPFileEntryParserImpl {
    private static final String MONTHS = "(JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC)";
    private static final String REGEX = "(.*;[0-9]+)\\s*(\\d+)/\\d+\\s*(\\d{1,2})-(JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC)-([0-9]{4})\\s*((?:[01]\\d)|(?:2[0-3])):([012345]\\d):([012345]\\d)\\s*\\[(([0-9$A-Za-z_]+)|([0-9$A-Za-z_]+),([0-9$a-zA-Z_]+))\\]?\\s*\\([a-zA-Z]*,[a-zA-Z]*,[a-zA-Z]*,[a-zA-Z]*\\)";

    public VMSFTPEntryParser() {
        super(REGEX);
    }

    public FTPFile[] parseFileList(InputStream listStream) throws IOException {
        FTPListParseEngine engine = new FTPListParseEngine(this);
        engine.readServerList(listStream);
        return engine.getFiles();
    }

    public FTPFile parseFTPEntry(String entry) {
        long longBlock = 512L;
        if (this.matches(entry)) {
            String user;
            String grp;
            FTPFile f = new FTPFile();
            f.setRawListing(entry);
            String name = this.group(1);
            String size = this.group(2);
            String day = this.group(3);
            String mo = this.group(4);
            String yr = this.group(5);
            String hr = this.group(6);
            String min = this.group(7);
            String sec = this.group(8);
            String owner = this.group(9);
            StringTokenizer t = new StringTokenizer(owner, ",");
            switch (t.countTokens()) {
                case 1: {
                    grp = null;
                    user = t.nextToken();
                    break;
                }
                case 2: {
                    grp = t.nextToken();
                    user = t.nextToken();
                    break;
                }
                default: {
                    grp = null;
                    user = null;
                }
            }
            if (name.lastIndexOf(".DIR") != -1) {
                f.setType(1);
            } else {
                f.setType(0);
            }
            if (this.isVersioning()) {
                f.setName(name);
            } else {
                name = name.substring(0, name.lastIndexOf(";"));
                f.setName(name);
            }
            Long theSize = new Long(size);
            long sizeInBytes = theSize * longBlock;
            f.setSize(sizeInBytes);
            Calendar cal = Calendar.getInstance();
            cal.clear();
            cal.set(5, new Integer(day));
            cal.set(2, MONTHS.indexOf(mo) / 4);
            cal.set(1, new Integer(yr));
            cal.set(11, new Integer(hr));
            cal.set(12, new Integer(min));
            cal.set(13, new Integer(sec));
            f.setTimestamp(cal);
            f.setGroup(grp);
            f.setUser(user);
            return f;
        }
        return null;
    }

    public String readNextEntry(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        StringBuffer entry = new StringBuffer();
        while (line != null) {
            if (line.startsWith("Directory") || line.startsWith("Total")) {
                line = reader.readLine();
                continue;
            }
            entry.append(line);
            if (line.trim().endsWith(")")) break;
            line = reader.readLine();
        }
        return entry.length() == 0 ? null : entry.toString();
    }

    protected boolean isVersioning() {
        return false;
    }
}

