/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.logging;

import java.util.Set;
import java.util.TreeSet;
import org.openqa.selenium.logging.LocalLogs;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;

class CompositeLocalLogs
extends LocalLogs {
    private final LocalLogs predefinedTypeLogger;
    private final LocalLogs allTypesLogger;

    protected CompositeLocalLogs(LocalLogs predefinedTypeLogger, LocalLogs allTypesLogger) {
        this.predefinedTypeLogger = predefinedTypeLogger;
        this.allTypesLogger = allTypesLogger;
    }

    @Override
    public LogEntries get(String logType) {
        if (this.predefinedTypeLogger.getAvailableLogTypes().contains(logType)) {
            return this.predefinedTypeLogger.get(logType);
        }
        return this.allTypesLogger.get(logType);
    }

    @Override
    public Set<String> getAvailableLogTypes() {
        TreeSet<String> toReturn = new TreeSet<String>();
        toReturn.addAll(this.predefinedTypeLogger.getAvailableLogTypes());
        toReturn.addAll(this.allTypesLogger.getAvailableLogTypes());
        return toReturn;
    }

    @Override
    public void addEntry(String logType, LogEntry entry) {
        if (this.predefinedTypeLogger.getAvailableLogTypes().contains(logType)) {
            this.predefinedTypeLogger.addEntry(logType, entry);
        } else {
            this.allTypesLogger.addEntry(logType, entry);
        }
    }
}

