/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.SharedCapabilitiesMethods;
import org.openqa.selenium.internal.Require;

public class ImmutableCapabilities
implements Capabilities {
    private final Map<String, Object> delegate;
    private final int hashCode;

    public ImmutableCapabilities() {
        this.delegate = Collections.emptyMap();
        this.hashCode = SharedCapabilitiesMethods.hashCode(this);
    }

    public ImmutableCapabilities(String k, Object v) {
        Require.nonNull("Capability", k);
        Require.nonNull("Value", v);
        TreeMap<String, Object> delegate = new TreeMap<String, Object>();
        SharedCapabilitiesMethods.setCapability(delegate, k, v);
        this.delegate = Collections.unmodifiableMap(delegate);
        this.hashCode = SharedCapabilitiesMethods.hashCode(this);
    }

    public ImmutableCapabilities(String k1, Object v1, String k2, Object v2) {
        Require.nonNull("First capability", k1);
        Require.nonNull("First value", v1);
        Require.nonNull("Second capability", k2);
        Require.nonNull("Second value", v2);
        TreeMap<String, Object> delegate = new TreeMap<String, Object>();
        SharedCapabilitiesMethods.setCapability(delegate, k1, v1);
        SharedCapabilitiesMethods.setCapability(delegate, k2, v2);
        this.delegate = Collections.unmodifiableMap(delegate);
        this.hashCode = SharedCapabilitiesMethods.hashCode(this);
    }

    public ImmutableCapabilities(String k1, Object v1, String k2, Object v2, String k3, Object v3) {
        Require.nonNull("First capability", k1);
        Require.nonNull("First value", v1);
        Require.nonNull("Second capability", k2);
        Require.nonNull("Second value", v2);
        Require.nonNull("Third capability", k3);
        Require.nonNull("Third value", v3);
        TreeMap<String, Object> delegate = new TreeMap<String, Object>();
        SharedCapabilitiesMethods.setCapability(delegate, k1, v1);
        SharedCapabilitiesMethods.setCapability(delegate, k2, v2);
        SharedCapabilitiesMethods.setCapability(delegate, k3, v3);
        this.delegate = Collections.unmodifiableMap(delegate);
        this.hashCode = SharedCapabilitiesMethods.hashCode(this);
    }

    public ImmutableCapabilities(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
        Require.nonNull("First capability", k1);
        Require.nonNull("First value", v1);
        Require.nonNull("Second capability", k2);
        Require.nonNull("Second value", v2);
        Require.nonNull("Third capability", k3);
        Require.nonNull("Third value", v3);
        Require.nonNull("Fourth capability", k4);
        Require.nonNull("Fourth value", v4);
        TreeMap<String, Object> delegate = new TreeMap<String, Object>();
        SharedCapabilitiesMethods.setCapability(delegate, k1, v1);
        SharedCapabilitiesMethods.setCapability(delegate, k2, v2);
        SharedCapabilitiesMethods.setCapability(delegate, k3, v3);
        SharedCapabilitiesMethods.setCapability(delegate, k4, v4);
        this.delegate = Collections.unmodifiableMap(delegate);
        this.hashCode = SharedCapabilitiesMethods.hashCode(this);
    }

    public ImmutableCapabilities(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4, String k5, Object v5) {
        Require.nonNull("First capability", k1);
        Require.nonNull("First value", v1);
        Require.nonNull("Second capability", k2);
        Require.nonNull("Second value", v2);
        Require.nonNull("Third capability", k3);
        Require.nonNull("Third value", v3);
        Require.nonNull("Fourth capability", k4);
        Require.nonNull("Fourth value", v4);
        Require.nonNull("Fifth capability", k5);
        Require.nonNull("Fifth value", v5);
        TreeMap<String, Object> delegate = new TreeMap<String, Object>();
        SharedCapabilitiesMethods.setCapability(delegate, k1, v1);
        SharedCapabilitiesMethods.setCapability(delegate, k2, v2);
        SharedCapabilitiesMethods.setCapability(delegate, k3, v3);
        SharedCapabilitiesMethods.setCapability(delegate, k4, v4);
        SharedCapabilitiesMethods.setCapability(delegate, k5, v5);
        this.delegate = Collections.unmodifiableMap(delegate);
        this.hashCode = SharedCapabilitiesMethods.hashCode(this);
    }

    public ImmutableCapabilities(Capabilities other) {
        this(other.asMap());
    }

    public ImmutableCapabilities(Map<?, ?> capabilities) {
        Require.nonNull("Capabilities", capabilities);
        TreeMap delegate = new TreeMap();
        capabilities.forEach((key, value) -> {
            Require.argument("Capability key", key).instanceOf(String.class);
            Object v = capabilities.get(key);
            Require.nonNull("Capability value", value);
            SharedCapabilitiesMethods.setCapability(delegate, (String)key, v);
        });
        this.delegate = Collections.unmodifiableMap(delegate);
        this.hashCode = SharedCapabilitiesMethods.hashCode(this);
    }

    @Override
    public Object getCapability(String capabilityName) {
        Require.nonNull("Capability name", capabilityName);
        return this.delegate.get(capabilityName);
    }

    @Override
    public Map<String, Object> asMap() {
        return this.delegate;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Capabilities)) {
            return false;
        }
        return SharedCapabilitiesMethods.equals(this, (Capabilities)o);
    }

    public String toString() {
        return SharedCapabilitiesMethods.toString(this);
    }

    public static ImmutableCapabilities copyOf(Capabilities capabilities) {
        Require.nonNull("Capabilities", capabilities);
        if (capabilities instanceof ImmutableCapabilities) {
            return (ImmutableCapabilities)capabilities;
        }
        return new ImmutableCapabilities(capabilities);
    }
}

