/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.rabbitmq;

import java.util.HashMap;
import java.util.Map;

class RabbitMQOptionParser {
    RabbitMQOptionParser() {
    }

    static Map<String, String> parseOption(String option) {
        String[] split;
        HashMap<String, String> values = new HashMap<String, String>();
        if (option.isEmpty()) {
            return values;
        }
        for (String s : split = option.split(",")) {
            String[] ss = s.split("=");
            values.put(ss[0], ss[1]);
        }
        return values;
    }

    static Map<String, Object> parseOptionAndConvertValue(String option) {
        String[] split;
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (option.isEmpty()) {
            return values;
        }
        for (String s : split = option.split(",")) {
            String[] ss = s.split("=");
            values.put(ss[0], RabbitMQOptionParser.convert(ss[1]));
        }
        return values;
    }

    static Map<String, Object> parseSubOption(String subOption) {
        String[] split;
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (subOption.isEmpty()) {
            return values;
        }
        for (String s : split = subOption.replaceAll("\\{|}", "").split(";")) {
            String[] ss = s.split(":");
            values.put(ss[0], RabbitMQOptionParser.convert(ss[1]));
        }
        return values;
    }

    private static Object convert(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception exception) {
            try {
                return Float.valueOf(Float.parseFloat(s));
            }
            catch (Exception exception2) {
                if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false")) {
                    return Boolean.parseBoolean(s);
                }
                return s;
            }
        }
    }
}

