/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.nutch.rabbitmq.RabbitMQMessage;
import org.apache.nutch.rabbitmq.RabbitMQOptionParser;

public class RabbitMQClient {
    private static final String DEFAULT_EXCHANGE_NAME = "";
    private static final String DEFAULT_EXCHANGE_TYPE = "direct";
    private static final String DEFAULT_EXCHANGE_DURABLE = "true";
    private static final String DEFAULT_QUEUE_NAME = "nutch.queue";
    private static final String DEFAULT_QUEUE_DURABLE = "true";
    private static final String DEFAULT_QUEUE_EXCLUSIVE = "false";
    private static final String DEFAULT_QUEUE_AUTO_DELETE = "false";
    private static final String DEFAULT_QUEUE_ARGUMENTS = "";
    private static final String DEFAULT_ROUTING_KEY = "nutch.queue";
    private Connection connection;
    private Channel channel;

    public RabbitMQClient(String serverHost, int serverPort, String serverVirtualHost, String serverUsername, String serverPassword) throws IOException {
        ConnectionFactory factory = new ConnectionFactory();
        factory.setHost(RabbitMQClient.getValue(serverHost, "localhost"));
        factory.setPort(RabbitMQClient.getValue(serverPort, 5672).intValue());
        factory.setVirtualHost(RabbitMQClient.getValue(serverVirtualHost, "/"));
        factory.setUsername(RabbitMQClient.getValue(serverUsername, "guest"));
        factory.setPassword(RabbitMQClient.getValue(serverPassword, "guest"));
        try {
            this.connection = factory.newConnection();
        }
        catch (TimeoutException e) {
            throw RabbitMQClient.makeIOException(e);
        }
    }

    public RabbitMQClient(String uri) throws IOException {
        ConnectionFactory factory = new ConnectionFactory();
        try {
            factory.setUri(uri);
            this.connection = factory.newConnection();
        }
        catch (URISyntaxException | KeyManagementException | NoSuchAlgorithmException | TimeoutException e) {
            throw RabbitMQClient.makeIOException(e);
        }
    }

    public void openChannel() throws IOException {
        this.channel = this.connection.createChannel();
    }

    public void bind(String exchangeName, String exchangeOptions, String queueName, String queueOptions, String bindingKey, String bindingArguments) throws IOException {
        String exchangeType = this.exchangeDeclare(exchangeName, exchangeOptions);
        this.queueDeclare(queueName, queueOptions);
        switch (exchangeType) {
            case "fanout": {
                this.channel.queueBind(queueName, exchangeName, "");
                break;
            }
            case "direct": {
                this.channel.queueBind(queueName, exchangeName, RabbitMQClient.getValue(bindingKey, "nutch.queue"));
                break;
            }
            case "headers": {
                this.channel.queueBind(queueName, exchangeName, "", RabbitMQOptionParser.parseOptionAndConvertValue(bindingArguments));
                break;
            }
            case "topic": {
                this.channel.queueBind(queueName, exchangeName, RabbitMQClient.getValue(bindingKey, "nutch.queue"));
                break;
            }
        }
    }

    public void publish(String exchangeName, String routingKey, RabbitMQMessage message) throws IOException {
        this.channel.basicPublish(RabbitMQClient.getValue(exchangeName, ""), RabbitMQClient.getValue(routingKey, "nutch.queue"), new AMQP.BasicProperties.Builder().contentType(message.getContentType()).headers(message.getHeaders()).build(), message.getBody());
    }

    public void close() throws IOException {
        try {
            this.channel.close();
            this.connection.close();
        }
        catch (TimeoutException e) {
            throw RabbitMQClient.makeIOException(e);
        }
    }

    private String exchangeDeclare(String name, String options) throws IOException {
        Map<String, String> values = RabbitMQOptionParser.parseOption(options);
        String type = values.getOrDefault("type", DEFAULT_EXCHANGE_TYPE);
        this.channel.exchangeDeclare(RabbitMQClient.getValue(name, ""), type, Boolean.parseBoolean(values.getOrDefault("durable", "true")));
        return type;
    }

    private void queueDeclare(String name, String options) throws IOException {
        Map<String, String> values = RabbitMQOptionParser.parseOption(options);
        this.channel.queueDeclare(RabbitMQClient.getValue(name, "nutch.queue"), Boolean.parseBoolean(values.getOrDefault("durable", "true")), Boolean.parseBoolean(values.getOrDefault("exclusive", "false")), Boolean.parseBoolean(values.getOrDefault("auto-delete", "false")), RabbitMQOptionParser.parseSubOption(values.getOrDefault("arguments", "")));
    }

    private static String getValue(String value, String defaultValue) {
        if (value == null || value.trim().isEmpty()) {
            return defaultValue;
        }
        return value;
    }

    private static Integer getValue(Integer value, Integer defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private static IOException makeIOException(Exception e) {
        return new IOException(e);
    }
}

