/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.css.parser;

import com.gargoylesoftware.css.parser.AbstractLocatable;
import com.gargoylesoftware.css.parser.LexicalUnit;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class LexicalUnitImpl
extends AbstractLocatable
implements LexicalUnit,
Serializable {
    private final LexicalUnit.LexicalUnitType lexicalUnitType_;
    private LexicalUnit nextLexicalUnit_;
    private LexicalUnit previousLexicalUnit_;
    private double doubleValue_;
    private String dimension_;
    private String functionName_;
    private LexicalUnit parameters_;
    private String stringValue_;
    private transient String toString_;

    public void setNextLexicalUnit(LexicalUnit next) {
        this.nextLexicalUnit_ = next;
    }

    public void setPreviousLexicalUnit(LexicalUnit prev) {
        this.previousLexicalUnit_ = prev;
    }

    public void setDoubleValue(double doubleVal) {
        this.doubleValue_ = doubleVal;
        this.toString_ = null;
    }

    public String getDimension() {
        return this.dimension_;
    }

    public void setDimension(String dimension) {
        this.dimension_ = dimension;
        this.toString_ = null;
    }

    public void setFunctionName(String function) {
        this.functionName_ = function;
        this.toString_ = null;
    }

    public void setParameters(LexicalUnit params) {
        this.parameters_ = params;
        this.toString_ = null;
    }

    public void setStringValue(String stringVal) {
        this.stringValue_ = stringVal;
        this.toString_ = null;
    }

    public LexicalUnitImpl(LexicalUnit previous, LexicalUnit.LexicalUnitType type) {
        this.lexicalUnitType_ = type;
        this.previousLexicalUnit_ = previous;
        if (this.previousLexicalUnit_ != null) {
            ((LexicalUnitImpl)this.previousLexicalUnit_).nextLexicalUnit_ = this;
        }
    }

    protected LexicalUnitImpl(LexicalUnit previous, int value) {
        this(previous, LexicalUnit.LexicalUnitType.INTEGER);
        this.doubleValue_ = value;
    }

    protected LexicalUnitImpl(LexicalUnit previous, LexicalUnit.LexicalUnitType type, double value) {
        this(previous, type);
        this.doubleValue_ = value;
    }

    protected LexicalUnitImpl(LexicalUnit previous, LexicalUnit.LexicalUnitType type, String dimension, double value) {
        this(previous, type);
        this.dimension_ = dimension;
        this.doubleValue_ = value;
    }

    public LexicalUnitImpl(LexicalUnit previous, LexicalUnit.LexicalUnitType type, String value) {
        this(previous, type);
        this.stringValue_ = value;
    }

    protected LexicalUnitImpl(LexicalUnit previous, LexicalUnit.LexicalUnitType type, String name, LexicalUnit params) {
        this(previous, type);
        this.functionName_ = name;
        this.parameters_ = params;
    }

    protected LexicalUnitImpl(LexicalUnit previous, LexicalUnit.LexicalUnitType type, String name, String stringValue) {
        this(previous, type);
        this.functionName_ = name;
        this.stringValue_ = stringValue;
    }

    @Override
    public LexicalUnit.LexicalUnitType getLexicalUnitType() {
        return this.lexicalUnitType_;
    }

    @Override
    public LexicalUnit getNextLexicalUnit() {
        return this.nextLexicalUnit_;
    }

    @Override
    public LexicalUnit getPreviousLexicalUnit() {
        return this.previousLexicalUnit_;
    }

    @Override
    public int getIntegerValue() {
        return (int)this.doubleValue_;
    }

    @Override
    public double getDoubleValue() {
        return this.doubleValue_;
    }

    @Override
    public String getDimensionUnitText() {
        switch (this.lexicalUnitType_) {
            case EM: {
                return "em";
            }
            case REM: {
                return "rem";
            }
            case EX: {
                return "ex";
            }
            case CH: {
                return "ch";
            }
            case VW: {
                return "vw";
            }
            case VH: {
                return "vh";
            }
            case VMIN: {
                return "vmin";
            }
            case VMAX: {
                return "vmax";
            }
            case PIXEL: {
                return "px";
            }
            case INCH: {
                return "in";
            }
            case CENTIMETER: {
                return "cm";
            }
            case MILLIMETER: {
                return "mm";
            }
            case POINT: {
                return "pt";
            }
            case PICA: {
                return "pc";
            }
            case QUATER: {
                return "Q";
            }
            case PERCENTAGE: {
                return "%";
            }
            case DEGREE: {
                return "deg";
            }
            case GRADIAN: {
                return "grad";
            }
            case RADIAN: {
                return "rad";
            }
            case TURN: {
                return "turn";
            }
            case MILLISECOND: {
                return "ms";
            }
            case SECOND: {
                return "s";
            }
            case HERTZ: {
                return "Hz";
            }
            case KILOHERTZ: {
                return "kHz";
            }
            case DIMENSION: {
                return this.dimension_;
            }
        }
        return "";
    }

    @Override
    public String getFunctionName() {
        return this.functionName_;
    }

    @Override
    public LexicalUnit getParameters() {
        return this.parameters_;
    }

    @Override
    public String getStringValue() {
        return this.stringValue_;
    }

    @Override
    public LexicalUnit getSubValues() {
        return this.parameters_;
    }

    public String getCssText() {
        if (null != this.toString_) {
            return this.toString_;
        }
        StringBuilder sb = new StringBuilder();
        switch (this.lexicalUnitType_) {
            case OPERATOR_COMMA: {
                sb.append(",");
                break;
            }
            case OPERATOR_PLUS: {
                sb.append("+");
                break;
            }
            case OPERATOR_MINUS: {
                sb.append("-");
                break;
            }
            case OPERATOR_MULTIPLY: {
                sb.append("*");
                break;
            }
            case OPERATOR_SLASH: {
                sb.append("/");
                break;
            }
            case OPERATOR_MOD: {
                sb.append("%");
                break;
            }
            case OPERATOR_EXP: {
                sb.append("^");
                break;
            }
            case OPERATOR_LT: {
                sb.append("<");
                break;
            }
            case OPERATOR_GT: {
                sb.append(">");
                break;
            }
            case OPERATOR_LE: {
                sb.append("<=");
                break;
            }
            case OPERATOR_GE: {
                sb.append(">=");
                break;
            }
            case OPERATOR_TILDE: {
                sb.append("~");
                break;
            }
            case INHERIT: {
                sb.append("inherit");
                break;
            }
            case INTEGER: {
                sb.append(String.valueOf(this.getIntegerValue()));
                break;
            }
            case REAL: {
                sb.append(this.getTrimedDoubleValue());
                break;
            }
            case EM: 
            case REM: 
            case EX: 
            case CH: 
            case VW: 
            case VH: 
            case VMIN: 
            case VMAX: 
            case PIXEL: 
            case INCH: 
            case CENTIMETER: 
            case MILLIMETER: 
            case POINT: 
            case PICA: 
            case QUATER: 
            case PERCENTAGE: 
            case DEGREE: 
            case GRADIAN: 
            case RADIAN: 
            case TURN: 
            case MILLISECOND: 
            case SECOND: 
            case HERTZ: 
            case KILOHERTZ: 
            case DIMENSION: {
                sb.append(this.getTrimedDoubleValue());
                String dimUnitText = this.getDimensionUnitText();
                if (null == dimUnitText) break;
                sb.append(dimUnitText);
                break;
            }
            case URI: {
                sb.append("url(\"").append(this.getStringValue()).append("\")");
                break;
            }
            case COUNTER_FUNCTION: {
                sb.append("counter(");
                this.appendParams(sb);
                sb.append(")");
                break;
            }
            case COUNTERS_FUNCTION: {
                sb.append("counters(");
                this.appendParams(sb);
                sb.append(")");
                break;
            }
            case RGBCOLOR: {
                sb.append("rgb(");
                this.appendParams(sb);
                sb.append(")");
                break;
            }
            case HSLCOLOR: {
                sb.append("hsl(");
                this.appendParams(sb);
                sb.append(")");
                break;
            }
            case IDENT: {
                sb.append(this.getStringValue());
                break;
            }
            case STRING_VALUE: {
                sb.append("\"");
                String value = this.getStringValue();
                value = value.replace("\n", "\\A ").replace("\r", "\\D ");
                sb.append(value);
                sb.append("\"");
                break;
            }
            case ATTR: {
                sb.append("attr(").append(this.getStringValue()).append(")");
                break;
            }
            case RECT_FUNCTION: {
                sb.append("rect(");
                this.appendParams(sb);
                sb.append(")");
                break;
            }
            case UNICODERANGE: {
                String range = this.getStringValue();
                if (null == range) break;
                sb.append(range);
                break;
            }
            case FUNCTION: 
            case FUNCTION_CALC: {
                String functName = this.getFunctionName();
                if (null != functName) {
                    sb.append(functName);
                }
                sb.append('(');
                this.appendParams(sb);
                sb.append(")");
                break;
            }
        }
        this.toString_ = sb.toString();
        return this.toString_;
    }

    public String toString() {
        return this.getCssText();
    }

    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        switch (this.lexicalUnitType_) {
            case OPERATOR_COMMA: {
                sb.append("OPERATOR_COMMA");
                break;
            }
            case OPERATOR_PLUS: {
                sb.append("OPERATOR_PLUS");
                break;
            }
            case OPERATOR_MINUS: {
                sb.append("OPERATOR_MINUS");
                break;
            }
            case OPERATOR_MULTIPLY: {
                sb.append("OPERATOR_MULTIPLY");
                break;
            }
            case OPERATOR_SLASH: {
                sb.append("OPERATOR_SLASH");
                break;
            }
            case OPERATOR_MOD: {
                sb.append("OPERATOR_MOD");
                break;
            }
            case OPERATOR_EXP: {
                sb.append("OPERATOR_EXP");
                break;
            }
            case OPERATOR_LT: {
                sb.append("OPERATOR_LT");
                break;
            }
            case OPERATOR_GT: {
                sb.append("OPERATOR_GT");
                break;
            }
            case OPERATOR_LE: {
                sb.append("OPERATOR_LE");
                break;
            }
            case OPERATOR_GE: {
                sb.append("OPERATOR_GE");
                break;
            }
            case OPERATOR_TILDE: {
                sb.append("OPERATOR_TILDE");
                break;
            }
            case INHERIT: {
                sb.append("INHERIT");
                break;
            }
            case INTEGER: {
                sb.append("INTEGER(").append(String.valueOf(this.getIntegerValue())).append(")");
                break;
            }
            case REAL: {
                sb.append("REAL(").append(this.getTrimedDoubleValue()).append(")");
                break;
            }
            case EM: {
                sb.append("EM(").append(this.getTrimedDoubleValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case REM: {
                sb.append("REM(").append(this.getTrimedDoubleValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case EX: {
                sb.append("EX(").append(this.getTrimedDoubleValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case CH: {
                sb.append("CH(").append(this.getTrimedDoubleValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case VW: {
                sb.append("VW(").append(this.getTrimedDoubleValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case VH: {
                sb.append("VH(").append(this.getTrimedDoubleValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case VMIN: {
                sb.append("VMIN(").append(this.getTrimedDoubleValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case VMAX: {
                sb.append("VMAX(").append(this.getTrimedDoubleValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case PIXEL: {
                sb.append("PIXEL(").append(this.getTrimedDoubleValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case INCH: {
                sb.append("INCH(").append(this.getTrimedDoubleValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case CENTIMETER: {
                sb.append("CENTIMETER(").append(this.getTrimedDoubleValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case MILLIMETER: {
                sb.append("MILLIMETER(").append(this.getTrimedDoubleValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case POINT: {
                sb.append("POINT(").append(this.getTrimedDoubleValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case PICA: {
                sb.append("PICA(").append(this.getTrimedDoubleValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case QUATER: {
                sb.append("QUATER(").append(this.getTrimedDoubleValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case PERCENTAGE: {
                sb.append("PERCENTAGE(").append(this.getTrimedDoubleValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case DEGREE: {
                sb.append("DEGREE(").append(this.getTrimedDoubleValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case GRADIAN: {
                sb.append("GRADIAN(").append(this.getTrimedDoubleValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case RADIAN: {
                sb.append("RADIAN(").append(this.getTrimedDoubleValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case TURN: {
                sb.append("TURN(").append(this.getTrimedDoubleValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case MILLISECOND: {
                sb.append("MILLISECOND(").append(this.getTrimedDoubleValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case SECOND: {
                sb.append("SECOND(").append(this.getTrimedDoubleValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case HERTZ: {
                sb.append("HERTZ(").append(this.getTrimedDoubleValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case KILOHERTZ: {
                sb.append("KILOHERTZ(").append(this.getTrimedDoubleValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case DIMENSION: {
                sb.append("DIMENSION(").append(this.getTrimedDoubleValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case URI: {
                sb.append("URI(url(").append(this.getStringValue()).append("))");
                break;
            }
            case COUNTER_FUNCTION: {
                sb.append("COUNTER_FUNCTION(counter(");
                this.appendParams(sb);
                sb.append("))");
                break;
            }
            case COUNTERS_FUNCTION: {
                sb.append("COUNTERS_FUNCTION(counters(");
                this.appendParams(sb);
                sb.append("))");
                break;
            }
            case RGBCOLOR: {
                sb.append("RGBCOLOR(rgb(");
                this.appendParams(sb);
                sb.append("))");
                break;
            }
            case HSLCOLOR: {
                sb.append("HSLCOLOR(hsl(");
                this.appendParams(sb);
                sb.append("))");
                break;
            }
            case IDENT: {
                sb.append("IDENT(").append(this.getStringValue()).append(")");
                break;
            }
            case STRING_VALUE: {
                sb.append("STRING_VALUE(\"").append(this.getStringValue()).append("\")");
                break;
            }
            case ATTR: {
                sb.append("ATTR(attr(").append(this.getStringValue()).append("))");
                break;
            }
            case RECT_FUNCTION: {
                sb.append("RECT_FUNCTION(rect(");
                this.appendParams(sb);
                sb.append("))");
                break;
            }
            case UNICODERANGE: {
                sb.append("UNICODERANGE(").append(this.getStringValue()).append(")");
                break;
            }
            case FUNCTION: 
            case FUNCTION_CALC: {
                sb.append("FUNCTION(").append(this.getFunctionName()).append("(");
                for (LexicalUnit l = this.parameters_; l != null; l = l.getNextLexicalUnit()) {
                    sb.append(l);
                }
                sb.append("))");
                break;
            }
        }
        return sb.toString();
    }

    private void appendParams(StringBuilder sb) {
        LexicalUnit l = this.parameters_;
        if (l != null) {
            sb.append(l);
            LexicalUnit last = l;
            for (l = l.getNextLexicalUnit(); l != null; l = l.getNextLexicalUnit()) {
                if (l.getLexicalUnitType() != LexicalUnit.LexicalUnitType.OPERATOR_COMMA && !"=".equals(l.toString()) && !"=".equals(last.toString())) {
                    sb.append(" ");
                }
                sb.append(l);
                last = l;
            }
        }
    }

    private String getTrimedDoubleValue() {
        int i;
        double d = this.getDoubleValue();
        if (d - (double)(i = (int)d) == 0.0) {
            return Integer.toString(i);
        }
        String str = Double.toString(d);
        if (str.contains("E")) {
            DecimalFormat decimalFormat = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
            decimalFormat.setGroupingUsed(false);
            decimalFormat.setMaximumFractionDigits(7);
            return decimalFormat.format(d);
        }
        return str;
    }

    public static LexicalUnit createNumber(LexicalUnit prev, int i) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.INTEGER, i);
    }

    public static LexicalUnit createNumber(LexicalUnit prev, double d) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.REAL, d);
    }

    public static LexicalUnit createPercentage(LexicalUnit prev, double d) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.PERCENTAGE, d);
    }

    public static LexicalUnit createPixel(LexicalUnit prev, double d) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.PIXEL, d);
    }

    public static LexicalUnit createCentimeter(LexicalUnit prev, double d) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.CENTIMETER, d);
    }

    public static LexicalUnit createMillimeter(LexicalUnit prev, double d) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.MILLIMETER, d);
    }

    public static LexicalUnit createInch(LexicalUnit prev, double d) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.INCH, d);
    }

    public static LexicalUnit createPoint(LexicalUnit prev, double d) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.POINT, d);
    }

    public static LexicalUnit createPica(LexicalUnit prev, double d) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.PICA, d);
    }

    public static LexicalUnit createQuater(LexicalUnit prev, double d) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.QUATER, d);
    }

    public static LexicalUnit createEm(LexicalUnit prev, double d) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.EM, d);
    }

    public static LexicalUnit createRem(LexicalUnit prev, double d) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.REM, d);
    }

    public static LexicalUnit createEx(LexicalUnit prev, double d) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.EX, d);
    }

    public static LexicalUnit createCh(LexicalUnit prev, double d) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.CH, d);
    }

    public static LexicalUnit createVw(LexicalUnit prev, double d) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.VW, d);
    }

    public static LexicalUnit createVh(LexicalUnit prev, double d) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.VH, d);
    }

    public static LexicalUnit createVMin(LexicalUnit prev, double d) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.VMIN, d);
    }

    public static LexicalUnit createVMax(LexicalUnit prev, double d) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.VMAX, d);
    }

    public static LexicalUnit createDegree(LexicalUnit prev, double d) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.DEGREE, d);
    }

    public static LexicalUnit createRadian(LexicalUnit prev, double d) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.RADIAN, d);
    }

    public static LexicalUnit createGradian(LexicalUnit prev, double d) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.GRADIAN, d);
    }

    public static LexicalUnit createTurn(LexicalUnit prev, double d) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.TURN, d);
    }

    public static LexicalUnit createMillisecond(LexicalUnit prev, double d) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.MILLISECOND, d);
    }

    public static LexicalUnit createSecond(LexicalUnit prev, double d) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.SECOND, d);
    }

    public static LexicalUnit createHertz(LexicalUnit prev, double d) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.HERTZ, d);
    }

    public static LexicalUnit createDimension(LexicalUnit prev, double d, String dim) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.DIMENSION, dim, d);
    }

    public static LexicalUnit createKiloHertz(LexicalUnit prev, double d) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.KILOHERTZ, d);
    }

    public static LexicalUnit createCounter(LexicalUnit prev, LexicalUnit params) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.COUNTER_FUNCTION, "counter", params);
    }

    public static LexicalUnit createCounters(LexicalUnit prev, LexicalUnit params) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.COUNTERS_FUNCTION, "counters", params);
    }

    public static LexicalUnit createAttr(LexicalUnit prev, String value) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.ATTR, "name", value);
    }

    public static LexicalUnit createRect(LexicalUnit prev, LexicalUnit params) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.RECT_FUNCTION, "rect", params);
    }

    public static LexicalUnit createRgbColor(LexicalUnit prev, String funct, LexicalUnit params) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.RGBCOLOR, funct, params);
    }

    public static LexicalUnit createHslColor(LexicalUnit prev, String funct, LexicalUnit params) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.HSLCOLOR, funct, params);
    }

    public static LexicalUnit createCalc(LexicalUnit prev, LexicalUnit params) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.FUNCTION_CALC, "calc", params);
    }

    public static LexicalUnit createFunction(LexicalUnit prev, String name, LexicalUnit params) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.FUNCTION, name, params);
    }

    public static LexicalUnit createString(LexicalUnit prev, String value) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.STRING_VALUE, value);
    }

    public static LexicalUnit createIdent(LexicalUnit prev, String value) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.IDENT, value);
    }

    public static LexicalUnit createURI(LexicalUnit prev, String value) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.URI, value);
    }

    public static LexicalUnit createComma(LexicalUnit prev) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.OPERATOR_COMMA);
    }

    public static LexicalUnit createSlash(LexicalUnit prev) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.OPERATOR_SLASH);
    }

    public static LexicalUnit createPlus(LexicalUnit prev) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.OPERATOR_PLUS);
    }

    public static LexicalUnit createMinus(LexicalUnit prev) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.OPERATOR_MINUS);
    }

    public static LexicalUnit createMultiply(LexicalUnit prev) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.OPERATOR_MULTIPLY);
    }

    public static LexicalUnit createDivide(LexicalUnit prev) {
        return new LexicalUnitImpl(prev, LexicalUnit.LexicalUnitType.OPERATOR_SLASH);
    }
}

