/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.bulk;

import org.opensearch.action.ActionRequestBuilder;
import org.opensearch.action.bulk.BulkAction;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteRequestBuilder;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexRequestBuilder;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.action.support.WriteRequestBuilder;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateRequestBuilder;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.common.Nullable;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;

public class BulkRequestBuilder
extends ActionRequestBuilder<BulkRequest, BulkResponse>
implements WriteRequestBuilder<BulkRequestBuilder> {
    @Deprecated
    public BulkRequestBuilder(OpenSearchClient client, BulkAction action, @Nullable String globalIndex, @Nullable String globalType) {
        super(client, action, new BulkRequest(globalIndex, globalType));
    }

    public BulkRequestBuilder(OpenSearchClient client, BulkAction action, @Nullable String globalIndex) {
        super(client, action, new BulkRequest(globalIndex));
    }

    public BulkRequestBuilder(OpenSearchClient client, BulkAction action) {
        super(client, action, new BulkRequest());
    }

    public BulkRequestBuilder add(IndexRequest request) {
        ((BulkRequest)this.request).add(request);
        return this;
    }

    public BulkRequestBuilder add(IndexRequestBuilder request) {
        ((BulkRequest)this.request).add((IndexRequest)request.request());
        return this;
    }

    public BulkRequestBuilder add(DeleteRequest request) {
        ((BulkRequest)this.request).add(request);
        return this;
    }

    public BulkRequestBuilder add(DeleteRequestBuilder request) {
        ((BulkRequest)this.request).add((DeleteRequest)request.request());
        return this;
    }

    public BulkRequestBuilder add(UpdateRequest request) {
        ((BulkRequest)this.request).add(request);
        return this;
    }

    public BulkRequestBuilder add(UpdateRequestBuilder request) {
        ((BulkRequest)this.request).add((UpdateRequest)request.request());
        return this;
    }

    public BulkRequestBuilder add(byte[] data, int from, int length, XContentType xContentType) throws Exception {
        ((BulkRequest)this.request).add(data, from, length, null, xContentType);
        return this;
    }

    @Deprecated
    public BulkRequestBuilder add(byte[] data, int from, int length, @Nullable String defaultIndex, @Nullable String defaultType, XContentType xContentType) throws Exception {
        ((BulkRequest)this.request).add(data, from, length, defaultIndex, defaultType, xContentType);
        return this;
    }

    public BulkRequestBuilder add(byte[] data, int from, int length, @Nullable String defaultIndex, XContentType xContentType) throws Exception {
        ((BulkRequest)this.request).add(data, from, length, defaultIndex, "_doc", xContentType);
        return this;
    }

    public BulkRequestBuilder setWaitForActiveShards(ActiveShardCount waitForActiveShards) {
        ((BulkRequest)this.request).waitForActiveShards(waitForActiveShards);
        return this;
    }

    public BulkRequestBuilder setWaitForActiveShards(int waitForActiveShards) {
        return this.setWaitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    public final BulkRequestBuilder setTimeout(TimeValue timeout) {
        ((BulkRequest)this.request).timeout(timeout);
        return this;
    }

    public final BulkRequestBuilder setTimeout(String timeout) {
        ((BulkRequest)this.request).timeout(timeout);
        return this;
    }

    public int numberOfActions() {
        return ((BulkRequest)this.request).numberOfActions();
    }

    public BulkRequestBuilder pipeline(String globalPipeline) {
        ((BulkRequest)this.request).pipeline(globalPipeline);
        return this;
    }

    public BulkRequestBuilder routing(String globalRouting) {
        ((BulkRequest)this.request).routing(globalRouting);
        return this;
    }
}

