/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.scoring.link;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.Inlinks;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.scoring.AbstractScoringFilter;
import org.apache.nutch.scoring.ScoringFilterException;

public class LinkAnalysisScoringFilter
extends AbstractScoringFilter {
    private float normalizedScore = 1.0f;
    private float initialScore = 0.0f;

    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.normalizedScore = conf.getFloat("link.analyze.normalize.score", 1.0f);
    }

    public float generatorSortValue(Text url, CrawlDatum datum, float initSort) throws ScoringFilterException {
        return datum.getScore() * initSort;
    }

    public float indexerScore(Text url, NutchDocument doc, CrawlDatum dbDatum, CrawlDatum fetchDatum, Parse parse, Inlinks inlinks, float initScore) throws ScoringFilterException {
        if (dbDatum == null) {
            return initScore;
        }
        return this.normalizedScore * dbDatum.getScore();
    }

    public void initialScore(Text url, CrawlDatum datum) throws ScoringFilterException {
        datum.setScore(this.initialScore);
    }

    public void passScoreAfterParsing(Text url, Content content, Parse parse) throws ScoringFilterException {
        parse.getData().getContentMeta().set("nutch.crawl.score", content.getMetadata().get("nutch.crawl.score"));
    }

    public void passScoreBeforeParsing(Text url, CrawlDatum datum, Content content) throws ScoringFilterException {
        content.getMetadata().set("nutch.crawl.score", "" + datum.getScore());
    }
}

