/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.xml.utils;

public class SuballocatedIntVector {
    protected final int m_blocksize;
    protected int m_SHIFT = 0;
    protected final int m_MASK;
    protected static final int NUMBLOCKS_DEFAULT = 32;
    protected final int m_numblocks;
    protected int[][] m_map;
    protected int m_firstFree = 0;
    protected final int[] m_map0;
    protected int[] m_buildCache;
    protected int m_buildCacheStartIndex;

    public SuballocatedIntVector(int blocksize, int numblocks) {
        while (0 != (blocksize >>>= 1)) {
            ++this.m_SHIFT;
        }
        this.m_blocksize = 1 << this.m_SHIFT;
        this.m_MASK = this.m_blocksize - 1;
        this.m_numblocks = numblocks;
        this.m_map0 = new int[this.m_blocksize];
        this.m_map = new int[numblocks][];
        this.m_map[0] = this.m_map0;
        this.m_buildCache = this.m_map0;
        this.m_buildCacheStartIndex = 0;
    }

    public SuballocatedIntVector(int blocksize) {
        this(blocksize, 32);
    }

    public int size() {
        return this.m_firstFree;
    }

    public void addElement(int value) {
        int indexRelativeToCache = this.m_firstFree - this.m_buildCacheStartIndex;
        if (indexRelativeToCache >= 0 && indexRelativeToCache < this.m_blocksize) {
            this.m_buildCache[indexRelativeToCache] = value;
            ++this.m_firstFree;
        } else {
            int[] block;
            int index = this.m_firstFree >>> this.m_SHIFT;
            int offset = this.m_firstFree & this.m_MASK;
            if (index >= this.m_map.length) {
                int newsize = index + this.m_numblocks;
                int[][] newMap = new int[newsize][];
                System.arraycopy(this.m_map, 0, newMap, 0, this.m_map.length);
                this.m_map = newMap;
            }
            if (null == (block = this.m_map[index])) {
                this.m_map[index] = new int[this.m_blocksize];
                block = this.m_map[index];
            }
            block[offset] = value;
            this.m_buildCache = block;
            this.m_buildCacheStartIndex = this.m_firstFree - offset;
            ++this.m_firstFree;
        }
    }

    public void setElementAt(int value, int at) {
        if (at < this.m_blocksize) {
            this.m_map0[at] = value;
        } else {
            int[] block;
            int index = at >>> this.m_SHIFT;
            int offset = at & this.m_MASK;
            if (index >= this.m_map.length) {
                int newsize = index + this.m_numblocks;
                int[][] newMap = new int[newsize][];
                System.arraycopy(this.m_map, 0, newMap, 0, this.m_map.length);
                this.m_map = newMap;
            }
            if (null == (block = this.m_map[index])) {
                this.m_map[index] = new int[this.m_blocksize];
                block = this.m_map[index];
            }
            block[offset] = value;
        }
        if (at >= this.m_firstFree) {
            this.m_firstFree = at + 1;
        }
    }

    public int elementAt(int i) {
        if (i < this.m_blocksize) {
            return this.m_map0[i];
        }
        return this.m_map[i >>> this.m_SHIFT][i & this.m_MASK];
    }

    public int indexOf(int elem, int index) {
        int[] block;
        if (index >= this.m_firstFree) {
            return -1;
        }
        int boffset = index & this.m_MASK;
        int maxindex = this.m_firstFree >>> this.m_SHIFT;
        for (int bindex = index >>> this.m_SHIFT; bindex < maxindex; ++bindex) {
            block = this.m_map[bindex];
            if (block != null) {
                for (int offset = boffset; offset < this.m_blocksize; ++offset) {
                    if (block[offset] != elem) continue;
                    return offset + bindex * this.m_blocksize;
                }
            }
            boffset = 0;
        }
        int maxoffset = this.m_firstFree & this.m_MASK;
        block = this.m_map[maxindex];
        for (int offset = boffset; offset < maxoffset; ++offset) {
            if (block[offset] != elem) continue;
            return offset + maxindex * this.m_blocksize;
        }
        return -1;
    }

    public int indexOf(int elem) {
        return this.indexOf(elem, 0);
    }
}

