/*
 * Decompiled with CFR 0.152.
 */
package com.martinkl.warc;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class WARCRecord {
    public static final String WARC_VERSION = "WARC/1.0";
    private static final int MAX_LINE_LENGTH = 10000;
    private static final Pattern VERSION_PATTERN = Pattern.compile("WARC/[0-9\\.]+");
    private static final Pattern CONTINUATION_PATTERN = Pattern.compile("^[\\t ]+.*");
    private static final String CRLF = "\r\n";
    private static final byte[] CRLF_BYTES = new byte[]{13, 10};
    private final Header header;
    private final byte[] content;

    public WARCRecord(DataInput in) throws IOException {
        this.header = WARCRecord.readHeader(in);
        this.content = new byte[this.header.getContentLength()];
        in.readFully(this.content);
        WARCRecord.readSeparator(in);
    }

    private static Header readHeader(DataInput in) throws IOException {
        String line;
        String versionLine = WARCRecord.readLine(in);
        if (!VERSION_PATTERN.matcher(versionLine).matches()) {
            throw new IllegalStateException("Expected WARC version, but got: " + versionLine);
        }
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        String fieldName = null;
        do {
            line = WARCRecord.readLine(in);
            if (fieldName != null && CONTINUATION_PATTERN.matcher(line).matches()) {
                headers.put(fieldName, (String)headers.get(fieldName) + line);
                continue;
            }
            if (line.isEmpty()) continue;
            String[] field = line.split(":", 2);
            if (field.length < 2) {
                throw new IllegalStateException("Malformed header line: " + line);
            }
            fieldName = field[0].trim();
            headers.put(fieldName, field[1].trim());
        } while (!line.isEmpty());
        return new Header(headers);
    }

    private static String readLine(DataInput in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        boolean seenCR = false;
        boolean seenCRLF = false;
        while (!seenCRLF) {
            if (out.size() > 10000) {
                throw new IllegalStateException("Exceeded maximum line length");
            }
            byte b = in.readByte();
            if (!seenCR && b == 13) {
                seenCR = true;
                continue;
            }
            if (seenCR && b == 10) {
                seenCRLF = true;
                continue;
            }
            seenCR = false;
            out.write(b);
        }
        return out.toString("UTF-8");
    }

    private static void readSeparator(DataInput in) throws IOException {
        byte[] sep = new byte[4];
        in.readFully(sep);
        if (sep[0] != 13 || sep[1] != 10 || sep[2] != 13 || sep[3] != 10) {
            throw new IllegalStateException(String.format("Expected final separator CR LF CR LF, but got: %d %d %d %d", sep[0], sep[1], sep[2], sep[3]));
        }
    }

    public Header getHeader() {
        return this.header;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void write(DataOutput out) throws IOException {
        this.header.write(out);
        out.write(CRLF_BYTES);
        out.write(this.content);
        out.write(CRLF_BYTES);
        out.write(CRLF_BYTES);
    }

    public String toString() {
        return this.header.toString();
    }

    public static class Header {
        private final Map<String, String> fields;

        private Header(Map<String, String> fields) {
            this.fields = fields;
        }

        public String getRecordType() {
            return this.fields.get("WARC-Type");
        }

        public String getDateString() {
            return this.fields.get("WARC-Date");
        }

        public String getRecordID() {
            return this.fields.get("WARC-Record-ID");
        }

        public String getContentType() {
            return this.fields.get("Content-Type");
        }

        public String getTargetURI() {
            return this.fields.get("WARC-Target-URI");
        }

        public int getContentLength() {
            String lengthStr = this.fields.get("Content-Length");
            if (lengthStr == null) {
                throw new IllegalStateException("Missing Content-Length header");
            }
            try {
                return Integer.parseInt(lengthStr);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("Malformed Content-Length header: " + lengthStr);
            }
        }

        public String getField(String field) {
            return this.fields.get(field);
        }

        public void write(DataOutput out) throws IOException {
            out.write(this.toString().getBytes("UTF-8"));
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(WARCRecord.WARC_VERSION);
            buf.append(WARCRecord.CRLF);
            for (Map.Entry<String, String> field : this.fields.entrySet()) {
                buf.append(field.getKey());
                buf.append(": ");
                buf.append(field.getValue());
                buf.append(WARCRecord.CRLF);
            }
            return buf.toString();
        }
    }
}

