/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol.http;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.hadoop.io.Text;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.metadata.Metadata;
import org.apache.nutch.metadata.SpellCheckedMetadata;
import org.apache.nutch.net.protocols.HttpDateFormat;
import org.apache.nutch.net.protocols.Response;
import org.apache.nutch.protocol.ProtocolException;
import org.apache.nutch.protocol.http.DummyX509TrustManager;
import org.apache.nutch.protocol.http.Http;
import org.apache.nutch.protocol.http.api.HttpBase;
import org.apache.nutch.protocol.http.api.HttpException;

public class HttpResponse
implements Response {
    private HttpBase http;
    private URL url;
    private byte[] content;
    private int code;
    private Metadata headers;
    private StringBuffer httpHeaders;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse(HttpBase http, URL url, CrawlDatum datum) throws ProtocolException, IOException {
        block51: {
            Object portString;
            int port;
            this.headers = new SpellCheckedMetadata();
            this.http = http;
            this.url = url;
            Scheme scheme = null;
            if ("http".equals(url.getProtocol())) {
                scheme = Scheme.HTTP;
            } else if ("https".equals(url.getProtocol())) {
                scheme = Scheme.HTTPS;
            } else {
                throw new HttpException("Unknown scheme (not http/https) for url:" + String.valueOf(url));
            }
            Http.LOG.trace("fetching {}", (Object)url);
            Object path = url.getFile();
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            String host = url.getHost();
            if (url.getPort() == -1) {
                port = scheme == Scheme.HTTP ? 80 : 443;
                portString = "";
            } else {
                port = url.getPort();
                portString = ":" + port;
            }
            try (Socket socket = null;){
                String accept;
                String acceptCharset;
                boolean useProxy = http.useProxy(url);
                if (useProxy) {
                    Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(http.getProxyHost(), http.getProxyPort()));
                    socket = new Socket(proxy);
                } else {
                    socket = new Socket();
                }
                socket.setSoTimeout(http.getTimeout());
                int sockPort = http.useProxy(url) ? http.getProxyPort() : port;
                InetSocketAddress sockAddr = new InetSocketAddress(host, port);
                socket.connect(sockAddr, http.getTimeout());
                if (scheme == Scheme.HTTPS) {
                    SSLSocket sslsocket = null;
                    try {
                        sslsocket = this.getSSLSocket(socket, host, port);
                        sslsocket.startHandshake();
                    }
                    catch (Exception e) {
                        Http.LOG.debug("SSL connection to {} failed with: {}", (Object)url, (Object)e.getMessage());
                        if ("handshake alert:  unrecognized_name".equals(e.getMessage())) {
                            try {
                                socket = new Socket();
                                socket.setSoTimeout(http.getTimeout());
                                socket.connect(sockAddr, http.getTimeout());
                                sslsocket = this.getSSLSocket(socket, "", sockPort);
                                sslsocket.startHandshake();
                            }
                            catch (Exception ex) {
                                String msg = "SSL reconnect to " + String.valueOf(url) + " failed with: " + e.getMessage();
                                throw new HttpException(msg);
                            }
                        }
                        String msg = "SSL connect to " + String.valueOf(url) + " failed with: " + e.getMessage();
                        throw new HttpException(msg, (Throwable)e);
                    }
                    socket = sslsocket;
                }
                if (http.isStoreIPAddress()) {
                    this.headers.add("_ip_", sockAddr.getAddress().getHostAddress());
                }
                OutputStream req = socket.getOutputStream();
                StringBuffer reqStr = new StringBuffer("GET ");
                if (http.useProxy(url)) {
                    reqStr.append(url.getProtocol() + "://" + host + (String)portString + (String)path);
                } else {
                    reqStr.append((String)path);
                }
                if (http.getUseHttp11()) {
                    reqStr.append(" HTTP/1.1\r\n");
                } else {
                    reqStr.append(" HTTP/1.0\r\n");
                }
                reqStr.append("Host: ");
                reqStr.append(host);
                reqStr.append((String)portString);
                reqStr.append("\r\n");
                reqStr.append("Accept-Encoding: x-gzip, gzip, deflate\r\n");
                String userAgent = http.getUserAgent();
                if (userAgent == null || userAgent.length() == 0) {
                    Http.LOG.error("User-agent is not set!");
                } else {
                    reqStr.append("User-Agent: ");
                    reqStr.append(userAgent);
                    reqStr.append("\r\n");
                }
                String acceptLanguage = http.getAcceptLanguage();
                if (!acceptLanguage.isEmpty()) {
                    reqStr.append("Accept-Language: ");
                    reqStr.append(acceptLanguage);
                    reqStr.append("\r\n");
                }
                if (!(acceptCharset = http.getAcceptCharset()).isEmpty()) {
                    reqStr.append("Accept-Charset: ");
                    reqStr.append(acceptCharset);
                    reqStr.append("\r\n");
                }
                if (!(accept = http.getAccept()).isEmpty()) {
                    reqStr.append("Accept: ");
                    reqStr.append(accept);
                    reqStr.append("\r\n");
                }
                if (http.isCookieEnabled()) {
                    String cookie = null;
                    if (datum.getMetaData().containsKey((Object)HttpBase.COOKIE)) {
                        cookie = ((Text)datum.getMetaData().get((Object)HttpBase.COOKIE)).toString();
                    }
                    if (cookie == null) {
                        cookie = http.getCookie(url);
                    }
                    if (cookie != null) {
                        reqStr.append("Cookie: ");
                        reqStr.append(cookie);
                        reqStr.append("\r\n");
                    }
                }
                if (http.isIfModifiedSinceEnabled() && datum.getModifiedTime() > 0L) {
                    reqStr.append("If-Modified-Since: " + HttpDateFormat.toString((long)datum.getModifiedTime()));
                    reqStr.append("\r\n");
                }
                reqStr.append("Connection: close\r\n");
                reqStr.append("\r\n");
                if (http.isStoreHttpRequest()) {
                    this.headers.add("_request_", reqStr.toString());
                }
                byte[] reqBytes = reqStr.toString().getBytes();
                req.write(reqBytes);
                req.flush();
                PushbackInputStream in = new PushbackInputStream(new BufferedInputStream(socket.getInputStream(), 8192), 8192);
                StringBuffer line = new StringBuffer();
                StringBuffer lineSeparator = new StringBuffer();
                if (http.isStoreHttpHeaders()) {
                    this.httpHeaders = new StringBuffer();
                }
                this.headers.add("nutch.fetch.time", Long.toString(System.currentTimeMillis()));
                boolean haveSeenNonContinueStatus = false;
                while (!haveSeenNonContinueStatus) {
                    try {
                        this.code = this.parseStatusLine(in, line, lineSeparator);
                    }
                    catch (HttpException e) {
                        Http.LOG.warn("Missing or invalid HTTP status line", (Throwable)e);
                        Http.LOG.warn("No HTTP header, assuming HTTP/0.9 for {}", (Object)this.getUrl());
                        this.code = 200;
                        in.unread(lineSeparator.toString().getBytes(StandardCharsets.ISO_8859_1));
                        in.unread(line.toString().getBytes(StandardCharsets.ISO_8859_1));
                        break;
                    }
                    if (this.httpHeaders != null) {
                        this.httpHeaders.append(line).append("\r\n");
                    }
                    this.parseHeaders(in, line, this.httpHeaders);
                    haveSeenNonContinueStatus = this.code != 100;
                }
                try {
                    String transferEncoding = this.getHeader("Transfer-Encoding");
                    if (transferEncoding != null && "chunked".equalsIgnoreCase(transferEncoding.trim())) {
                        this.readChunkedContent(in, line);
                    } else {
                        this.readPlainContent(in);
                    }
                    String contentEncoding = this.getHeader("Content-Encoding");
                    if ("gzip".equals(contentEncoding) || "x-gzip".equals(contentEncoding)) {
                        this.content = http.processGzipEncoded(this.content, url);
                    } else if ("deflate".equals(contentEncoding)) {
                        this.content = http.processDeflateEncoded(this.content, url);
                    } else {
                        Http.LOG.trace("fetched {} bytes from {}", (Object)this.content.length, (Object)url);
                    }
                    if (this.httpHeaders != null) {
                        this.httpHeaders.append("\r\n");
                        this.headers.add("_response.headers_", this.httpHeaders.toString());
                    }
                }
                catch (IOException | HttpException e) {
                    if (this.code != 200) {
                        Http.LOG.warn("Ignored exception while reading payload of response with status code " + this.code + ":", e);
                        this.content = null;
                        if (this.httpHeaders != null) {
                            this.httpHeaders.append("\r\n");
                            this.headers.add("_response.headers_", this.httpHeaders.toString());
                        }
                        break block51;
                    }
                    throw e;
                }
            }
        }
    }

    public URL getUrl() {
        return this.url;
    }

    public int getCode() {
        return this.code;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public Metadata getHeaders() {
        return this.headers;
    }

    public byte[] getContent() {
        return this.content;
    }

    private SSLSocket getSSLSocket(Socket socket, String sockHost, int sockPort) throws Exception {
        SSLSocketFactory factory;
        if (this.http.isTlsCheckCertificates()) {
            factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        } else {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{new DummyX509TrustManager(null)}, null);
            factory = sslContext.getSocketFactory();
        }
        SSLSocket sslsocket = (SSLSocket)factory.createSocket(socket, sockHost, sockPort, true);
        sslsocket.setUseClientMode(true);
        HashSet<String> protocols = new HashSet<String>(Arrays.asList(sslsocket.getSupportedProtocols()));
        HashSet<String> ciphers = new HashSet<String>(Arrays.asList(sslsocket.getSupportedCipherSuites()));
        protocols.retainAll(this.http.getTlsPreferredProtocols());
        ciphers.retainAll(this.http.getTlsPreferredCipherSuites());
        sslsocket.setEnabledProtocols(protocols.toArray(new String[protocols.size()]));
        sslsocket.setEnabledCipherSuites(ciphers.toArray(new String[ciphers.size()]));
        return sslsocket;
    }

    private void readPlainContent(InputStream in) throws HttpException, IOException {
        int contentLength = Integer.MAX_VALUE;
        String contentLengthString = this.headers.get("Content-Length");
        if (contentLengthString != null) {
            contentLengthString = contentLengthString.trim();
            try {
                if (!contentLengthString.isEmpty()) {
                    contentLength = Integer.parseInt(contentLengthString);
                }
            }
            catch (NumberFormatException e) {
                Http.LOG.warn("bad content length: {}", (Object)contentLengthString);
            }
        }
        if (this.http.getMaxContent() >= 0 && contentLength > this.http.getMaxContent()) {
            contentLength = this.http.getMaxContent();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        byte[] bytes = new byte[8192];
        int length = 0;
        if (contentLength == 0) {
            this.content = new byte[0];
            return;
        }
        int i = in.read(bytes);
        while (i != -1) {
            out.write(bytes, 0, i);
            if ((length += i) >= contentLength) break;
            if (length + 8192 > contentLength) {
                i = in.read(bytes, 0, contentLength - length);
                continue;
            }
            i = in.read(bytes);
        }
        this.content = out.toByteArray();
    }

    private void readChunkedContent(PushbackInputStream in, StringBuffer line) throws HttpException, IOException {
        boolean doneChunks = false;
        int contentBytesRead = 0;
        byte[] bytes = new byte[8192];
        ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
        while (true) {
            int chunkBytesRead;
            int len;
            int chunkLen;
            Http.LOG.trace("Http: starting chunk");
            HttpResponse.readLine(in, line, false);
            int pos = line.indexOf(";");
            String chunkLenStr = pos < 0 ? line.toString() : line.substring(0, pos);
            chunkLenStr = chunkLenStr.trim();
            try {
                chunkLen = Integer.parseInt(chunkLenStr, 16);
            }
            catch (NumberFormatException e) {
                throw new HttpException("bad chunk length: " + line.toString());
            }
            if (chunkLen == 0) {
                doneChunks = true;
                break;
            }
            if (this.http.getMaxContent() >= 0 && contentBytesRead + chunkLen > this.http.getMaxContent()) {
                chunkLen = this.http.getMaxContent() - contentBytesRead;
            }
            for (chunkBytesRead = 0; chunkBytesRead < chunkLen; chunkBytesRead += len) {
                int toRead = chunkLen - chunkBytesRead < 8192 ? chunkLen - chunkBytesRead : 8192;
                len = in.read(bytes, 0, toRead);
                if (len == -1) {
                    throw new HttpException("chunk eof after " + contentBytesRead + " bytes in successful chunks and " + chunkBytesRead + " in current chunk");
                }
                out.write(bytes, 0, len);
            }
            if (this.http.getMaxContent() >= 0 && (contentBytesRead += chunkBytesRead) >= this.http.getMaxContent()) {
                Http.LOG.trace("Http: content limit reached");
                break;
            }
            HttpResponse.readLine(in, line, false);
        }
        this.content = out.toByteArray();
        if (!doneChunks) {
            if (contentBytesRead != this.http.getMaxContent()) {
                throw new HttpException("chunk eof: !doneChunk && didn't max out");
            }
            return;
        }
        this.parseHeaders(in, line, null);
    }

    private int parseStatusLine(PushbackInputStream in, StringBuffer line, StringBuffer lineSeparator) throws IOException, HttpException {
        int codeEnd;
        HttpResponse.readLine(in, line, false, 2048, lineSeparator);
        int codeStart = line.indexOf(" ");
        int lineLength = line.length();
        for (codeEnd = codeStart + 1; codeEnd < lineLength && Character.isDigit(line.charAt(codeEnd)); ++codeEnd) {
        }
        try {
            return Integer.parseInt(line.substring(codeStart + 1, codeEnd));
        }
        catch (NumberFormatException e) {
            throw new HttpException("Bad status line, no HTTP response code: " + String.valueOf(line), (Throwable)e);
        }
    }

    private void processHeaderLine(StringBuffer line) {
        char c;
        int valueStart;
        int colonIndex = line.indexOf(":");
        if (colonIndex == -1) {
            Http.LOG.info("Ignoring a header line without a colon: '{}'", (Object)line);
            return;
        }
        String key = line.substring(0, colonIndex);
        for (valueStart = colonIndex + 1; valueStart < line.length() && ((c = line.charAt(valueStart)) == ' ' || c == '\t'); ++valueStart) {
        }
        String value = line.substring(valueStart);
        this.headers.set(key, value);
    }

    private void parseHeaders(PushbackInputStream in, StringBuffer line, StringBuffer httpHeaders) throws IOException, HttpException {
        while (HttpResponse.readLine(in, line, true) != 0) {
            int pos;
            if (httpHeaders != null) {
                httpHeaders.append(line).append("\r\n");
            }
            if ((pos = line.indexOf("<!DOCTYPE")) != -1 || (pos = line.indexOf("<HTML")) != -1 || (pos = line.indexOf("<html")) != -1) {
                in.unread(line.substring(pos).getBytes(StandardCharsets.ISO_8859_1));
                line.setLength(pos);
                try {
                    this.processHeaderLine(line);
                }
                catch (Exception e) {
                    Http.LOG.warn("Error: ", (Throwable)e);
                }
                return;
            }
            this.processHeaderLine(line);
        }
    }

    private static int readLine(PushbackInputStream in, StringBuffer line, boolean allowContinuedLine) throws IOException {
        return HttpResponse.readLine(in, line, allowContinuedLine, 8192, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int readLine(PushbackInputStream in, StringBuffer line, boolean allowContinuedLine, int maxBytes, StringBuffer lineSeparator) throws IOException {
        int bytesRead;
        line.setLength(0);
        int c = in.read();
        for (bytesRead = 0; c != -1 && bytesRead < maxBytes; ++bytesRead) {
            block0 : switch (c) {
                case 13: {
                    if (lineSeparator != null) {
                        lineSeparator.append((char)c);
                    }
                    if (HttpResponse.peek(in) == 10) {
                        in.read();
                        if (lineSeparator != null) {
                            lineSeparator.append((char)c);
                        }
                    }
                }
                case 10: {
                    if (lineSeparator != null) {
                        lineSeparator.append((char)c);
                    }
                    if (line.length() <= 0 || !allowContinuedLine) return line.length();
                    switch (HttpResponse.peek(in)) {
                        case 9: 
                        case 32: {
                            in.read();
                            if (lineSeparator == null) break block0;
                            lineSeparator.replace(0, lineSeparator.length(), "");
                            break block0;
                        }
                        default: {
                            return line.length();
                        }
                    }
                }
                default: {
                    line.append((char)c);
                }
            }
            c = in.read();
        }
        if (bytesRead < maxBytes) return line.length();
        throw new IOException("Line exceeds max. buffer size: " + line.substring(0, Math.min(32, line.length())));
    }

    private static int peek(PushbackInputStream in) throws IOException {
        int value = in.read();
        in.unread(value);
        return value;
    }

    protected static enum Scheme {
        HTTP,
        HTTPS;

    }
}

