/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;

public enum FirefoxDriverLogLevel {
    TRACE,
    DEBUG,
    CONFIG,
    INFO,
    WARN,
    ERROR,
    FATAL;

    private static final Map<Level, FirefoxDriverLogLevel> logLevelToGeckoLevelMap;

    public String toString() {
        return super.toString().toLowerCase();
    }

    public static FirefoxDriverLogLevel fromString(String text) {
        if (text != null) {
            for (FirefoxDriverLogLevel b : FirefoxDriverLogLevel.values()) {
                if (!text.equalsIgnoreCase(b.toString())) continue;
                return b;
            }
        }
        return null;
    }

    public static FirefoxDriverLogLevel fromLevel(Level level) {
        return logLevelToGeckoLevelMap.getOrDefault(level, DEBUG);
    }

    Map<String, String> toJson() {
        return Collections.singletonMap("level", this.toString());
    }

    static FirefoxDriverLogLevel fromJson(Map<String, String> json) {
        return FirefoxDriverLogLevel.fromString(json.get("level"));
    }

    static {
        logLevelToGeckoLevelMap = new ImmutableMap.Builder().put((Object)Level.ALL, (Object)TRACE).put((Object)Level.FINEST, (Object)TRACE).put((Object)Level.FINER, (Object)TRACE).put((Object)Level.FINE, (Object)DEBUG).put((Object)Level.CONFIG, (Object)CONFIG).put((Object)Level.INFO, (Object)INFO).put((Object)Level.WARNING, (Object)WARN).put((Object)Level.SEVERE, (Object)ERROR).put((Object)Level.OFF, (Object)FATAL).build();
    }
}

