/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.activex.javascript.msxml;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.MSXMLScriptable;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMDocument;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMDocumentFragment;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMElement;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMNodeList;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLDOMSelection;
import com.gargoylesoftware.htmlunit.activex.javascript.msxml.XMLSerializer;
import com.gargoylesoftware.htmlunit.html.DomCDataSection;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;

@JsxClass(value={SupportedBrowser.IE})
public class XMLDOMNode
extends MSXMLScriptable {
    private XMLDOMNodeList childNodes_;

    @JsxGetter
    public Object getAttributes() {
        return null;
    }

    @JsxGetter
    public String getBaseName() {
        DomNode domNode = this.getDomNodeOrDie();
        String baseName = domNode.getLocalName();
        if (baseName == null) {
            return "";
        }
        return baseName;
    }

    @JsxGetter
    public XMLDOMNodeList getChildNodes() {
        if (this.childNodes_ == null) {
            final DomNode domNode = this.getDomNodeOrDie();
            boolean isXmlPage = domNode.getOwnerDocument() instanceof XmlPage;
            Boolean xmlSpaceDefault = XMLDOMNode.isXMLSpaceDefault(domNode);
            final boolean skipEmptyTextNode = isXmlPage && !Boolean.FALSE.equals(xmlSpaceDefault);
            this.childNodes_ = new XMLDOMNodeList(domNode, false, "XMLDOMNode.childNodes"){

                @Override
                protected List<DomNode> computeElements() {
                    ArrayList<DomNode> response = new ArrayList<DomNode>();
                    for (DomNode child : domNode.getChildren()) {
                        if (skipEmptyTextNode && child instanceof DomText && !(child instanceof DomCDataSection) && StringUtils.isBlank((CharSequence)child.getNodeValue())) continue;
                        response.add(child);
                    }
                    return response;
                }
            };
        }
        return this.childNodes_;
    }

    private static Boolean isXMLSpaceDefault(DomNode node) {
        while (node instanceof DomElement) {
            String value = ((DomElement)node).getAttribute("xml:space");
            if (!value.isEmpty()) {
                return "default".equals(value);
            }
            node = node.getParentNode();
        }
        return null;
    }

    @JsxGetter
    public String getDataType() {
        return null;
    }

    @JsxGetter
    public String getDefinition() {
        return null;
    }

    @JsxGetter
    public XMLDOMNode getFirstChild() {
        DomNode domNode = this.getDomNodeOrDie();
        return this.getJavaScriptNode(domNode.getFirstChild());
    }

    @JsxSetter
    public void setFirstChild(Object ignored) {
        throw ScriptRuntime.typeError((String)"Wrong number of arguments or invalid property assignment");
    }

    @JsxGetter
    public XMLDOMNode getLastChild() {
        DomNode domNode = this.getDomNodeOrDie();
        return this.getJavaScriptNode(domNode.getLastChild());
    }

    @JsxSetter
    public void setLastChild(Object ignored) {
        throw ScriptRuntime.typeError((String)"Wrong number of arguments or invalid property assignment");
    }

    @JsxGetter
    public String getNamespaceURI() {
        DomNode domNode = this.getDomNodeOrDie();
        String namespaceURI = domNode.getNamespaceURI();
        if (namespaceURI == null) {
            return "";
        }
        return namespaceURI;
    }

    @JsxGetter
    public XMLDOMNode getNextSibling() {
        DomNode domNode = this.getDomNodeOrDie();
        return this.getJavaScriptNode(domNode.getNextSibling());
    }

    @JsxGetter
    public String getNodeName() {
        DomNode domNode = this.getDomNodeOrDie();
        return domNode.getNodeName();
    }

    @JsxGetter
    public short getNodeType() {
        DomNode domNode = this.getDomNodeOrDie();
        return domNode.getNodeType();
    }

    @JsxGetter
    public String getNodeValue() {
        DomNode domNode = this.getDomNodeOrDie();
        return domNode.getNodeValue();
    }

    @JsxSetter
    public void setNodeValue(String value) {
        if (value == null || "null".equals(value)) {
            throw Context.reportRuntimeError((String)"Type mismatch.");
        }
        DomNode domNode = this.getDomNodeOrDie();
        domNode.setNodeValue(value);
    }

    @JsxGetter
    public Object getOwnerDocument() {
        DomNode domNode = this.getDomNodeOrDie();
        Document document = domNode.getOwnerDocument();
        if (document == null) {
            return null;
        }
        return ((SgmlPage)document).getScriptableObject();
    }

    @JsxGetter
    public Object getParentNode() {
        DomNode domNode = this.getDomNodeOrDie();
        return this.getJavaScriptNode(domNode.getParentNode());
    }

    @JsxGetter
    public String getPrefix() {
        DomNode domNode = this.getDomNodeOrDie();
        String prefix = domNode.getPrefix();
        if (prefix == null || domNode.getHtmlPageOrNull() != null) {
            return "";
        }
        return prefix;
    }

    @JsxGetter
    public XMLDOMNode getPreviousSibling() {
        DomNode domNode = this.getDomNodeOrDie();
        return this.getJavaScriptNode(domNode.getPreviousSibling());
    }

    @JsxGetter
    public Object getText() {
        DomNode domNode = this.getDomNodeOrDie();
        return domNode.getTextContent();
    }

    @JsxSetter
    public void setText(Object text) {
        DomNode domNode = this.getDomNodeOrDie();
        domNode.setTextContent(text == null ? null : Context.toString((Object)text));
    }

    @JsxGetter
    public Object getXml() {
        String xml;
        DomNode domNode = this.getDomNodeOrDie();
        if (this instanceof XMLDOMElement) {
            boolean preserveWhiteSpace = ((XMLDOMDocument)this.getOwnerDocument()).isPreserveWhiteSpaceDuringLoad();
            XMLSerializer serializer = new XMLSerializer(preserveWhiteSpace);
            xml = serializer.serializeToString(this);
        } else {
            xml = domNode.asXml();
        }
        if (xml.endsWith("\r\n")) {
            xml = xml.substring(0, xml.length() - 2);
        }
        return xml;
    }

    @JsxFunction
    public Object appendChild(Object newChild) {
        if (newChild == null || "null".equals(newChild)) {
            throw Context.reportRuntimeError((String)"Type mismatch.");
        }
        Object appendedChild = null;
        if (newChild instanceof XMLDOMNode) {
            XMLDOMNode childNode = (XMLDOMNode)newChild;
            DomNode childDomNode = childNode.getDomNodeOrDie();
            DomNode parentNode = this.getDomNodeOrDie();
            parentNode.appendChild(childDomNode);
            appendedChild = newChild;
            if (!(parentNode instanceof SgmlPage) && !(this instanceof XMLDOMDocumentFragment) && parentNode.getParentNode() == null) {
                DomDocumentFragment fragment = parentNode.getPage().createDocumentFragment();
                fragment.appendChild(parentNode);
            }
        }
        return appendedChild;
    }

    @JsxFunction
    public Object cloneNode(boolean deep) {
        DomNode domNode = this.getDomNodeOrDie();
        DomNode clonedNode = domNode.cloneNode(deep);
        return this.getJavaScriptNode(clonedNode);
    }

    @JsxFunction
    public boolean hasChildNodes() {
        DomNode domNode = this.getDomNodeOrDie();
        return domNode.getChildren().iterator().hasNext();
    }

    @JsxFunction
    public static Object insertBefore(Context context, Scriptable thisObj, Object[] args, Function function) {
        return ((XMLDOMNode)thisObj).insertBeforeImpl(args);
    }

    protected Object insertBeforeImpl(Object[] args) {
        Object newChildObject = args[0];
        Object refChildObject = args.length > 1 ? args[1] : Undefined.instance;
        Object appendedChild = null;
        if (newChildObject instanceof XMLDOMNode) {
            DomNode refChildNode;
            XMLDOMNode newChild = (XMLDOMNode)newChildObject;
            DomNode newChildNode = newChild.getDomNodeOrDie();
            if (newChildNode instanceof DomDocumentFragment) {
                DomDocumentFragment fragment = (DomDocumentFragment)newChildNode;
                for (DomNode child : fragment.getChildren()) {
                    this.insertBeforeImpl(new Object[]{child.getScriptableObject(), refChildObject});
                }
                return newChildObject;
            }
            if (Undefined.isUndefined((Object)refChildObject)) {
                if (args.length > 1) {
                    throw Context.reportRuntimeError((String)"Invalid argument.");
                }
                refChildNode = null;
            } else {
                refChildNode = refChildObject == null ? null : ((XMLDOMNode)refChildObject).getDomNodeOrDie();
            }
            DomNode domNode = this.getDomNodeOrDie();
            if (refChildNode == null) {
                domNode.appendChild(newChildNode);
            } else {
                refChildNode.insertBefore(newChildNode);
            }
            appendedChild = newChildObject;
            if (domNode.getParentNode() == null) {
                DomDocumentFragment fragment = domNode.getPage().createDocumentFragment();
                fragment.appendChild(domNode);
            }
        }
        return appendedChild;
    }

    @JsxFunction
    public Object removeChild(Object childNode) {
        Object removedChild = null;
        if (childNode instanceof XMLDOMNode) {
            DomNode childDomNode = ((XMLDOMNode)childNode).getDomNodeOrDie();
            childDomNode.remove();
            removedChild = childNode;
        }
        return removedChild;
    }

    @JsxFunction
    public Object replaceChild(Object newChild, Object oldChild) {
        Object removedChild = null;
        if (newChild instanceof XMLDOMDocumentFragment) {
            XMLDOMDocumentFragment fragment = (XMLDOMDocumentFragment)newChild;
            XMLDOMNode firstNode = null;
            XMLDOMNode refChildObject = ((XMLDOMNode)oldChild).getNextSibling();
            for (DomNode node : fragment.getDomNodeOrDie().getChildren()) {
                if (firstNode == null) {
                    this.replaceChild(node.getScriptableObject(), oldChild);
                    firstNode = (XMLDOMNode)node.getScriptableObject();
                    continue;
                }
                this.insertBeforeImpl(new Object[]{node.getScriptableObject(), refChildObject});
            }
            if (firstNode == null) {
                this.removeChild(oldChild);
            }
            removedChild = oldChild;
        } else if (newChild instanceof XMLDOMNode && oldChild instanceof XMLDOMNode) {
            XMLDOMNode newChildNode = (XMLDOMNode)newChild;
            DomNode newChildDomNode = newChildNode.getDomNodeOrDie();
            DomNode oldChildDomNode = ((XMLDOMNode)oldChild).getDomNodeOrDie();
            oldChildDomNode.replace(newChildDomNode);
            removedChild = oldChild;
        }
        return removedChild;
    }

    @JsxFunction
    public XMLDOMSelection selectNodes(final String expression) {
        final DomNode domNode = this.getDomNodeOrDie();
        boolean attributeChangeSensitive = expression.contains("@");
        return new XMLDOMSelection(domNode, attributeChangeSensitive, "XMLDOMNode.selectNodes('" + expression + "')"){

            @Override
            protected List<DomNode> computeElements() {
                return new ArrayList<DomNode>(domNode.getByXPath(expression));
            }
        };
    }

    @JsxFunction
    public Object selectSingleNode(String expression) {
        XMLDOMSelection collection = this.selectNodes(expression);
        if (collection.getLength() > 0) {
            return collection.get(0, (Scriptable)collection);
        }
        return null;
    }

    protected XMLDOMNode getJavaScriptNode(DomNode domNode) {
        if (domNode == null) {
            return null;
        }
        return (XMLDOMNode)this.getScriptableFor(domNode);
    }
}

