/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.server;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.authn.AuthenticationInterceptor;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.exception.ExceptionInterceptor;
import org.apache.directory.server.core.normalization.NormalizationInterceptor;
import org.apache.directory.server.core.operational.OperationalAttributeInterceptor;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.core.referral.ReferralInterceptor;
import org.apache.directory.server.core.subtree.SubentryInterceptor;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.protocol.shared.store.LdifFileLoader;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.shared.ldap.exception.LdapNameNotFoundException;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.Lifecycle;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.security.ldap.server.EmbeddedLdapServerContainer;
import org.springframework.util.Assert;

@Deprecated(since="5.2", forRemoval=true)
public class ApacheDSContainer
implements EmbeddedLdapServerContainer,
InitializingBean,
DisposableBean,
Lifecycle,
ApplicationContextAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    final DefaultDirectoryService service;
    LdapServer server;
    private TcpTransport transport;
    private ApplicationContext ctxt;
    private File workingDir;
    private boolean running;
    private final String ldifResources;
    private final JdbmPartition partition;
    private final String root;
    private int port = 53389;
    private int localPort;
    private boolean ldapOverSslEnabled;
    private File keyStoreFile;
    private String certificatePassord;

    public ApacheDSContainer(String root, String ldifs) throws Exception {
        this.ldifResources = ldifs;
        this.service = new DefaultDirectoryService();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new NormalizationInterceptor());
        list.add(new AuthenticationInterceptor());
        list.add(new ReferralInterceptor());
        list.add(new ExceptionInterceptor());
        list.add(new OperationalAttributeInterceptor());
        list.add(new SubentryInterceptor());
        this.service.setInterceptors(list);
        this.partition = new JdbmPartition();
        this.partition.setId("rootPartition");
        this.partition.setSuffix(root);
        this.root = root;
        this.service.addPartition((Partition)this.partition);
        this.service.setExitVmOnShutdown(false);
        this.service.setShutdownHookEnabled(false);
        this.service.getChangeLog().setEnabled(false);
        this.service.setDenormalizeOpAttrsEnabled(true);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.workingDir == null) {
            String apacheWorkDir = System.getProperty("apacheDSWorkDir");
            if (apacheWorkDir == null) {
                apacheWorkDir = this.createTempDirectory("apacheds-spring-security-");
            }
            this.setWorkingDirectory(new File(apacheWorkDir));
        }
        Assert.isTrue((!this.ldapOverSslEnabled || this.keyStoreFile != null ? 1 : 0) != 0, (String)"When LdapOverSsl is enabled, the keyStoreFile property must be set.");
        this.server = new LdapServer();
        this.server.setDirectoryService((DirectoryService)this.service);
        this.transport = new TcpTransport(this.port);
        if (this.ldapOverSslEnabled) {
            this.transport.setEnableSSL(true);
            this.server.setKeystoreFile(this.keyStoreFile.getAbsolutePath());
            this.server.setCertificatePassword(this.certificatePassord);
        }
        this.server.setTransports(new Transport[]{this.transport});
        this.start();
    }

    public void destroy() {
        this.stop();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ctxt = applicationContext;
    }

    public void setWorkingDirectory(File workingDir) {
        Assert.notNull((Object)workingDir, (String)"workingDir cannot be null");
        this.logger.info((Object)("Setting working directory for LDAP_PROVIDER: " + workingDir.getAbsolutePath()));
        Assert.isTrue((!workingDir.exists() ? 1 : 0) != 0, (String)("The specified working directory '" + workingDir.getAbsolutePath() + "' already exists. Another directory service instance may be using it or it may be from a  previous unclean shutdown. Please confirm and delete it or configure a different working directory"));
        this.workingDir = workingDir;
        this.service.setWorkingDirectory(workingDir);
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLdapOverSslEnabled(boolean ldapOverSslEnabled) {
        this.ldapOverSslEnabled = ldapOverSslEnabled;
    }

    public void setKeyStoreFile(File keyStoreFile) {
        Assert.notNull((Object)keyStoreFile, (String)"The keyStoreFile must not be null.");
        Assert.isTrue((boolean)keyStoreFile.isFile(), (String)"The keyStoreFile must be a file.");
        this.keyStoreFile = keyStoreFile;
    }

    public void setCertificatePassord(String certificatePassord) {
        this.certificatePassord = certificatePassord;
    }

    public DefaultDirectoryService getService() {
        return this.service;
    }

    public void start() {
        if (this.isRunning()) {
            return;
        }
        Assert.state((!this.service.isStarted() ? 1 : 0) != 0, (String)"DirectoryService is already running.");
        this.logger.info((Object)"Starting directory server...");
        try {
            this.service.startup();
            this.server.start();
        }
        catch (Exception ex) {
            throw new RuntimeException("Server startup failed", ex);
        }
        try {
            this.service.getAdminSession().lookup(this.partition.getSuffixDn());
        }
        catch (LdapNameNotFoundException ex) {
            this.handleLdapNameNotFoundException();
        }
        catch (Exception ex) {
            this.logger.error((Object)"Lookup failed", (Throwable)ex);
        }
        SocketAcceptor socketAcceptor = this.server.getSocketAcceptor((Transport)this.transport);
        InetSocketAddress localAddress = socketAcceptor.getLocalAddress();
        this.localPort = localAddress.getPort();
        this.running = true;
        try {
            this.importLdifs();
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to import LDIF file(s)", ex);
        }
    }

    private void handleLdapNameNotFoundException() {
        try {
            LdapDN dn = new LdapDN(this.root);
            Assert.isTrue((boolean)this.root.startsWith("dc="), (String)"root must start with dc=");
            String dc = this.root.substring(3, this.root.indexOf(44));
            ServerEntry entry = this.service.newEntry(dn);
            entry.add("objectClass", new String[]{"top", "domain", "extensibleObject"});
            entry.add("dc", new String[]{dc});
            this.service.getAdminSession().add(entry);
        }
        catch (Exception ex) {
            this.logger.error((Object)"Failed to create dc entry", (Throwable)ex);
        }
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.logger.info((Object)"Shutting down directory server ...");
        try {
            this.server.stop();
            this.service.shutdown();
        }
        catch (Exception ex) {
            this.logger.error((Object)"Shutdown failed", (Throwable)ex);
            return;
        }
        this.running = false;
        if (this.workingDir.exists()) {
            this.logger.info((Object)("Deleting working directory " + this.workingDir.getAbsolutePath()));
            this.deleteDir(this.workingDir);
        }
    }

    private void importLdifs() throws Exception {
        Resource[] ldifs;
        Resource[] resourceArray = ldifs = this.ctxt != null ? this.ctxt.getResources(this.ldifResources) : new PathMatchingResourcePatternResolver().getResources(this.ldifResources);
        if (ldifs == null || ldifs.length == 0) {
            return;
        }
        Assert.isTrue((ldifs.length == 1 ? 1 : 0) != 0, () -> "More than one LDIF resource found with the supplied pattern:" + this.ldifResources + " Got " + Arrays.toString(ldifs));
        String ldifFile = this.getLdifFile(ldifs);
        this.logger.info((Object)("Loading LDIF file: " + ldifFile));
        LdifFileLoader loader = new LdifFileLoader(this.service.getAdminSession(), new File(ldifFile), null, this.getClass().getClassLoader());
        loader.execute();
    }

    private String getLdifFile(Resource[] ldifs) throws IOException {
        try {
            return ldifs[0].getFile().getAbsolutePath();
        }
        catch (IOException ex) {
            return ldifs[0].getURI().toString();
        }
    }

    private String createTempDirectory(String prefix) throws IOException {
        String fileNamePrefix;
        String parentTempDir = System.getProperty("java.io.tmpdir");
        String fileName = fileNamePrefix = prefix + System.nanoTime();
        for (int i = 0; i < 1000; ++i) {
            File tempDir = new File(parentTempDir, fileName);
            if (!tempDir.exists()) {
                return tempDir.getAbsolutePath();
            }
            fileName = fileNamePrefix + "~" + i;
        }
        throw new IOException("Failed to create a temporary directory for file at " + String.valueOf(new File(parentTempDir, fileNamePrefix)));
    }

    private boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children;
            for (String child : children = dir.list()) {
                boolean success = this.deleteDir(new File(dir, child));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public boolean isRunning() {
        return this.running;
    }
}

