/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.PageAddressCacheRecord;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.StatefulAtom;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.Plannable;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.BinarySequence;
import io.questdb.std.DirectLongList;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.std.Rnd;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.LongAdder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncFilterAtom
implements StatefulAtom,
Closeable,
Plannable {
    public static final LongAdder PRE_TOUCH_BLACK_HOLE = new LongAdder();
    private final Function filter;
    private final ObjList<Function> perWorkerFilters;
    private final AtomicIntegerArray perWorkerLocks;
    private final IntList preTouchColumnTypes;
    private final Rnd rnd;
    private boolean preTouchEnabled;

    public AsyncFilterAtom(@NotNull CairoConfiguration configuration, @NotNull Function filter, @Nullable ObjList<Function> perWorkerFilters, @Nullable IntList preTouchColumnTypes) {
        this.rnd = new Rnd(configuration.getNanosecondClock().getTicks(), configuration.getMicrosecondClock().getTicks());
        this.filter = filter;
        this.perWorkerFilters = perWorkerFilters;
        this.perWorkerLocks = perWorkerFilters != null ? new AtomicIntegerArray(perWorkerFilters.size()) : null;
        this.preTouchColumnTypes = preTouchColumnTypes;
    }

    public int acquireFilter(int workerId, boolean owner, SqlExecutionCircuitBreaker circuitBreaker) {
        if (this.perWorkerFilters == null) {
            return -1;
        }
        if (workerId == -1 && owner) {
            return -1;
        }
        int size = this.perWorkerFilters.size();
        workerId = workerId == -1 ? this.rnd.nextInt(size) : workerId;
        while (true) {
            for (int i = 0; i < size; ++i) {
                int id = (i + workerId) % size;
                if (!this.perWorkerLocks.compareAndSet(id, 0, 1)) continue;
                return id;
            }
            circuitBreaker.statefulThrowExceptionIfTripped();
            Os.pause();
        }
    }

    @Override
    public void close() {
        Misc.free(this.filter);
        Misc.freeObjList(this.perWorkerFilters);
    }

    public Function getFilter(int filterId) {
        if (filterId == -1) {
            return this.filter;
        }
        assert (this.perWorkerFilters != null);
        return this.perWorkerFilters.getQuick(filterId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
        this.filter.init(symbolTableSource, executionContext);
        if (this.perWorkerFilters != null) {
            boolean current = executionContext.getCloneSymbolTables();
            executionContext.setCloneSymbolTables(true);
            try {
                Function.init(this.perWorkerFilters, symbolTableSource, executionContext);
            }
            finally {
                executionContext.setCloneSymbolTables(current);
            }
        }
        this.preTouchEnabled = executionContext.isColumnPreTouchEnabled();
    }

    public void preTouchColumns(PageAddressCacheRecord record, DirectLongList rows) {
        if (!this.preTouchEnabled || this.preTouchColumnTypes == null) {
            return;
        }
        long sum = 0L;
        for (long p = 0L; p < rows.size(); ++p) {
            long r = rows.get(p);
            record.setRowIndex(r);
            block18: for (int i = 0; i < this.preTouchColumnTypes.size(); ++i) {
                int columnType = this.preTouchColumnTypes.getQuick(i);
                switch (ColumnType.tagOf(columnType)) {
                    case 1: {
                        sum += record.getBool(i) ? 1L : 0L;
                        continue block18;
                    }
                    case 2: {
                        sum += (long)record.getByte(i);
                        continue block18;
                    }
                    case 3: {
                        sum += (long)record.getShort(i);
                        continue block18;
                    }
                    case 5: 
                    case 12: {
                        sum += (long)record.getInt(i);
                        continue block18;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        sum += record.getLong(i);
                        continue block18;
                    }
                    case 9: {
                        sum = (long)((float)sum + record.getFloat(i));
                        continue block18;
                    }
                    case 10: {
                        sum = (long)((double)sum + record.getDouble(i));
                        continue block18;
                    }
                    case 13: {
                        Long256 l256 = record.getLong256A(i);
                        sum += l256.getLong0();
                        sum += l256.getLong1();
                        sum += l256.getLong2();
                        sum += l256.getLong3();
                        continue block18;
                    }
                    case 14: {
                        sum += (long)record.getGeoByte(i);
                        continue block18;
                    }
                    case 15: {
                        sum += (long)record.getGeoShort(i);
                        continue block18;
                    }
                    case 16: {
                        sum += (long)record.getGeoInt(i);
                        continue block18;
                    }
                    case 17: {
                        sum += record.getGeoLong(i);
                        continue block18;
                    }
                    case 11: {
                        CharSequence cs = record.getStr(i);
                        if (cs == null || cs.length() <= 0) continue block18;
                        sum += (long)cs.charAt(0);
                        continue block18;
                    }
                    case 18: {
                        BinarySequence bs = record.getBin(i);
                        if (bs == null || bs.length() <= 0L) continue block18;
                        sum += (long)bs.byteAt(0L);
                        continue block18;
                    }
                    case 19: {
                        sum += record.getLong128Hi(i);
                        sum += record.getLong128Lo(i);
                    }
                }
            }
        }
        PRE_TOUCH_BLACK_HOLE.add(sum);
    }

    public void releaseFilter(int filterId) {
        if (filterId == -1) {
            return;
        }
        this.perWorkerLocks.set(filterId, 0);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val(this.filter);
    }
}

