/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.udp;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableStructure;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryMARW;
import io.questdb.cutlass.line.LineProtoTimestampAdapter;
import io.questdb.cutlass.line.udp.CachedCharSequence;
import io.questdb.cutlass.line.udp.CharSequenceCache;
import io.questdb.cutlass.line.udp.LineUdpParser;
import io.questdb.cutlass.line.udp.LineUdpParserSupport;
import io.questdb.cutlass.line.udp.LineUdpReceiverConfiguration;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class LineUdpParserImpl
implements LineUdpParser,
Closeable {
    private static final Log LOG = LogFactory.getLog(LineUdpParserImpl.class);
    private static final FieldNameParser NOOP_FIELD_NAME = name -> {};
    private static final FieldValueParser NOOP_FIELD_VALUE = (value, cache) -> {};
    private static final LineEndParser NOOP_LINE_END = cache -> {};
    private static final String WRITER_LOCK_REASON = "ilpUdp";
    private final boolean autoCreateNewColumns;
    private final boolean autoCreateNewTables;
    private final CairoSecurityContext cairoSecurityContext;
    private final MicrosecondClock clock;
    private final LongList columnIndexAndType = new LongList();
    private final LongList columnNameType = new LongList();
    private final LongList columnValues = new LongList();
    private final CharSequenceObjHashMap<TableWriter> commitList = new CharSequenceObjHashMap();
    private final CairoConfiguration configuration;
    private final MemoryMARW ddlMem = Vm.getMARWInstance();
    private final short defaultFloatColumnType;
    private final short defaultIntegerColumnType;
    private final CairoEngine engine;
    private final IntList geoHashBitsSizeByColIdx = new IntList();
    private final FieldValueParser MY_NEW_TAG_VALUE = this::parseTagValueNewTable;
    private final Path path = new Path();
    private final TableStructureAdapter tableStructureAdapter = new TableStructureAdapter();
    private final LineProtoTimestampAdapter timestampAdapter;
    private final LineUdpReceiverConfiguration udpConfiguration;
    private final CharSequenceObjHashMap<CacheEntry> writerCache = new CharSequenceObjHashMap();
    private int cacheEntryIndex = 0;
    private int columnIndex;
    private long columnName;
    private int columnType;
    private RecordMetadata metadata;
    private final FieldNameParser MY_FIELD_NAME = this::parseFieldName;
    private FieldNameParser onFieldName;
    private FieldValueParser onFieldValue;
    private LineEndParser onLineEnd;
    private FieldValueParser onTagValue;
    private final FieldNameParser MY_NEW_FIELD_NAME = this::parseFieldNameNewTable;
    private final FieldValueParser MY_NEW_FIELD_VALUE = this::parseFieldValueNewTable;
    private long tableName;
    private TableToken tableToken;
    private TableWriter writer;
    private final LineEndParser MY_LINE_END = this::appendRow;
    private final LineEndParser MY_NEW_LINE_END = this::createTableAndAppendRow;
    private final FieldValueParser MY_TAG_VALUE = this::parseTagValue;
    private final FieldValueParser MY_FIELD_VALUE = this::parseFieldValue;

    public LineUdpParserImpl(CairoEngine engine, LineUdpReceiverConfiguration udpConfiguration) {
        this.configuration = engine.getConfiguration();
        this.clock = this.configuration.getMicrosecondClock();
        this.engine = engine;
        this.udpConfiguration = udpConfiguration;
        this.cairoSecurityContext = udpConfiguration.getCairoSecurityContext();
        this.timestampAdapter = udpConfiguration.getTimestampAdapter();
        this.defaultFloatColumnType = udpConfiguration.getDefaultColumnTypeForFloat();
        this.defaultIntegerColumnType = udpConfiguration.getDefaultColumnTypeForInteger();
        this.autoCreateNewTables = udpConfiguration.getAutoCreateNewTables();
        this.autoCreateNewColumns = udpConfiguration.getAutoCreateNewColumns();
    }

    @Override
    public void close() {
        Misc.free(this.path);
        Misc.free(this.ddlMem);
        int n = this.writerCache.size();
        for (int i = 0; i < n; ++i) {
            Misc.free(this.writerCache.valueQuick(i).writer);
        }
    }

    public void commitAll(int commitMode) {
        if (this.writer != null) {
            this.writer.commit(commitMode);
        }
        int n = this.commitList.size();
        for (int i = 0; i < n; ++i) {
            this.commitList.valueQuick(i).commit(commitMode);
        }
        this.commitList.clear();
    }

    @Override
    public void onError(int position, int state, int code) {
        this.clearState();
    }

    @Override
    public void onEvent(CachedCharSequence token, int eventType, CharSequenceCache cache) {
        switch (eventType) {
            case 1: {
                int wrtIndex = this.writerCache.keyIndex(token);
                if (wrtIndex == this.cacheEntryIndex) {
                    if (this.writer != null) {
                        this.switchModeToAppend();
                        break;
                    }
                    this.initCacheEntry(token, this.writerCache.valueAtQuick(wrtIndex));
                    break;
                }
                this.switchTable(token, wrtIndex);
                break;
            }
            case 4: 
            case 5: {
                this.onFieldName.parse(token);
                break;
            }
            case 2: {
                this.onTagValue.parse(token, cache);
                break;
            }
            case 3: {
                this.onFieldValue.parse(token, cache);
                break;
            }
            case 6: {
                this.columnValues.add(token.getCacheAddress());
                this.geoHashBitsSizeByColIdx.add(0);
                break;
            }
        }
    }

    @Override
    public void onLineEnd(CharSequenceCache cache) {
        try {
            this.onLineEnd.parse(cache);
        }
        catch (CairoException e) {
            LOG.error().$(e).$();
        }
        this.clearState();
    }

    private void appendFirstRowAndCacheWriter(CharSequenceCache cache) {
        TableWriter writer;
        this.writer = writer = this.engine.getWriter(this.cairoSecurityContext, this.tableToken, WRITER_LOCK_REASON);
        this.metadata = writer.getMetadata();
        this.writerCache.valueAtQuick(this.cacheEntryIndex).writer = writer;
        int columnCount = this.columnNameType.size() / 2;
        TableWriter.Row row = this.createNewRow(cache, columnCount);
        if (row == null) {
            return;
        }
        for (int i = 0; i < columnCount; ++i) {
            LineUdpParserSupport.putValue(row, (int)this.columnNameType.getQuick(i * 2 + 1), this.geoHashBitsSizeByColIdx.getQuick(i), i, cache.get(this.columnValues.getQuick(i)));
        }
        row.append();
    }

    private void appendRow(CharSequenceCache cache) {
        int columnCount = this.columnIndexAndType.size();
        TableWriter.Row row = this.createNewRow(cache, columnCount);
        if (row == null) {
            return;
        }
        for (int i = 0; i < columnCount; ++i) {
            long value = this.columnIndexAndType.getQuick(i);
            LineUdpParserSupport.putValue(row, Numbers.decodeHighInt(value), this.geoHashBitsSizeByColIdx.getQuick(i), Numbers.decodeLowInt(value), cache.get(this.columnValues.getQuick(i)));
        }
        row.append();
    }

    private void cacheWriter(CacheEntry entry, CachedCharSequence tableName, TableToken tableToken) {
        try {
            entry.writer = this.engine.getWriter(this.cairoSecurityContext, tableToken, WRITER_LOCK_REASON);
            this.tableToken = tableToken;
            this.tableName = tableName.getCacheAddress();
            this.createState(entry);
            LOG.info().$("cached writer [name=").$(tableName).$(']').$();
        }
        catch (CairoException ex) {
            LOG.error().$(ex).$();
            this.switchModeToSkipLine();
        }
    }

    private void clearState() {
        this.columnNameType.clear();
        this.columnIndexAndType.clear();
        this.geoHashBitsSizeByColIdx.clear();
        this.columnValues.clear();
    }

    private TableWriter.Row createNewRow(CharSequenceCache cache, int columnCount) {
        int valueCount = this.columnValues.size();
        if (columnCount == valueCount) {
            return this.writer.newRow(this.clock.getTicks());
        }
        try {
            return this.writer.newRow(this.timestampAdapter.getMicros(cache.get(this.columnValues.getQuick(valueCount - 1))));
        }
        catch (NumericException e) {
            LOG.error().$("invalid timestamp: ").$(cache.get(this.columnValues.getQuick(valueCount - 1))).$();
            return null;
        }
    }

    private void createState(CacheEntry entry) {
        this.writer = entry.writer;
        this.metadata = this.writer.getMetadata();
        this.switchModeToAppend();
    }

    private void createTableAndAppendRow(CharSequenceCache cache) {
        this.tableToken = this.engine.createTable(this.cairoSecurityContext, this.ddlMem, this.path, true, this.tableStructureAdapter.of(cache), false);
        this.appendFirstRowAndCacheWriter(cache);
    }

    private void initCacheEntry(CachedCharSequence token, CacheEntry entry) {
        TableToken tableToken = this.engine.getTableTokenIfExists(token);
        block0 : switch (entry.state) {
            case 0: {
                int exists = this.engine.getStatus(this.cairoSecurityContext, this.path, tableToken);
                switch (exists) {
                    case 0: {
                        entry.state = 1;
                        this.cacheWriter(entry, token, tableToken);
                        break;
                    }
                    case 1: {
                        if (!this.autoCreateNewTables) {
                            throw CairoException.nonCritical().put("table does not exist, creating new tables is disabled [table=").put(token).put(']');
                        }
                        if (!this.autoCreateNewColumns) {
                            throw CairoException.nonCritical().put("table does not exist, cannot create table, creating new columns is disabled [table=").put(token).put(']');
                        }
                        this.tableName = token.getCacheAddress();
                        if (this.onLineEnd == this.MY_NEW_LINE_END) break block0;
                        this.onLineEnd = this.MY_NEW_LINE_END;
                        this.onFieldName = this.MY_NEW_FIELD_NAME;
                        this.onFieldValue = this.MY_NEW_FIELD_VALUE;
                        this.onTagValue = this.MY_NEW_TAG_VALUE;
                        break;
                    }
                    default: {
                        entry.state = 3;
                        this.switchModeToSkipLine();
                        break;
                    }
                }
                break;
            }
            case 1: {
                this.cacheWriter(entry, token, tableToken);
                break;
            }
            default: {
                this.switchModeToSkipLine();
            }
        }
    }

    private void parseFieldName(CachedCharSequence token) {
        this.columnIndex = this.metadata.getColumnIndexQuiet(token);
        if (this.columnIndex > -1) {
            this.columnType = this.metadata.getColumnType(this.columnIndex);
        }
        if (this.columnIndex < 0 || this.columnType < 0) {
            this.prepareNewColumn(token);
        }
    }

    private void parseFieldNameNewTable(CachedCharSequence token) {
        if (!TableUtils.isValidColumnName(token, this.udpConfiguration.getMaxFileNameLength())) {
            LOG.error().$("invalid column name [columnName=").$(token).I$();
            this.switchModeToSkipLine();
            return;
        }
        this.columnNameType.add(token.getCacheAddress());
    }

    private void parseFieldValue(CachedCharSequence value, CharSequenceCache cache) {
        int valueType = LineUdpParserSupport.getValueType(value, this.defaultFloatColumnType, this.defaultIntegerColumnType);
        if (valueType == 0) {
            this.switchModeToSkipLine();
        } else {
            this.parseValue(value, valueType, cache, true);
        }
    }

    private void parseFieldValueNewTable(CachedCharSequence value, CharSequenceCache cache) {
        int valueType = LineUdpParserSupport.getValueType(value, this.defaultFloatColumnType, this.defaultIntegerColumnType);
        if (valueType == 0 || valueType == 29) {
            this.switchModeToSkipLine();
        } else {
            this.parseValueNewTable(value, valueType);
        }
    }

    private void parseTagValue(CachedCharSequence value, CharSequenceCache cache) {
        this.parseValue(value, 12, cache, false);
    }

    private void parseTagValueNewTable(CachedCharSequence value, CharSequenceCache cache) {
        this.parseValueNewTable(value, 12);
    }

    private void parseValue(CachedCharSequence value, int valueType, CharSequenceCache cache, boolean isForField) {
        assert (valueType > 0);
        if (this.columnType > 0) {
            boolean valid;
            int geoHashBits = 0;
            if (valueType != 29) {
                short valueTypeTag = ColumnType.tagOf(valueType);
                short columnTypeTag = ColumnType.tagOf(this.columnType);
                switch (valueTypeTag) {
                    case 6: {
                        valid = columnTypeTag == 6 || columnTypeTag == 5 || columnTypeTag == 3 || columnTypeTag == 2 || columnTypeTag == 8 || columnTypeTag == 7;
                        break;
                    }
                    case 5: {
                        valid = columnTypeTag == 5 || columnTypeTag == 3 || columnTypeTag == 2;
                        break;
                    }
                    case 3: {
                        valid = columnTypeTag == 3 || columnTypeTag == 2;
                        break;
                    }
                    case 2: {
                        valid = columnTypeTag == 2;
                        break;
                    }
                    case 1: {
                        valid = columnTypeTag == 1;
                        break;
                    }
                    case 11: {
                        valid = columnTypeTag == 11 || columnTypeTag == 4 || isForField && (geoHashBits = ColumnType.getGeoHashBits(this.columnType)) != 0;
                        break;
                    }
                    case 10: {
                        valid = columnTypeTag == 10 || columnTypeTag == 9;
                        break;
                    }
                    case 9: {
                        valid = columnTypeTag == 9;
                        break;
                    }
                    case 12: {
                        valid = columnTypeTag == 12;
                        break;
                    }
                    case 13: {
                        valid = columnTypeTag == 13;
                        break;
                    }
                    case 8: {
                        valid = columnTypeTag == 8;
                        break;
                    }
                    default: {
                        valid = false;
                        break;
                    }
                }
            } else {
                valid = true;
            }
            if (valid) {
                this.columnIndexAndType.add(Numbers.encodeLowHighInts(this.columnIndex, this.columnType));
                this.columnValues.add(value.getCacheAddress());
                this.geoHashBitsSizeByColIdx.add(geoHashBits);
            } else {
                LOG.error().$("mismatched column and value types [table=").utf8(this.writer.getTableToken().getTableName()).$(", column=").$(this.metadata.getColumnName(this.columnIndex)).$(", columnType=").$(ColumnType.nameOf(this.columnType)).$(", valueType=").$(ColumnType.nameOf(valueType)).$(']').$();
                this.switchModeToSkipLine();
            }
        } else {
            CharSequence colNameAsChars = cache.get(this.columnName);
            if (this.autoCreateNewColumns && TableUtils.isValidColumnName(colNameAsChars, this.udpConfiguration.getMaxFileNameLength())) {
                this.writer.addColumn(colNameAsChars, valueType);
                int columnIndex = this.writer.getColumnIndex(colNameAsChars);
                this.columnIndexAndType.add(Numbers.encodeLowHighInts(columnIndex, valueType));
                this.columnValues.add(value.getCacheAddress());
                this.geoHashBitsSizeByColIdx.add(0);
            } else {
                if (!this.autoCreateNewColumns) {
                    throw CairoException.nonCritical().put("column does not exist, creating new columns is disabled [table=").put(this.writer.getTableToken().getTableName()).put(", columnName=").put(colNameAsChars).put(']');
                }
                LOG.error().$("invalid column name [table=").utf8(this.writer.getTableToken().getTableName()).$(", columnName=").$(colNameAsChars).$(']').$();
                this.switchModeToSkipLine();
            }
        }
    }

    private void parseValueNewTable(CachedCharSequence value, int valueType) {
        this.columnNameType.add(valueType);
        this.columnValues.add(value.getCacheAddress());
        this.geoHashBitsSizeByColIdx.add(0);
    }

    private void prepareNewColumn(CachedCharSequence token) {
        this.columnName = token.getCacheAddress();
        this.columnType = 0;
    }

    private void switchModeToAppend() {
        if (this.onLineEnd != this.MY_LINE_END) {
            this.onLineEnd = this.MY_LINE_END;
            this.onFieldName = this.MY_FIELD_NAME;
            this.onFieldValue = this.MY_FIELD_VALUE;
            this.onTagValue = this.MY_TAG_VALUE;
        }
    }

    private void switchModeToSkipLine() {
        if (this.onFieldValue != NOOP_FIELD_VALUE) {
            this.onFieldValue = NOOP_FIELD_VALUE;
            this.onFieldName = NOOP_FIELD_NAME;
            this.onTagValue = NOOP_FIELD_VALUE;
            this.onLineEnd = NOOP_LINE_END;
        }
    }

    private void switchTable(CachedCharSequence tableName, int entryIndex) {
        CacheEntry entry;
        CacheEntry e;
        if (this.cacheEntryIndex != 0 && (e = this.writerCache.valueAtQuick(this.cacheEntryIndex)).writer != null) {
            if (Chars.equals((CharSequence)tableName, (CharSequence)e.writer.getTableToken().getTableName())) {
                this.commitList.put(e.writer.getTableToken().getTableName(), e.writer);
            } else {
                this.commitList.put(Chars.toString(tableName), e.writer);
            }
        }
        if (entryIndex < 0) {
            entry = this.writerCache.valueAtQuick(entryIndex);
        } else {
            entry = new CacheEntry();
            this.writerCache.putAt(entryIndex, Chars.toString(tableName), entry);
            entryIndex = -entryIndex - 1;
        }
        this.cacheEntryIndex = entryIndex;
        if (entry.writer == null) {
            this.initCacheEntry(tableName, entry);
        } else {
            this.createState(entry);
        }
    }

    private class TableStructureAdapter
    implements TableStructure {
        private CharSequenceCache cache;
        private int columnCount;
        private int timestampIndex;

        private TableStructureAdapter() {
        }

        @Override
        public int getColumnCount() {
            return this.columnCount;
        }

        @Override
        public CharSequence getColumnName(int columnIndex) {
            if (columnIndex == this.getTimestampIndex()) {
                return "timestamp";
            }
            CharSequence colName = this.cache.get(LineUdpParserImpl.this.columnNameType.getQuick(columnIndex * 2));
            if (TableUtils.isValidColumnName(colName, LineUdpParserImpl.this.configuration.getMaxFileNameLength())) {
                return colName;
            }
            throw CairoException.nonCritical().put("column name contains invalid characters [colName=").put(colName).put(']');
        }

        @Override
        public int getColumnType(int columnIndex) {
            if (columnIndex == this.getTimestampIndex()) {
                return 8;
            }
            return (int)LineUdpParserImpl.this.columnNameType.getQuick(columnIndex * 2 + 1);
        }

        @Override
        public int getIndexBlockCapacity(int columnIndex) {
            return 0;
        }

        @Override
        public int getMaxUncommittedRows() {
            return LineUdpParserImpl.this.configuration.getMaxUncommittedRows();
        }

        @Override
        public long getO3MaxLag() {
            return LineUdpParserImpl.this.configuration.getO3MaxLag();
        }

        @Override
        public int getPartitionBy() {
            return LineUdpParserImpl.this.udpConfiguration.getDefaultPartitionBy();
        }

        @Override
        public boolean getSymbolCacheFlag(int columnIndex) {
            return LineUdpParserImpl.this.configuration.getDefaultSymbolCacheFlag();
        }

        @Override
        public int getSymbolCapacity(int columnIndex) {
            return LineUdpParserImpl.this.configuration.getDefaultSymbolCapacity();
        }

        @Override
        public CharSequence getTableName() {
            return this.cache.get(LineUdpParserImpl.this.tableName);
        }

        @Override
        public int getTimestampIndex() {
            return this.timestampIndex;
        }

        @Override
        public boolean isIndexed(int columnIndex) {
            return false;
        }

        @Override
        public boolean isSequential(int columnIndex) {
            return false;
        }

        @Override
        public boolean isWalEnabled() {
            return LineUdpParserImpl.this.configuration.getWalEnabledDefault() && PartitionBy.isPartitioned(this.getPartitionBy());
        }

        TableStructureAdapter of(CharSequenceCache cache) {
            this.cache = cache;
            this.timestampIndex = LineUdpParserImpl.this.columnNameType.size() / 2;
            this.columnCount = this.timestampIndex + 1;
            return this;
        }
    }

    private static class CacheEntry {
        private int state = 0;
        private TableWriter writer;

        private CacheEntry() {
        }
    }

    @FunctionalInterface
    private static interface LineEndParser {
        public void parse(CharSequenceCache var1);
    }

    @FunctionalInterface
    private static interface FieldValueParser {
        public void parse(CachedCharSequence var1, CharSequenceCache var2);
    }

    @FunctionalInterface
    private static interface FieldNameParser {
        public void parse(CachedCharSequence var1);
    }
}

