/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.admin.service.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.nifi.action.Action;
import org.apache.nifi.admin.dao.DataAccessException;
import org.apache.nifi.admin.service.AdministrationException;
import org.apache.nifi.admin.service.AuditService;
import org.apache.nifi.admin.service.action.AddActionsAction;
import org.apache.nifi.admin.service.action.DeletePreviousValues;
import org.apache.nifi.admin.service.action.GetActionAction;
import org.apache.nifi.admin.service.action.GetActionsAction;
import org.apache.nifi.admin.service.action.GetPreviousValues;
import org.apache.nifi.admin.service.action.PurgeActionsAction;
import org.apache.nifi.admin.service.transaction.Transaction;
import org.apache.nifi.admin.service.transaction.TransactionBuilder;
import org.apache.nifi.admin.service.transaction.TransactionException;
import org.apache.nifi.history.History;
import org.apache.nifi.history.HistoryQuery;
import org.apache.nifi.history.PreviousValue;

public class StandardAuditService
implements AuditService {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private TransactionBuilder transactionBuilder;

    @Override
    public void addActions(Collection<Action> actions) {
        Transaction transaction = null;
        this.writeLock.lock();
        try {
            transaction = this.transactionBuilder.start();
            AddActionsAction addActions = new AddActionsAction(actions);
            transaction.execute(addActions);
            transaction.commit();
        }
        catch (DataAccessException | TransactionException te) {
            this.rollback(transaction);
            throw new AdministrationException(te);
        }
        catch (Throwable t) {
            this.rollback(transaction);
            throw t;
        }
        finally {
            this.closeQuietly(transaction);
            this.writeLock.unlock();
        }
    }

    @Override
    public Map<String, List<PreviousValue>> getPreviousValues(String componentId) {
        Transaction transaction = null;
        Map<String, List<PreviousValue>> previousValues = null;
        this.readLock.lock();
        try {
            transaction = this.transactionBuilder.start();
            GetPreviousValues getActions = new GetPreviousValues(componentId);
            previousValues = transaction.execute(getActions);
            transaction.commit();
        }
        catch (DataAccessException | TransactionException te) {
            this.rollback(transaction);
            throw new AdministrationException(te);
        }
        catch (Throwable t) {
            this.rollback(transaction);
            throw t;
        }
        finally {
            this.closeQuietly(transaction);
            this.readLock.unlock();
        }
        return previousValues;
    }

    @Override
    public void deletePreviousValues(String propertyName, String componentId) {
        Transaction transaction = null;
        this.readLock.lock();
        try {
            transaction = this.transactionBuilder.start();
            DeletePreviousValues deleteAction = new DeletePreviousValues(propertyName, componentId);
            transaction.execute(deleteAction);
            transaction.commit();
        }
        catch (DataAccessException | TransactionException te) {
            this.rollback(transaction);
            throw new AdministrationException(te);
        }
        catch (Throwable t) {
            this.rollback(transaction);
            throw t;
        }
        finally {
            this.closeQuietly(transaction);
            this.readLock.unlock();
        }
    }

    @Override
    public History getActions(HistoryQuery query) {
        Transaction transaction = null;
        History history = null;
        this.readLock.lock();
        try {
            transaction = this.transactionBuilder.start();
            GetActionsAction getActions = new GetActionsAction(query);
            history = transaction.execute(getActions);
            transaction.commit();
        }
        catch (DataAccessException | TransactionException te) {
            this.rollback(transaction);
            throw new AdministrationException(te);
        }
        catch (Throwable t) {
            this.rollback(transaction);
            throw t;
        }
        finally {
            this.closeQuietly(transaction);
            this.readLock.unlock();
        }
        return history;
    }

    @Override
    public History getActions(int firstActionId, int maxActions) {
        HistoryQuery query = new HistoryQuery();
        query.setOffset(firstActionId);
        query.setCount(maxActions);
        query.setSortOrder("asc");
        query.setSortColumn("timestamp");
        return this.getActions(query);
    }

    @Override
    public Action getAction(Integer actionId) {
        Transaction transaction = null;
        Action action = null;
        this.readLock.lock();
        try {
            transaction = this.transactionBuilder.start();
            GetActionAction getAction = new GetActionAction(actionId);
            action = transaction.execute(getAction);
            transaction.commit();
        }
        catch (DataAccessException | TransactionException te) {
            this.rollback(transaction);
            throw new AdministrationException(te);
        }
        catch (Throwable t) {
            this.rollback(transaction);
            throw t;
        }
        finally {
            this.closeQuietly(transaction);
            this.readLock.unlock();
        }
        return action;
    }

    @Override
    public void purgeActions(Date end, Action purgeAction) {
        Transaction transaction = null;
        this.writeLock.lock();
        try {
            transaction = this.transactionBuilder.start();
            PurgeActionsAction purgeActions = new PurgeActionsAction(end, purgeAction);
            transaction.execute(purgeActions);
            transaction.commit();
        }
        catch (DataAccessException | TransactionException te) {
            this.rollback(transaction);
            throw new AdministrationException(te);
        }
        catch (Throwable t) {
            this.rollback(transaction);
            throw t;
        }
        finally {
            this.closeQuietly(transaction);
            this.writeLock.unlock();
        }
    }

    private void rollback(Transaction transaction) {
        if (transaction != null) {
            transaction.rollback();
        }
    }

    private void closeQuietly(Transaction transaction) {
        if (transaction != null) {
            try {
                transaction.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setTransactionBuilder(TransactionBuilder transactionBuilder) {
        this.transactionBuilder = transactionBuilder;
    }
}

