/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.components;

import java.util.Objects;

public class ValidationResult {
    private final String subject;
    private final String input;
    private final String explanation;
    private final boolean valid;

    protected ValidationResult(Builder builder) {
        this.subject = builder.subject;
        this.input = builder.input;
        this.explanation = builder.explanation;
        this.valid = builder.valid;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getInput() {
        return this.input;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public String getSubject() {
        return this.subject;
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + Objects.hashCode(this.subject);
        hash = 79 * hash + Objects.hashCode(this.input);
        hash = 79 * hash + Objects.hashCode(this.explanation);
        hash = 79 * hash + (this.valid ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidationResult other = (ValidationResult)obj;
        if (!Objects.equals(this.subject, other.subject)) {
            return false;
        }
        if (!Objects.equals(this.input, other.input)) {
            return false;
        }
        if (!Objects.equals(this.explanation, other.explanation)) {
            return false;
        }
        return this.valid == other.valid;
    }

    public String toString() {
        if (this.input == null) {
            return String.format("'%s' is %s because %s", this.subject, this.valid ? "valid" : "invalid", this.explanation);
        }
        return String.format("'%s' validated against '%s' is %s because %s", this.subject, this.input, this.valid ? "valid" : "invalid", this.explanation);
    }

    public static final class Builder {
        private boolean valid = false;
        private String input = null;
        private String explanation = "";
        private String subject = "";

        public Builder valid(boolean valid) {
            this.valid = valid;
            return this;
        }

        public Builder input(String input) {
            if (null != input) {
                this.input = input;
            }
            return this;
        }

        public Builder explanation(String explanation) {
            if (null != explanation) {
                this.explanation = explanation;
            }
            return this;
        }

        public Builder subject(String subject) {
            if (null != subject) {
                this.subject = subject;
            }
            return this;
        }

        public ValidationResult build() {
            return new ValidationResult(this);
        }
    }
}

