/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.repository.encryption.configuration.kms;

import java.util.Arrays;
import org.apache.nifi.repository.encryption.configuration.EncryptedRepositoryType;

enum EncryptedRepositoryProperty {
    CONTENT(EncryptedRepositoryType.CONTENT, "nifi.content.repository.encryption.key.provider.implementation", "nifi.content.repository.encryption.key.provider.location", "nifi.content.repository.encryption.key.provider.password"),
    FLOWFILE(EncryptedRepositoryType.FLOWFILE, "nifi.flowfile.repository.encryption.key.provider.implementation", "nifi.flowfile.repository.encryption.key.provider.location", "nifi.flowfile.repository.encryption.key.provider.password"),
    PROVENANCE(EncryptedRepositoryType.PROVENANCE, "nifi.provenance.repository.encryption.key.provider.implementation", "nifi.provenance.repository.encryption.key.provider.location", "nifi.provenance.repository.encryption.key.provider.password");

    private EncryptedRepositoryType encryptedRepositoryType;
    private String propertyType;
    private String implementationClass;
    private String location;
    private String password;

    private EncryptedRepositoryProperty(EncryptedRepositoryType encryptedRepositoryType, String implementationClass, String location, String password) {
        this.encryptedRepositoryType = encryptedRepositoryType;
        this.propertyType = encryptedRepositoryType.toString().toLowerCase();
        this.implementationClass = implementationClass;
        this.location = location;
        this.password = password;
    }

    public EncryptedRepositoryType getEncryptedRepositoryType() {
        return this.encryptedRepositoryType;
    }

    public String getPropertyType() {
        return this.propertyType;
    }

    public String getImplementationClass() {
        return this.implementationClass;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPassword() {
        return this.password;
    }

    public static EncryptedRepositoryProperty fromEncryptedRepositoryType(EncryptedRepositoryType encryptedRepositoryType) {
        return Arrays.stream(EncryptedRepositoryProperty.values()).filter(value -> value.encryptedRepositoryType == encryptedRepositoryType).findFirst().orElseThrow(() -> new IllegalArgumentException(encryptedRepositoryType.toString()));
    }
}

