/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.SupportsSensitiveDynamicProperties;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ComponentAuthorizable;
import org.apache.nifi.authorization.resource.RestrictedComponentsAuthorizableFactory;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ClassloaderIsolationKeyProvider;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.validation.ValidationState;
import org.apache.nifi.components.validation.ValidationStatus;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.PropertyConfiguration;
import org.apache.nifi.controller.TerminationAwareLogger;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.parameter.ParameterUpdate;
import org.apache.nifi.registry.ComponentVariableRegistry;

public interface ComponentNode
extends ComponentAuthorizable {
    public String getIdentifier();

    public String getName();

    public void setName(String var1);

    public String getAnnotationData();

    public void setAnnotationData(String var1);

    default public void setProperties(Map<String, String> properties) {
        this.setProperties(properties, false, Collections.emptySet());
    }

    public void setProperties(Map<String, String> var1, boolean var2, Set<String> var3);

    public void verifyCanUpdateProperties(Map<String, String> var1);

    public Set<String> getReferencedParameterNames();

    public boolean isReferencingParameter();

    public boolean isReferencingParameter(String var1);

    public void onParametersModified(Map<String, ParameterUpdate> var1);

    public Set<String> getReferencedAttributeNames();

    public void pauseValidationTrigger();

    public void resumeValidationTrigger();

    public Map<PropertyDescriptor, String> getRawPropertyValues();

    public Map<PropertyDescriptor, String> getEffectivePropertyValues();

    public PropertyConfiguration getProperty(PropertyDescriptor var1);

    public String getEffectivePropertyValue(PropertyDescriptor var1);

    public String getRawPropertyValue(PropertyDescriptor var1);

    public Map<PropertyDescriptor, PropertyConfiguration> getProperties();

    public void reload(Set<URL> var1) throws Exception;

    public void refreshProperties();

    public Set<URL> getAdditionalClasspathResources(List<PropertyDescriptor> var1);

    public BundleCoordinate getBundleCoordinate();

    public ConfigurableComponent getComponent();

    public TerminationAwareLogger getLogger();

    public boolean isExtensionMissing();

    public void setExtensionMissing(boolean var1);

    public void verifyCanUpdateBundle(BundleCoordinate var1) throws IllegalStateException;

    public boolean isReloadAdditionalResourcesNecessary();

    public void reloadAdditionalResourcesIfNecessary();

    public void resetValidationState();

    public Collection<ValidationResult> getValidationErrors();

    public String getComponentType();

    public Class<?> getComponentClass();

    public String getCanonicalClassName();

    public boolean isRestricted();

    public boolean isDeprecated();

    public boolean isValidationNecessary();

    default public boolean isSupportsSensitiveDynamicProperties() {
        return this.getComponent().getClass().isAnnotationPresent(SupportsSensitiveDynamicProperties.class);
    }

    public ComponentVariableRegistry getVariableRegistry();

    public ValidationStatus getValidationStatus();

    public ValidationStatus getValidationStatus(long var1, TimeUnit var3);

    public ValidationStatus performValidation();

    public ValidationState performValidation(ValidationContext var1);

    public ValidationState performValidation(Map<PropertyDescriptor, PropertyConfiguration> var1, String var2, ParameterContext var3);

    public List<PropertyDescriptor> getPropertyDescriptors();

    public PropertyDescriptor getPropertyDescriptor(String var1);

    public boolean isSensitiveDynamicProperty(String var1);

    default public AuthorizationResult checkAuthorization(Authorizer authorizer, RequestAction action, NiFiUser user, Map<String, String> resourceContext) {
        if (RequestAction.WRITE.equals((Object)action) && this.isRestricted()) {
            Set restrictedComponentsAuthorizables = RestrictedComponentsAuthorizableFactory.getRestrictedComponentsAuthorizable(this.getComponentClass());
            for (Authorizable restrictedComponentsAuthorizable : restrictedComponentsAuthorizables) {
                AuthorizationResult result = restrictedComponentsAuthorizable.checkAuthorization(authorizer, RequestAction.WRITE, user, resourceContext);
                if (!AuthorizationResult.Result.Denied.equals((Object)result.getResult())) continue;
                return result;
            }
        }
        return super.checkAuthorization(authorizer, action, user, resourceContext);
    }

    default public void authorize(Authorizer authorizer, RequestAction action, NiFiUser user, Map<String, String> resourceContext) throws AccessDeniedException {
        if (RequestAction.WRITE.equals((Object)action) && this.isRestricted()) {
            Set restrictedComponentsAuthorizables = RestrictedComponentsAuthorizableFactory.getRestrictedComponentsAuthorizable(this.getComponentClass());
            for (Authorizable restrictedComponentsAuthorizable : restrictedComponentsAuthorizables) {
                restrictedComponentsAuthorizable.authorize(authorizer, RequestAction.WRITE, user, resourceContext);
            }
        }
        super.authorize(authorizer, action, user, resourceContext);
    }

    public ParameterLookup getParameterLookup();

    default public String getClassLoaderIsolationKey(PropertyContext context) {
        ConfigurableComponent component = this.getComponent();
        if (!(component instanceof ClassloaderIsolationKeyProvider)) {
            return null;
        }
        try {
            return ((ClassloaderIsolationKeyProvider)component).getClassloaderIsolationKey(context);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to determine ClassLoader Isolation Key for " + this + ". This could result in unexpected behavior by this processor.", e);
            return null;
        }
    }
}

