/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization.resource;

import java.util.Objects;
import org.apache.nifi.registry.security.authorization.Resource;
import org.apache.nifi.registry.security.authorization.resource.ResourceType;

public final class ResourceFactory {
    private static final Resource BUCKETS_RESOURCE = new Resource(){

        public String getIdentifier() {
            return ResourceType.Bucket.getValue();
        }

        public String getName() {
            return "Buckets";
        }

        public String getSafeDescription() {
            return "buckets";
        }
    };
    private static final Resource PROXY_RESOURCE = new Resource(){

        public String getIdentifier() {
            return ResourceType.Proxy.getValue();
        }

        public String getName() {
            return "Proxy User Requests";
        }

        public String getSafeDescription() {
            return "proxy requests on behalf of users";
        }
    };
    private static final Resource TENANTS_RESOURCE = new Resource(){

        public String getIdentifier() {
            return ResourceType.Tenant.getValue();
        }

        public String getName() {
            return "Tenants";
        }

        public String getSafeDescription() {
            return "users/user groups";
        }
    };
    private static final Resource POLICIES_RESOURCE = new Resource(){

        public String getIdentifier() {
            return ResourceType.Policy.getValue();
        }

        public String getName() {
            return "Access Policies";
        }

        public String getSafeDescription() {
            return "policies";
        }
    };
    private static final Resource ACTUATOR_RESOURCE = new Resource(){

        public String getIdentifier() {
            return ResourceType.Actuator.getValue();
        }

        public String getName() {
            return "Actuator";
        }

        public String getSafeDescription() {
            return "actuator";
        }
    };
    private static final Resource SWAGGER_RESOURCE = new Resource(){

        public String getIdentifier() {
            return ResourceType.Swagger.getValue();
        }

        public String getName() {
            return "Swagger";
        }

        public String getSafeDescription() {
            return "swagger";
        }
    };

    public static Resource getActuatorResource() {
        return ACTUATOR_RESOURCE;
    }

    public static Resource getSwaggerResource() {
        return SWAGGER_RESOURCE;
    }

    public static Resource getProxyResource() {
        return PROXY_RESOURCE;
    }

    public static Resource getTenantsResource() {
        return TENANTS_RESOURCE;
    }

    public static Resource getPoliciesResource() {
        return POLICIES_RESOURCE;
    }

    public static Resource getBucketsResource() {
        return BUCKETS_RESOURCE;
    }

    public static Resource getBucketResource(String bucketIdentifier, String bucketName) {
        return ResourceFactory.getChildResource(ResourceType.Bucket, bucketIdentifier, bucketName);
    }

    private static Resource getChildResource(final ResourceType parentResourceType, final String childIdentifier, final String name) {
        Objects.requireNonNull(parentResourceType, "The base resource type must be specified.");
        Objects.requireNonNull(childIdentifier, "The child identifier identifier must be specified.");
        return new Resource(){

            public String getIdentifier() {
                return String.format("%s/%s", parentResourceType.getValue(), childIdentifier);
            }

            public String getName() {
                return name;
            }

            public String getSafeDescription() {
                StringBuilder safeDescription = new StringBuilder();
                switch (parentResourceType) {
                    case Bucket: {
                        safeDescription.append("Bucket");
                        break;
                    }
                    default: {
                        safeDescription.append("Unknown resource type");
                    }
                }
                safeDescription.append(" with ID ");
                safeDescription.append(childIdentifier);
                return safeDescription.toString();
            }
        };
    }

    private ResourceFactory() {
    }
}

