/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.implementation;

import com.azure.security.keyvault.keys.models.DeletedKey;
import com.azure.security.keyvault.keys.models.JsonWebKey;
import java.time.OffsetDateTime;

public final class DeletedKeyHelper {
    private static DeletedKeyAccessor accessor;

    public static DeletedKey createDeletedKey(JsonWebKey jsonWebKey) {
        if (accessor == null) {
            new DeletedKey();
        }
        assert (accessor != null);
        return accessor.createDeletedKey(jsonWebKey);
    }

    public static void setRecoveryId(DeletedKey deletedKey, String recoveryId) {
        accessor.setRecoveryId(deletedKey, recoveryId);
    }

    public static void setScheduledPurgeDate(DeletedKey deletedKey, OffsetDateTime scheduledPurgeDate) {
        accessor.setScheduledPurgeDate(deletedKey, scheduledPurgeDate);
    }

    public static void setDeletedOn(DeletedKey deletedKey, OffsetDateTime deletedOn) {
        accessor.setDeletedOn(deletedKey, deletedOn);
    }

    public static void setAccessor(DeletedKeyAccessor accessor) {
        DeletedKeyHelper.accessor = accessor;
    }

    private DeletedKeyHelper() {
    }

    public static interface DeletedKeyAccessor {
        public DeletedKey createDeletedKey(JsonWebKey var1);

        public void setRecoveryId(DeletedKey var1, String var2);

        public void setScheduledPurgeDate(DeletedKey var1, OffsetDateTime var2);

        public void setDeletedOn(DeletedKey var1, OffsetDateTime var2);
    }
}

