/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics.bootstrap.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.diagnostics.DiagnosticTask;
import org.apache.nifi.diagnostics.DiagnosticsDumpElement;
import org.apache.nifi.diagnostics.StandardDiagnosticsDumpElement;
import org.apache.nifi.groups.ProcessGroup;

public class ComponentCountTask
implements DiagnosticTask {
    private final FlowController flowController;

    public ComponentCountTask(FlowController flowController) {
        this.flowController = flowController;
    }

    public DiagnosticsDumpElement captureDump(boolean verbose) {
        ArrayList<String> details = new ArrayList<String>();
        ProcessGroup processGroup = this.flowController.getFlowManager().getRootGroup();
        details.add("Processors:");
        this.countProcessors(processGroup.findAllProcessors(), details);
        details.add("\n\nController Services:");
        this.countControllerServices(processGroup.findAllControllerServices(), details);
        return new StandardDiagnosticsDumpElement("Component Counts", details);
    }

    private void countProcessors(Collection<ProcessorNode> processors, List<String> details) {
        HashMap<String, Map> typeMap = new HashMap<String, Map>();
        for (ProcessorNode processorNode : processors) {
            String componentType = processorNode.getComponentType();
            ScheduledState scheduledState = processorNode.getScheduledState();
            Map stateCounts = typeMap.computeIfAbsent(componentType, key -> new HashMap());
            Integer count = stateCounts.computeIfAbsent(scheduledState, key -> 0);
            stateCounts.put(scheduledState, count + 1);
        }
        for (Map.Entry entry : typeMap.entrySet()) {
            String type = (String)entry.getKey();
            Map stateMap = (Map)entry.getValue();
            int total = stateMap.values().stream().mapToInt(Integer::intValue).sum();
            details.add(type + " : " + total + " Total, " + stateMap.toString().toLowerCase());
        }
        if (typeMap.isEmpty()) {
            details.add("No Processors");
        }
    }

    private void countControllerServices(Collection<ControllerServiceNode> services, List<String> details) {
        HashMap<String, Map> typeMap = new HashMap<String, Map>();
        for (ControllerServiceNode controllerServiceNode : services) {
            String componentType = controllerServiceNode.getComponentType();
            ControllerServiceState serviceState = controllerServiceNode.getState();
            Map stateCounts = typeMap.computeIfAbsent(componentType, key -> new HashMap());
            Integer count = stateCounts.computeIfAbsent(serviceState, key -> 0);
            stateCounts.put(serviceState, count + 1);
        }
        for (Map.Entry entry : typeMap.entrySet()) {
            String type = (String)entry.getKey();
            Map stateMap = (Map)entry.getValue();
            int total = stateMap.values().stream().mapToInt(Integer::intValue).sum();
            details.add(type + " : " + total + " total, " + stateMap.toString().toLowerCase());
        }
        if (typeMap.isEmpty()) {
            details.add("No Controller Services");
        }
    }
}

