/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.metrics;

import io.questdb.metrics.CounterWithTwoLabels;
import io.questdb.metrics.PrometheusFormatUtils;
import io.questdb.std.Numbers;
import io.questdb.std.str.CharSink;
import java.util.concurrent.atomic.LongAdder;

public class CounterWithTwoLabelsImpl
implements CounterWithTwoLabels {
    private final LongAdder[] counters;
    private final CharSequence labelName0;
    private final CharSequence labelName1;
    private final CharSequence[] labelValues0;
    private final CharSequence[] labelValues1;
    private final CharSequence name;
    private final int shl;

    CounterWithTwoLabelsImpl(CharSequence name, CharSequence labelName0, CharSequence[] labelValues0, CharSequence labelName1, CharSequence[] labelValues1) {
        this.name = name;
        this.labelName0 = labelName0;
        this.labelName1 = labelName1;
        this.labelValues0 = labelValues0;
        this.labelValues1 = labelValues1;
        int labelValues0Capacity = Numbers.ceilPow2(labelValues0.length);
        this.shl = Numbers.msb(labelValues0Capacity);
        this.counters = new LongAdder[labelValues0Capacity * labelValues1.length];
        int n = labelValues0.length;
        for (int i = 0; i < n; ++i) {
            int k = labelValues1.length;
            for (int j = 0; j < k; ++j) {
                this.counters[(i << this.shl) + j] = new LongAdder();
            }
        }
    }

    @Override
    public void inc(short label0, short label1) {
        this.counters[(label0 << this.shl) + label1].increment();
    }

    @Override
    public void scrapeIntoPrometheus(CharSink sink) {
        PrometheusFormatUtils.appendCounterType(this.name, sink);
        int n = this.labelValues0.length;
        for (int i = 0; i < n; ++i) {
            int k = this.labelValues1.length;
            for (int j = 0; j < k; ++j) {
                PrometheusFormatUtils.appendCounterNamePrefix(this.name, sink);
                sink.put('{');
                PrometheusFormatUtils.appendLabel(sink, this.labelName0, this.labelValues0[i]);
                sink.put(',');
                PrometheusFormatUtils.appendLabel(sink, this.labelName1, this.labelValues1[j]);
                sink.put('}');
                PrometheusFormatUtils.appendSampleLineSuffix(sink, this.counters[(i << this.shl) + j].longValue());
            }
        }
        PrometheusFormatUtils.appendNewLine(sink);
    }
}

