/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.lt;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.std.IntList;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.ObjList;

public class LtLong256FunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "<(HH)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.getQuick(0), args.getQuick(1));
    }

    private static class Func
    extends NegatableBooleanFunction
    implements BinaryFunction {
        private final Function left;
        private final Function right;

        public Func(Function left, Function right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean getBool(Record rec) {
            Long256 lv = this.left.getLong256A(rec);
            Long256 rv = this.right.getLong256B(rec);
            if (lv.equals(Long256Impl.NULL_LONG256) || rv.equals(Long256Impl.NULL_LONG256)) {
                return false;
            }
            if (lv.getLong3() != rv.getLong3()) {
                return this.negated == Long.compareUnsigned(lv.getLong3(), rv.getLong3()) >= 0;
            }
            if (lv.getLong2() != rv.getLong2()) {
                return this.negated == Long.compareUnsigned(lv.getLong2(), rv.getLong2()) >= 0;
            }
            if (lv.getLong1() != rv.getLong1()) {
                return this.negated == Long.compareUnsigned(lv.getLong1(), rv.getLong1()) >= 0;
            }
            return this.negated == Long.compareUnsigned(lv.getLong0(), rv.getLong0()) >= 0;
        }

        @Override
        public Function getLeft() {
            return this.left;
        }

        @Override
        public Function getRight() {
            return this.right;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.left);
            if (this.negated) {
                sink.val(">=");
            } else {
                sink.val('<');
            }
            sink.val(this.right);
        }
    }
}

