/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.iterate.EntityAddedOrDeletedHandleChecker;
import jetbrains.exodus.entitystore.iterate.IdFilter;
import jetbrains.exodus.entitystore.iterate.InitialIdFilter;
import jetbrains.exodus.entitystore.iterate.LinkChangedHandleChecker;
import jetbrains.exodus.entitystore.iterate.PropertyChangedHandleChecker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EntityIterableHandleBase
implements EntityIterableHandle {
    private static final int HASH_LONGS_COUNT = 4;
    @Nullable
    private final PersistentEntityStore store;
    @NotNull
    private final EntityIterableType type;
    @Nullable
    private EntityIterableHandleHash hash;
    @NotNull
    private IdFilter linksFilter;

    protected EntityIterableHandleBase(@Nullable PersistentEntityStore store, @NotNull EntityIterableType type) {
        this.store = store;
        this.type = type;
        this.hash = null;
        this.linksFilter = new InitialIdFilter(){

            @Override
            int[] getIds() {
                return EntityIterableHandleBase.this.getLinkIds();
            }

            @Override
            void setFinalIdFilter(@NotNull IdFilter filter) {
                EntityIterableHandleBase.this.linksFilter = filter;
            }
        };
    }

    @Override
    @NotNull
    public EntityIterableType getType() {
        return this.type;
    }

    @Override
    public final boolean hasLinkId(int id) {
        return this.linksFilter.hasId(id);
    }

    @Nullable
    public PersistentEntityStore getStore() {
        return this.store;
    }

    @Override
    public int getEntityTypeId() {
        return Integer.MIN_VALUE;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EntityIterableHandle)) {
            return false;
        }
        EntityIterableHandle that = (EntityIterableHandle)obj;
        return this.getIdentity().equals(that.getIdentity());
    }

    public final int hashCode() {
        return this.getIdentity().hashCode();
    }

    @Override
    @NotNull
    public final Object getIdentity() {
        if (this.hash == null) {
            this.hash = this.computeHash();
        }
        return this.hash;
    }

    @Override
    public boolean isSticky() {
        return false;
    }

    @Override
    public boolean isMatchedEntityAdded(@NotNull EntityId added) {
        return true;
    }

    @Override
    public boolean isMatchedEntityDeleted(@NotNull EntityId deleted) {
        return true;
    }

    @Override
    public boolean isMatchedPropertyChanged(@NotNull EntityId id, int propertyId, @Nullable Comparable oldValue, @Nullable Comparable newValue) {
        return true;
    }

    @Override
    public boolean onEntityAdded(@NotNull EntityAddedOrDeletedHandleChecker handleChecker) {
        return false;
    }

    @Override
    public boolean onEntityDeleted(@NotNull EntityAddedOrDeletedHandleChecker handleChecker) {
        return false;
    }

    @Override
    public boolean onLinkAdded(@NotNull LinkChangedHandleChecker handleChecker) {
        return false;
    }

    @Override
    public boolean onLinkDeleted(@NotNull LinkChangedHandleChecker handleChecker) {
        return false;
    }

    @Override
    public boolean onPropertyChanged(@NotNull PropertyChangedHandleChecker handleChecker) {
        return false;
    }

    @Override
    @NotNull
    public int[] getLinkIds() {
        return IdFilter.EMPTY_ID_ARRAY;
    }

    @Override
    @NotNull
    public int[] getPropertyIds() {
        return IdFilter.EMPTY_ID_ARRAY;
    }

    @Override
    @NotNull
    public int[] getTypeIdsAffectingCreation() {
        return IdFilter.EMPTY_ID_ARRAY;
    }

    @Override
    public boolean isConsistent() {
        return true;
    }

    @Override
    public void resetBirthTime() {
    }

    @Override
    public boolean isExpired() {
        return false;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }

    public void toString(@NotNull StringBuilder builder) {
        builder.append(this.type.getType());
        if (this.type != EntityIterableType.EMPTY) {
            builder.append('-');
        }
    }

    public abstract void hashCode(@NotNull EntityIterableHandleHash var1);

    private EntityIterableHandleHash computeHash() {
        EntityIterableHandleHash result = new EntityIterableHandleHash(this.store);
        result.apply(this.type.getType());
        if (this.type != EntityIterableType.EMPTY) {
            result.applyDelimiter();
        }
        this.hashCode(result);
        result.computeHashCode();
        return result;
    }

    @NotNull
    protected static int[] mergeFieldIds(@NotNull int[] left, @NotNull int[] right) {
        int l = left.length;
        if (l == 0) {
            return right;
        }
        int r = right.length;
        if (r == 0) {
            return left;
        }
        int mergedLength = EntityIterableHandleBase.getMergedLength(left, right, l, r);
        if (mergedLength == l) {
            return left;
        }
        if (mergedLength == r) {
            return right;
        }
        return EntityIterableHandleBase.merge(left, right, l, r, new int[mergedLength]);
    }

    private static int getMergedLength(int[] left, int[] right, int l, int r) {
        int k;
        block5: {
            int i = 0;
            int j = 0;
            k = 0;
            while (true) {
                int b;
                int a;
                if ((a = left[i]) <= (b = right[j])) {
                    ++k;
                    if (++i >= l) {
                        if (a == b) {
                            ++j;
                        }
                        k += r - j;
                        break block5;
                    }
                    if (a != b) continue;
                    ++j;
                } else {
                    ++j;
                    ++k;
                }
                if (j >= r) break;
            }
            k += l - i;
        }
        return k;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int[] merge(int[] left, int[] right, int l, int r, int[] result) {
        int i = 0;
        int j = 0;
        int k = 0;
        int a = left[0];
        int b = right[0];
        while (true) {
            block7: {
                block6: {
                    if (a > b) break block6;
                    result[k++] = a;
                    if (++i < l) {
                        boolean neq = a != b;
                        a = left[i];
                        if (neq) continue;
                        ++j;
                        break block7;
                    } else {
                        if (a == b) {
                            ++j;
                        }
                        while (j < r) {
                            result[k++] = right[j++];
                        }
                        return result;
                    }
                }
                ++j;
                result[k++] = b;
            }
            if (j >= r) break;
            b = right[j];
        }
        while (i < l) {
            result[k++] = left[i++];
        }
        return result;
    }

    public static final class EntityIterableHandleHash {
        private static final String UTF_8 = "UTF-8";
        private static final byte[][] INTS = new byte[1024][];
        @NotNull
        private final long[] hashLongs = new long[4];
        private int bytesProcessed;
        private int hashCode;

        public EntityIterableHandleHash(@Nullable PersistentEntityStore store) {
            this.hashCode = store == null ? 0 : System.identityHashCode(store);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            EntityIterableHandleHash rightHash = (EntityIterableHandleHash)obj;
            return this == rightHash || this.hashCode == rightHash.hashCode && Arrays.equals(this.hashLongs, rightHash.hashLongs);
        }

        public void apply(byte b) {
            int bytesProcessed = this.bytesProcessed;
            if (bytesProcessed < 32) {
                int n = bytesProcessed >> 3 & 3;
                this.hashLongs[n] = this.hashLongs[n] + ((long)(b & 0xFF) << ((bytesProcessed & 7) << 3));
            } else {
                int index2 = bytesProcessed & 3;
                long hashValue = this.hashLongs[index2];
                this.hashLongs[index2] = (hashValue << 5) - hashValue + (long)(b & 0xFF);
            }
            this.bytesProcessed = bytesProcessed + 1;
        }

        public void apply(byte[] bytes) {
            for (byte b : bytes) {
                this.apply(b);
            }
        }

        public void apply(int i) {
            if (i >= 0 && i < INTS.length) {
                this.apply(INTS[i]);
            } else {
                this.apply(Integer.toString(i));
            }
        }

        public void apply(long l) {
            if (l >= 0L && l < (long)INTS.length) {
                this.apply(INTS[(int)l]);
            } else {
                this.apply(Long.toString(l));
            }
        }

        public void apply(@NotNull String s) {
            try {
                for (byte b : s.getBytes(UTF_8)) {
                    this.apply(b);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw ExodusException.toExodusException((Throwable)e);
            }
        }

        public void apply(@NotNull EntityIterableHandle source) {
            this.apply((EntityIterableHandleHash)source.getIdentity());
        }

        public void apply(@NotNull EntityIterableHandleHash sourceHash) {
            sourceHash.forEachByte(this::apply);
        }

        public void applyDelimiter() {
            this.apply((byte)45);
        }

        public String toString() {
            int hashBytes = Math.min(this.bytesProcessed, 32);
            StringBuilder builder = new StringBuilder(hashBytes);
            this.forEachByte(b -> builder.append((char)b));
            return builder.toString();
        }

        public void computeHashCode() {
            long result = 314159265358L;
            for (long hl : this.hashLongs) {
                result += hl;
            }
            this.hashCode += (int)result;
            this.hashCode += (int)(result >>> 32);
        }

        private void forEachByte(@NotNull ByteConsumer consumer) {
            int hashBytes = Math.min(this.bytesProcessed, 32);
            long hashLong = 0L;
            for (int i = 0; i < hashBytes; ++i) {
                if ((i & 7) == 0) {
                    hashLong = this.hashLongs[i >> 3];
                }
                consumer.accept((byte)(hashLong & 0xFFL));
                hashLong >>= 8;
            }
        }

        static {
            try {
                for (int i = 0; i < INTS.length; ++i) {
                    EntityIterableHandleHash.INTS[i] = Integer.toString(i).getBytes(UTF_8);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw ExodusException.toExodusException((Throwable)e);
            }
        }

        private static interface ByteConsumer {
            public void accept(byte var1);
        }
    }
}

