/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.c2.cache.filesystem;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.nifi.minifi.c2.api.ConfigurationProviderException;
import org.apache.nifi.minifi.c2.api.InvalidParameterException;
import org.apache.nifi.minifi.c2.api.cache.ConfigurationCacheFileInfo;
import org.apache.nifi.minifi.c2.api.cache.WriteableConfiguration;
import org.apache.nifi.minifi.c2.api.util.Pair;
import org.apache.nifi.minifi.c2.cache.filesystem.FileSystemConfigurationCache;
import org.apache.nifi.minifi.c2.cache.filesystem.FileSystemWritableConfiguration;

public class FileSystemCacheFileInfoImpl
implements ConfigurationCacheFileInfo {
    private final FileSystemConfigurationCache cache;
    private final Path dirPath;
    private final String expectedFilename;
    private final int expectedFilenameLength;

    public FileSystemCacheFileInfoImpl(FileSystemConfigurationCache cache, Path dirPath, String expectedFilename) {
        this.cache = cache;
        this.dirPath = dirPath;
        this.expectedFilename = expectedFilename;
        this.expectedFilenameLength = expectedFilename.length();
    }

    public Integer getVersionIfMatch(String filename) {
        if (!filename.startsWith(this.expectedFilename) || filename.length() == this.expectedFilenameLength) {
            return null;
        }
        try {
            return Integer.parseInt(filename.substring(this.expectedFilenameLength));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Stream<WriteableConfiguration> getCachedConfigurations() throws IOException {
        return Files.list(this.dirPath).map(p -> {
            Integer version = this.getVersionIfMatch(p.getFileName().toString());
            if (version == null) {
                return null;
            }
            return new Pair((Object)version, p);
        }).filter(Objects::nonNull).sorted(Comparator.comparing(pair -> (Integer)((Pair)pair).getFirst()).reversed()).map(pair -> new FileSystemWritableConfiguration(this.cache, (Path)pair.getSecond(), Integer.toString((Integer)pair.getFirst())));
    }

    public WriteableConfiguration getConfiguration(Integer version) throws ConfigurationProviderException {
        if (version == null) {
            try {
                return this.getCachedConfigurations().findFirst().orElseThrow(() -> new ConfigurationProviderException("No configurations found for " + this.dirPath + "/" + this.expectedFilename + "[0-9]+"));
            }
            catch (IOException e) {
                throw new ConfigurationProviderException("Unable to get cached configurations.", (Throwable)e);
            }
        }
        try {
            return new FileSystemWritableConfiguration(this.cache, this.cache.resolveChildAndVerifyParent(this.dirPath, this.expectedFilename + version), Integer.toString(version));
        }
        catch (NumberFormatException e) {
            throw new InvalidParameterException("Expected numeric version.", (Throwable)e);
        }
    }
}

