/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.network.AbstractIODispatcher;
import io.questdb.network.IOContext;
import io.questdb.network.IOContextFactory;
import io.questdb.network.IODispatcherConfiguration;
import io.questdb.network.IOEvent;
import io.questdb.network.Kqueue;
import io.questdb.network.KqueueAccessor;
import io.questdb.network.NetworkError;
import io.questdb.network.SuspendEvent;
import io.questdb.std.LongMatrix;

public class IODispatcherOsx<C extends IOContext>
extends AbstractIODispatcher<C> {
    private static final int EVM_DEADLINE = 1;
    private static final int EVM_ID = 0;
    private static final int EVM_OPERATION_ID = 2;
    private static final int OPM_ID = 3;
    protected final LongMatrix pendingEvents = new LongMatrix(3);
    private final int capacity;
    private final Kqueue kqueue;
    private long idSeq = 1L;

    public IODispatcherOsx(IODispatcherConfiguration configuration, IOContextFactory<C> ioContextFactory) {
        super(configuration, ioContextFactory);
        this.capacity = configuration.getEventCapacity();
        this.kqueue = new Kqueue(configuration.getKqueueFacade(), this.capacity);
        this.registerListenerFd();
    }

    @Override
    public void close() {
        super.close();
        this.kqueue.close();
        this.LOG.info().$("closed").$();
    }

    private static boolean isEventId(long id) {
        return (id & 1L) == 1L;
    }

    private void doDisconnect(C context, long id, int reason) {
        SuspendEvent suspendEvent = context.getSuspendEvent();
        if (suspendEvent != null) {
            int eventRow = this.pendingEvents.binarySearch(id, 2);
            if (eventRow < 0) {
                this.LOG.critical().$("internal error: suspend event not found [id=").$(id).I$();
            } else {
                this.kqueue.setWriteOffset(0);
                this.kqueue.removeFD(suspendEvent.getFd());
                this.registerWithKQueue(1);
                this.pendingEvents.deleteRow(eventRow);
            }
        }
        this.doDisconnect(context, reason);
    }

    private void enqueuePending(int watermark) {
        int index = 0;
        int i = watermark;
        int sz = this.pending.size();
        int offset = 0;
        while (i < sz) {
            int operation;
            this.kqueue.setWriteOffset(offset);
            int fd = (int)this.pending.get(i, 1);
            int n = operation = this.initialBias == 1 ? 1 : 4;
            if (operation == 1) {
                this.kqueue.readFD(fd, this.pending.get(i, 3));
            } else {
                this.kqueue.writeFD(fd, this.pending.get(i, 3));
            }
            if (++index > this.capacity - 1) {
                this.registerWithKQueue(index);
                index = 0;
                offset = 0;
            }
            ++i;
            offset += KqueueAccessor.SIZEOF_KEVENT;
        }
        if (index > 0) {
            this.registerWithKQueue(index);
        }
    }

    private boolean handleSocketOperation(long id) {
        int row = this.pending.binarySearch(id, 3);
        if (row < 0) {
            this.LOG.critical().$("internal error: kqueue returned unexpected id [id=").$(id).I$();
            return false;
        }
        IOContext context = (IOContext)this.pending.get(row);
        SuspendEvent suspendEvent = context.getSuspendEvent();
        if (suspendEvent != null) {
            if (this.testConnection(context.getFd())) {
                this.doDisconnect(context, id, 3);
                this.pending.deleteRow(row);
                return true;
            }
        } else {
            this.publishOperation(this.kqueue.getFilter() == KqueueAccessor.EVFILT_READ ? 1 : 4, context);
            this.pending.deleteRow(row);
            return true;
        }
        return false;
    }

    private void handleSuspendEvent(long id) {
        int eventsRow = this.pendingEvents.binarySearch(id, 0);
        if (eventsRow < 0) {
            this.LOG.critical().$("internal error: kqueue returned unexpected event id [eventId=").$(id).I$();
            return;
        }
        long opId = this.pendingEvents.get(eventsRow, 2);
        int row = this.pending.binarySearch(opId, 3);
        if (row < 0) {
            this.LOG.critical().$("internal error: suspended operation not found [id=").$(opId).$(", eventId=").$(id).I$();
            return;
        }
        long eventId = this.pendingEvents.get(eventsRow, 0);
        int operation = (int)this.pending.get(row, 2);
        IOContext context = (IOContext)this.pending.get(row);
        SuspendEvent suspendEvent = context.getSuspendEvent();
        assert (suspendEvent != null);
        this.LOG.debug().$("handling triggered suspend event and resuming original operation [fd=").$(context.getFd()).$(", opId=").$(opId).$(", eventId=").$(eventId).I$();
        context.clearSuspendEvent();
        this.kqueue.setWriteOffset(0);
        if (operation == 1) {
            this.kqueue.readFD(context.getFd(), opId);
        } else {
            this.kqueue.writeFD(context.getFd(), opId);
        }
        this.registerWithKQueue(1);
        this.pendingEvents.deleteRow(eventsRow);
    }

    private long nextEventId() {
        return (this.idSeq++ << 1) + 1L;
    }

    private long nextOpId() {
        return this.idSeq++ << 1;
    }

    private void processIdleConnections(long deadline) {
        int count = 0;
        int i = 0;
        int n = this.pending.size();
        while (i < n && this.pending.get(i, 0) < deadline) {
            this.doDisconnect((IOContext)this.pending.get(i), this.pending.get(i, 3), 1);
            ++i;
            ++count;
        }
        this.pending.zapTop(count);
    }

    private boolean processRegistrations(long timestamp) {
        long cursor;
        boolean useful = false;
        int count = 0;
        int offset = 0;
        while ((cursor = this.interestSubSeq.next()) > -1L) {
            IOEvent evt = (IOEvent)this.interestQueue.get(cursor);
            Object context = evt.context;
            int requestedOperation = evt.operation;
            this.interestSubSeq.done(cursor);
            useful = true;
            long opId = this.nextOpId();
            int fd = context.getFd();
            int operation = requestedOperation;
            this.LOG.debug().$("processing registration [fd=").$(fd).$(", op=").$(operation).$(", id=").$(opId).I$();
            SuspendEvent suspendEvent = context.getSuspendEvent();
            if (suspendEvent != null) {
                operation = 1;
            }
            int opRow = this.pending.addRow();
            this.pending.set(opRow, 0, timestamp);
            this.pending.set(opRow, 1, fd);
            this.pending.set(opRow, 3, opId);
            this.pending.set(opRow, 2, requestedOperation);
            this.pending.set(opRow, context);
            this.kqueue.setWriteOffset(offset);
            if (operation == 1) {
                this.kqueue.readFD(fd, opId);
            } else {
                this.kqueue.writeFD(fd, opId);
            }
            offset += KqueueAccessor.SIZEOF_KEVENT;
            if (++count > this.capacity - 1) {
                this.registerWithKQueue(count);
                offset = 0;
                count = 0;
            }
            if (suspendEvent == null) continue;
            long eventId = this.nextEventId();
            this.LOG.debug().$("registering suspend event [fd=").$(fd).$(", op=").$(operation).$(", eventId=").$(eventId).$(", suspendedOpId=").$(opId).$(", deadline=").$(suspendEvent.getDeadline()).I$();
            int eventRow = this.pendingEvents.addRow();
            this.pendingEvents.set(eventRow, 0, eventId);
            this.pendingEvents.set(eventRow, 2, opId);
            this.pendingEvents.set(eventRow, 1, suspendEvent.getDeadline());
            this.kqueue.setWriteOffset(offset);
            this.kqueue.readFD(suspendEvent.getFd(), eventId);
            offset += KqueueAccessor.SIZEOF_KEVENT;
            if (++count <= this.capacity - 1) continue;
            this.registerWithKQueue(count);
            offset = 0;
            count = 0;
        }
        if (count > 0) {
            this.registerWithKQueue(count);
        }
        return useful;
    }

    private void processSuspendEventDeadlines(long timestamp) {
        int index = 0;
        int offset = 0;
        int count = 0;
        int i = 0;
        int n = this.pendingEvents.size();
        while (i < n && this.pendingEvents.get(i, 1) < timestamp) {
            long opId = this.pendingEvents.get(i, 2);
            int pendingRow = this.pending.binarySearch(opId, 3);
            if (pendingRow < 0) {
                this.LOG.critical().$("internal error: failed to find operation for expired suspend event [id=").$(opId).I$();
            } else {
                IOContext context = (IOContext)this.pending.get(pendingRow);
                int operation = (int)this.pending.get(pendingRow, 2);
                SuspendEvent suspendEvent = context.getSuspendEvent();
                assert (suspendEvent != null);
                this.kqueue.setWriteOffset(offset);
                this.kqueue.removeFD(suspendEvent.getFd());
                offset += KqueueAccessor.SIZEOF_KEVENT;
                if (++index > this.capacity - 1) {
                    this.registerWithKQueue(index);
                    offset = 0;
                    index = 0;
                }
                context.clearSuspendEvent();
                this.kqueue.setWriteOffset(offset);
                if (operation == 1) {
                    this.kqueue.readFD(context.getFd(), opId);
                } else {
                    this.kqueue.writeFD(context.getFd(), opId);
                }
                offset += KqueueAccessor.SIZEOF_KEVENT;
                if (++index > this.capacity - 1) {
                    this.registerWithKQueue(index);
                    offset = 0;
                    index = 0;
                }
            }
            ++i;
            ++count;
        }
        if (index > 0) {
            this.registerWithKQueue(index);
        }
        this.pendingEvents.zapTop(count);
    }

    private void registerWithKQueue(int changeCount) {
        if (this.kqueue.register(changeCount) != 0) {
            throw NetworkError.instance(this.nf.errno()).put("could not register [changeCount=").put(changeCount).put(']');
        }
        this.LOG.debug().$("kqueued [count=").$(changeCount).$(']').$();
    }

    @Override
    protected void pendingAdded(int index) {
        this.pending.set(index, 3, this.nextOpId());
    }

    @Override
    protected void registerListenerFd() {
        if (this.kqueue.listen(this.serverFd) != 0) {
            throw NetworkError.instance(this.nf.errno(), "could not kqueue.listen()");
        }
    }

    @Override
    protected boolean runSerially() {
        boolean useful = false;
        long timestamp = this.clock.getTicks();
        this.processDisconnects(timestamp);
        int n = this.kqueue.poll();
        int watermark = this.pending.size();
        int offset = 0;
        if (n > 0) {
            this.LOG.debug().$("poll [n=").$(n).$(']').$();
            for (int i = 0; i < n; ++i) {
                this.kqueue.setReadOffset(offset);
                offset += KqueueAccessor.SIZEOF_KEVENT;
                int fd = this.kqueue.getFd();
                long id = this.kqueue.getData();
                if (fd == this.serverFd) {
                    this.accept(timestamp);
                    useful = true;
                    continue;
                }
                if (IODispatcherOsx.isEventId(id)) {
                    this.handleSuspendEvent(id);
                    continue;
                }
                if (!this.handleSocketOperation(id)) continue;
                useful = true;
                --watermark;
            }
        }
        if (watermark < this.pending.size()) {
            this.enqueuePending(watermark);
        }
        if (this.pendingEvents.size() > 0 && this.pendingEvents.get(0, 1) < timestamp) {
            this.processSuspendEventDeadlines(timestamp);
        }
        long deadline = timestamp - this.idleConnectionTimeout;
        if (this.pending.size() > 0 && this.pending.get(0, 0) < deadline) {
            this.processIdleConnections(deadline);
            useful = true;
        }
        return this.processRegistrations(timestamp) || useful;
    }

    @Override
    protected void unregisterListenerFd() {
        if (this.kqueue.removeListen(this.serverFd) != 0) {
            throw NetworkError.instance(this.nf.errno(), "could not kqueue.removeListen()");
        }
    }
}

