/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.groupby.CountGeoHashGroupByFunctionByte;
import io.questdb.griffin.engine.functions.groupby.CountGeoHashGroupByFunctionInt;
import io.questdb.griffin.engine.functions.groupby.CountGeoHashGroupByFunctionLong;
import io.questdb.griffin.engine.functions.groupby.CountGeoHashGroupByFunctionShort;
import io.questdb.griffin.engine.functions.groupby.CountLongConstGroupByFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class CountGeoHashGroupByFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "count(G)";
    }

    @Override
    public boolean isGroupBy() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function arg = args.getQuick(0);
        int type = arg.getType();
        if (arg.isConstant()) {
            if (this.value(arg) == -1L) {
                throw SqlException.$(argPositions.getQuick(0), "NULL is not allowed");
            }
            return new CountLongConstGroupByFunction();
        }
        switch (ColumnType.tagOf(type)) {
            case 14: {
                return new CountGeoHashGroupByFunctionByte(arg);
            }
            case 15: {
                return new CountGeoHashGroupByFunctionShort(arg);
            }
            case 16: {
                return new CountGeoHashGroupByFunctionInt(arg);
            }
        }
        return new CountGeoHashGroupByFunctionLong(arg);
    }

    private long value(Function arg) {
        switch (ColumnType.tagOf(arg.getType())) {
            case 14: {
                return arg.getGeoByte(null);
            }
            case 15: {
                return arg.getGeoShort(null);
            }
            case 16: {
                return arg.getGeoInt(null);
            }
        }
        return arg.getGeoLong(null);
    }
}

