/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToSymbolFunction;
import io.questdb.griffin.engine.functions.constants.SymbolConstant;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;

public class CastShortToSymbolFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(Ek)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function arg = args.getQuick(0);
        if (arg.isConstant()) {
            StringSink sink = Misc.getThreadLocalBuilder();
            sink.put(arg.getShort(null));
            return SymbolConstant.newInstance(sink);
        }
        return new Func(arg);
    }

    private static class Func
    extends AbstractCastToSymbolFunction {
        public Func(Function arg) {
            super(arg);
        }

        @Override
        public int getInt(Record rec) {
            return this.getInt0(this.arg.getShort(rec));
        }

        @Override
        public CharSequence getSymbol(Record rec) {
            return this.getSymbol0(this.arg.getShort(rec));
        }

        @Override
        protected AbstractCastToSymbolFunction newFunc() {
            return new Func(this.arg);
        }
    }
}

