/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.processors;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cutlass.http.HttpConnectionContext;
import io.questdb.cutlass.http.processors.QueryCache;
import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.Rnd;
import io.questdb.std.str.StringSink;
import java.io.Closeable;

public class TextQueryProcessorState
implements Mutable,
Closeable {
    final StringSink query = new StringSink();
    private final HttpConnectionContext httpConnectionContext;
    int columnIndex;
    long count;
    boolean countRows = false;
    RecordCursor cursor;
    char delimiter = (char)44;
    String fileName;
    RecordMetadata metadata;
    boolean noMeta = false;
    boolean pausedQuery = false;
    int queryState = 1;
    Record record;
    RecordCursorFactory recordCursorFactory;
    Rnd rnd;
    long skip;
    long stop;
    private boolean queryCacheable = false;

    public TextQueryProcessorState(HttpConnectionContext httpConnectionContext) {
        this.httpConnectionContext = httpConnectionContext;
    }

    @Override
    public void clear() {
        this.delimiter = (char)44;
        this.fileName = null;
        this.metadata = null;
        this.rnd = null;
        this.record = null;
        this.cursor = Misc.free(this.cursor);
        if (null != this.recordCursorFactory) {
            if (this.queryCacheable) {
                QueryCache.getThreadLocalInstance().push(this.query, this.recordCursorFactory);
            } else {
                this.recordCursorFactory.close();
            }
            this.recordCursorFactory = null;
        }
        this.queryCacheable = false;
        this.query.clear();
        this.queryState = 1;
        this.columnIndex = 0;
        this.skip = 0L;
        this.stop = 0L;
        this.count = 0L;
        this.noMeta = false;
        this.countRows = false;
        this.pausedQuery = false;
    }

    @Override
    public void close() {
        this.cursor = Misc.free(this.cursor);
        this.recordCursorFactory = Misc.free(this.recordCursorFactory);
    }

    public int getFd() {
        return this.httpConnectionContext.getFd();
    }

    void setQueryCacheable(boolean queryCacheable) {
        this.queryCacheable = queryCacheable;
    }
}

