/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.commons.schema.v1;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.minifi.commons.schema.ConnectionSchema;
import org.apache.nifi.minifi.commons.schema.common.BaseSchema;
import org.apache.nifi.minifi.commons.schema.common.ConvertableSchema;
import org.apache.nifi.minifi.commons.schema.common.StringUtil;

public class ConnectionSchemaV1
extends BaseSchema
implements ConvertableSchema<ConnectionSchema> {
    public static final String SOURCE_RELATIONSHIP_NAME_KEY = "source relationship name";
    public static final String DESTINATION_NAME_KEY = "destination name";
    public static final String SOURCE_NAME_KEY = "source name";
    private String name;
    private String sourceRelationshipName;
    private String destinationName;
    private String sourceName;
    private Number maxWorkQueueSize = 0L;
    private String maxWorkQueueDataSize = "0 MB";
    private String flowfileExpiration = "0 sec";
    private String queuePrioritizerClass;

    public ConnectionSchemaV1(Map map) {
        this.name = this.getRequiredKeyAsType(map, "name", String.class, "Connections");
        this.sourceName = this.getRequiredKeyAsType(map, SOURCE_NAME_KEY, String.class, "Connections");
        this.sourceRelationshipName = this.getRequiredKeyAsType(map, SOURCE_RELATIONSHIP_NAME_KEY, String.class, "Connections");
        this.destinationName = this.getRequiredKeyAsType(map, DESTINATION_NAME_KEY, String.class, "Connections");
        this.maxWorkQueueSize = this.getOptionalKeyAsType(map, "max work queue size", Number.class, "Connections", 0L);
        this.maxWorkQueueDataSize = this.getOptionalKeyAsType(map, "max work queue data size", String.class, "Connections", "0 MB");
        this.flowfileExpiration = this.getOptionalKeyAsType(map, "flowfile expiration", String.class, "Connections", "0 sec");
        this.queuePrioritizerClass = this.getOptionalKeyAsType(map, "queue prioritizer class", String.class, "Connections", "");
    }

    @Override
    public ConnectionSchema convert() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.name);
        if (StringUtil.isNullOrEmpty(this.sourceRelationshipName)) {
            map.put("source relationship names", new ArrayList());
        } else {
            map.put("source relationship names", new ArrayList<String>(Arrays.asList(this.sourceRelationshipName)));
        }
        map.put("max work queue size", this.maxWorkQueueSize);
        map.put("max work queue data size", this.maxWorkQueueDataSize);
        map.put("flowfile expiration", this.flowfileExpiration);
        map.put("queue prioritizer class", this.queuePrioritizerClass);
        return new ConnectionSchema(map);
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int getVersion() {
        return 1;
    }
}

